/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.sql.engine.message.QueryStartResponse;
import org.apache.ignite.internal.sql.engine.message.QueryStartResponseBuilder;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesFactory;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesTypeInfos;

class QueryStartResponseDeserializer
implements MessageDeserializer<QueryStartResponse> {
    private final QueryStartResponseBuilder msg;

    QueryStartResponseDeserializer(SqlQueryMessagesFactory messageFactory) {
        this.msg = messageFactory.queryStartResponse();
    }

    public Class<QueryStartResponse> klass() {
        return QueryStartResponse.class;
    }

    public QueryStartResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(SqlQueryMessagesTypeInfos.queryStartResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte[] tmp = reader.readByteArray("errorByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.errorByteArray(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("executionToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.executionToken(tmp);
                reader.incrementState();
            }
            case 2: {
                long tmp = reader.readLong("fragmentId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.fragmentId(tmp);
                reader.incrementState();
            }
            case 3: {
                UUID tmp = reader.readUuid("queryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.queryId(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(QueryStartResponse.class);
    }
}

