/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.internal.sql.engine.api.expressions.RowAccessor;
import org.apache.ignite.internal.sql.engine.api.expressions.RowFactory;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AccumulatorWrapper;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AccumulatorsState;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AggregateRow;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowQueue;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowSet;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;

public class SortAggregateNode<RowT>
extends AbstractNode<RowT>
implements SingleNode<RowT>,
Downstream<RowT> {
    private final AggregateType type;
    private final RowFactory<RowT> rowFactory;
    private final ImmutableBitSet grpSet;
    private final Comparator<RowT> comp;
    private final RowQueue<RowT> outBuf;
    private final List<AccumulatorWrapper<RowT>> accs;
    private RowT prevRow;
    private Group grp;
    private int requested;
    private int waiting;
    private int cmpRes;
    private boolean inLoop;

    public SortAggregateNode(ExecutionContext<RowT> ctx, AggregateType type, ImmutableBitSet grpSet, List<AccumulatorWrapper<RowT>> accumulators, RowFactory<RowT> rowFactory, Comparator<RowT> comp) {
        super(ctx);
        assert (Objects.nonNull(comp));
        this.outBuf = ctx.storageFactory().queue((RowHandler<RowT>)ctx.rowAccessor(), rowFactory, this.inBufSize);
        this.type = type;
        this.rowFactory = rowFactory;
        this.grpSet = grpSet;
        this.comp = comp;
        this.accs = accumulators;
        this.init();
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0 && this.requested == 0);
        this.requested = rowsCnt;
        if (this.waiting == 0) {
            this.waiting = this.inBufSize;
            this.source().request(this.waiting);
        } else if (!this.inLoop) {
            this.execute(this::doFlush);
        }
    }

    @Override
    public void push(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        --this.waiting;
        if (this.grp != null) {
            int cmp = this.comp.compare(row, this.prevRow);
            if (cmp == 0) {
                this.grp.add(row);
            } else {
                if (this.cmpRes == 0) {
                    this.cmpRes = cmp;
                } else assert (Integer.signum(cmp) == Integer.signum(this.cmpRes)) : "Input not sorted";
                this.outBuf.add(this.grp.row());
                this.grp.release();
                this.grp = this.newGroup(row);
                this.flush();
            }
        } else {
            this.grp = this.newGroup(row);
        }
        this.prevRow = row;
        if (this.waiting == 0 && this.requested > 0) {
            this.waiting = this.inBufSize;
            this.source().request(this.inBufSize);
        }
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.waiting = -1;
        if (this.grp != null) {
            this.outBuf.add(this.grp.row());
        }
        this.flush();
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waiting = 0;
        if (this.grp != null) {
            this.grp.release();
        }
        this.grp = null;
        this.prevRow = null;
        this.init();
    }

    @Override
    protected void closeInternal() {
        super.closeInternal();
        if (this.grp != null) {
            this.grp.release();
        }
        this.grp = null;
    }

    private void init() {
        if (AggregateRow.addEmptyGroup(this.grpSet, this.type)) {
            this.grp = new Group(ArrayUtils.OBJECT_EMPTY_ARRAY);
        }
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    protected void dumpDebugInfo0(IgniteStringBuilder buf) {
        buf.app("class=").app(this.getClass().getSimpleName()).app(", requested=").app(this.requested).app(", waiting=").app(this.waiting);
    }

    private Group newGroup(RowT r) {
        RowAccessor rowHandler = this.context().rowAccessor();
        ObjectArrayList grpKeys = new ObjectArrayList(this.grpSet.cardinality());
        this.grpSet.forEachInt(arg_0 -> SortAggregateNode.lambda$newGroup$0(grpKeys, (RowHandler)rowHandler, r, arg_0));
        Group grp = new Group(grpKeys.elements());
        grp.add(r);
        return grp;
    }

    private void doFlush() throws Exception {
        this.flush();
    }

    private void flush() throws Exception {
        this.inLoop = true;
        try {
            while (this.requested > 0 && !this.outBuf.isEmpty()) {
                --this.requested;
                RowT row = this.outBuf.remove();
                this.acquireRow(row);
                this.downstream().push(row);
                this.releaseRow(row);
            }
        }
        finally {
            this.inLoop = false;
        }
        if (this.requested > 0 && this.waiting == -1 && this.outBuf.isEmpty()) {
            this.requested = 0;
            this.downstream().end();
            this.grp = null;
            this.prevRow = null;
        }
    }

    private static /* synthetic */ void lambda$newGroup$0(ObjectArrayList grpKeys, RowHandler rowHandler, Object r, int fldIdx) {
        grpKeys.add(rowHandler.get(fldIdx, r));
    }

    private class Group {
        private final Object[] grpKeys;
        private final AggregateRow<RowT> aggRow;
        private final List<RowSet<Object>> distinctSets = new ArrayList<RowSet<Object>>();
        private final AccumulatorsState state;

        private Group(Object[] grpKeys) {
            this.grpKeys = grpKeys;
            for (int i = 0; i < SortAggregateNode.this.accs.size(); ++i) {
                AccumulatorWrapper acc = SortAggregateNode.this.accs.get(i);
                if (acc.isDistinct()) {
                    List<NativeType> argTypes = acc.getArgumentTypes();
                    NativeType elementType = argTypes.get(0);
                    if (elementType == NativeTypes.NULL) {
                        this.distinctSets.add(SortAggregateNode.this.context().storageFactory().hashSet(Object.class, NativeTypes.INT32));
                        continue;
                    }
                    this.distinctSets.add(SortAggregateNode.this.context().storageFactory().hashSet(Object.class, elementType));
                    continue;
                }
                this.distinctSets.add(null);
            }
            this.aggRow = new AggregateRow(-1, SortAggregateNode.this.grpSet, SortAggregateNode.this.type, SortAggregateNode.this.accs);
            this.state = new AccumulatorsState(SortAggregateNode.this.accs.size());
        }

        private void add(RowT row) {
            this.aggRow.update(this.state, SortAggregateNode.this.grpSet, (RowHandler)SortAggregateNode.this.context().rowAccessor(), row, this.distinctSets, SortAggregateNode.this.context().memoryContext());
        }

        private RowT row() {
            Object[] fields = this.aggRow.createOutput();
            int i = 0;
            for (Object grpKey : this.grpKeys) {
                fields[i++] = grpKey;
            }
            this.aggRow.writeTo(this.state, SortAggregateNode.this.grpSet, fields);
            return SortAggregateNode.this.rowFactory.create(fields);
        }

        private void release() {
            for (RowSet<Object> distinctSet : this.distinctSets) {
                if (distinctSet == null) continue;
                distinctSet.close();
            }
        }
    }
}

