/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.query;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.InternalSqlRowStringsList;
import org.apache.ignite.internal.sql.engine.prepare.show.ShowCommand;
import org.apache.ignite.internal.sql.engine.prepare.show.ShowGrantsCommand;
import org.apache.ignite.internal.sql.engine.prepare.show.ShowPrivilegesGrantsCommand;
import org.apache.ignite.internal.sql.engine.prepare.show.ShowRoleCommand;
import org.apache.ignite.internal.sql.engine.prepare.show.ShowRolesCommand;
import org.apache.ignite.internal.sql.engine.prepare.show.ShowUserCommand;
import org.apache.ignite.internal.sql.engine.prepare.show.ShowUsersCommand;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.gridgain.internal.rbac.Rbac;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.Selector;
import org.gridgain.internal.rbac.roles.Role;
import org.gridgain.internal.rbac.roles.exception.RoleNotFoundException;
import org.gridgain.internal.rbac.users.User;
import org.gridgain.internal.security.context.GridGainSecurity;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;
import org.jetbrains.annotations.Nullable;

public class ShowHandler {
    private final Rbac rbac;

    public ShowHandler(Rbac rbac) {
        this.rbac = rbac;
    }

    public CompletableFuture<Iterator<InternalSqlRow>> handle(ShowCommand command) {
        if (command instanceof ShowUserCommand) {
            return this.handleShowUser((ShowUserCommand)command);
        }
        if (command instanceof ShowUsersCommand) {
            return this.handleShowUsers();
        }
        if (command instanceof ShowRoleCommand) {
            return this.handleShowRole((ShowRoleCommand)command);
        }
        if (command instanceof ShowRolesCommand) {
            return this.handleShowRoles();
        }
        if (command instanceof ShowGrantsCommand) {
            return this.handleShowGrants((ShowGrantsCommand)command);
        }
        if (command instanceof ShowPrivilegesGrantsCommand) {
            return this.handleShowPrivilegesGrants((ShowPrivilegesGrantsCommand)command);
        }
        return CompletableFuture.failedFuture((Throwable)new IgniteInternalCheckedException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unsupported SHOW command [cmdName=" + (command == null ? null : command.getClass().getSimpleName()) + "; cmd=\"" + command + "\"]"));
    }

    private CompletableFuture<Iterator<InternalSqlRow>> handleShowUser(ShowUserCommand command) {
        return this.rbac.roleAssignmentManagement().rolesByUserAsync(command.username()).thenApply(roles -> List.of(ShowHandler.assignmentToRow(command.username(), roles)).iterator());
    }

    private CompletableFuture<Iterator<InternalSqlRow>> handleShowUsers() {
        return this.rbac.roleAssignmentManagement().usersViewsAsync().thenApply(userViews -> userViews.entrySet().stream().map(entry -> ShowHandler.assignmentToRow(((User)entry.getKey()).username(), (Set)entry.getValue())).iterator());
    }

    private CompletableFuture<Iterator<InternalSqlRow>> handleShowRole(ShowRoleCommand command) {
        return this.rbac.privilegeManagement().getPrivilegesAsync(command.name()).thenApply(privileges -> ShowHandler.privilegesToRow(command.name(), privileges).iterator());
    }

    private CompletableFuture<Iterator<InternalSqlRow>> handleShowRoles() {
        return this.rbac.privilegeManagement().getRolesWithPrivilegesAsync().thenApply(rolesWithPrivileges -> rolesWithPrivileges.entrySet().stream().map(entry -> ShowHandler.privilegesToRow((String)entry.getKey(), (Set)entry.getValue())).flatMap(Collection::stream).iterator());
    }

    private CompletableFuture<Iterator<InternalSqlRow>> handleShowGrants(ShowGrantsCommand command) {
        String name = command.name();
        if (name == null) {
            return this.handleShowAllGrants();
        }
        SecurityContext securityContext = SecurityContextHolder.getOrThrow();
        return ((CompletableFuture)this.handleShowRoleGrants(name).handle((T result, U throwable) -> {
            if (throwable == null) {
                return CompletableFuture.completedFuture(result);
            }
            Throwable cause = ExceptionUtils.unwrapCause((Throwable)throwable);
            if (cause instanceof RoleNotFoundException) {
                return (CompletableFuture)GridGainSecurity.getWith((SecurityContext)securityContext, () -> this.handleShowUserGrants(name));
            }
            throw new CompletionException(cause);
        })).thenCompose(Function.identity());
    }

    private CompletableFuture<Iterator<InternalSqlRow>> handleShowAllGrants() {
        return this.rbac.roleAssignmentManagement().usersViewsAsync().thenApply(userViews -> userViews.entrySet().stream().map(entry -> ShowHandler.assignmentsToRow(((User)entry.getKey()).username(), (Set)entry.getValue())).flatMap(Collection::stream).iterator());
    }

    private CompletableFuture<Iterator<InternalSqlRow>> handleShowRoleGrants(String role) {
        return this.rbac.roleAssignmentManagement().usersByRoleAsync(role).thenApply(users -> ShowHandler.assignmentsToRow(users, role).iterator());
    }

    private CompletableFuture<Iterator<InternalSqlRow>> handleShowUserGrants(String user) {
        return this.rbac.roleAssignmentManagement().rolesByUserAsync(user).thenApply(roles -> ShowHandler.assignmentsToRow(user, roles).iterator());
    }

    private CompletableFuture<Iterator<InternalSqlRow>> handleShowPrivilegesGrants(ShowPrivilegesGrantsCommand command) {
        return this.rbac.privilegeManagement().getPrivilegesAsync(command.roleName()).thenApply(privileges -> ShowHandler.privilegesToRow(command.roleName(), privileges).iterator());
    }

    private static List<InternalSqlRow> privilegesToRow(String roleName, Set<Privilege> privileges) {
        if (privileges.isEmpty()) {
            return List.of(ShowHandler.privilegeToRow(roleName, null));
        }
        return privileges.stream().map(privilege -> ShowHandler.privilegeToRow(roleName, privilege)).collect(Collectors.toList());
    }

    private static InternalSqlRow privilegeToRow(String roleName, @Nullable Privilege privilege) {
        return new InternalSqlRowStringsList(List.of(roleName.toUpperCase(), privilege != null ? privilege.action().name().toUpperCase() : "", privilege != null ? ShowHandler.selectorToString(privilege.selector()).toUpperCase() : ""));
    }

    private static String selectorToString(Selector selector) {
        String rawString = selector.toRawString();
        return rawString != null ? rawString : "CLUSTER";
    }

    private static List<InternalSqlRow> assignmentsToRow(String user, Set<Role> roles) {
        return roles.stream().map(role -> ShowHandler.assignmentToRow(user, role.name())).collect(Collectors.toList());
    }

    private static List<InternalSqlRow> assignmentsToRow(Set<User> users, String role) {
        return users.stream().map(user -> ShowHandler.assignmentToRow(user.username(), role)).collect(Collectors.toList());
    }

    private static InternalSqlRow assignmentToRow(String user, String role) {
        return new InternalSqlRowStringsList(List.of(user.toUpperCase(), role.toUpperCase()));
    }

    private static InternalSqlRow assignmentToRow(String user, Set<Role> roles) {
        return new InternalSqlRowStringsList(List.of(user.toUpperCase(), ShowHandler.joinRoles(roles)));
    }

    private static String joinRoles(Set<Role> roles) {
        StringJoiner joiner = new StringJoiner(", ");
        for (Role role : roles) {
            joiner.add(role.name().toUpperCase());
        }
        return joiner.toString();
    }
}

