/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.file;

import java.util.Iterator;
import org.apache.ignite.internal.fileio.FileIoFactory;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.InternalTupleEx;
import org.apache.ignite.internal.sql.engine.api.expressions.RowFactory;
import org.apache.ignite.internal.sql.engine.api.expressions.RowFactoryFactory;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowHashJoinIndex;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.DataDirectory;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.ExternalHashJoinTable;
import org.apache.ignite.internal.sql.engine.util.ProjectedTuple;
import org.apache.ignite.internal.type.StructNativeType;
import org.apache.ignite.internal.util.TransformingIterator;
import org.jetbrains.annotations.TestOnly;

class RowHashJoinIndexImpl<RowT>
implements RowHashJoinIndex<RowT, RowT> {
    private static final int INITIAL_CAPACITY = 128;
    private final ExternalHashJoinTable externalHashIndex;
    private final RowFactory<RowT> rowFactory;
    private final RowHandler<RowT> handler;
    private final int[] keyFields;

    RowHashJoinIndexImpl(DataDirectory workDir, FileIoFactory fileIoFactory, RowFactoryFactory<RowT> rowFactory, RowHandler<RowT> rowHandler, StructNativeType rowType, int[] keyFields) {
        this.rowFactory = rowFactory.create(rowType);
        this.keyFields = keyFields;
        this.handler = rowHandler;
        this.externalHashIndex = new ExternalHashJoinTable(workDir, fileIoFactory, 128, rowType.fieldsCount(), keyFields);
    }

    @Override
    public boolean contains(RowT key) {
        return this.externalHashIndex.contains(this.handler.toBinaryTuple(key));
    }

    @Override
    public Iterator<RowT> lookup(RowT key) {
        BinaryTuple keyTuple = this.handler.toBinaryTuple(key);
        Iterator<BinaryTuple> iter = this.externalHashIndex.lookup(keyTuple);
        return new TransformingIterator(iter, arg_0 -> this.rowFactory.create(arg_0));
    }

    @Override
    public Iterator<RowT> untouchedIterator() {
        return new TransformingIterator(this.externalHashIndex.untouchedIterator(), arg_0 -> this.rowFactory.create(arg_0));
    }

    @Override
    public void add(RowT element) {
        BinaryTuple valueTuple = this.handler.toBinaryTuple(element);
        BinaryTuple keyTuple = RowHashJoinIndexImpl.extractKey(valueTuple, this.keyFields);
        this.externalHashIndex.put(keyTuple, valueTuple);
    }

    @Override
    public void addEntry(RowHashJoinIndex.IndexEntry<RowT> entry) {
        BinaryTuple valueTuple = this.handler.toBinaryTuple(entry.row());
        BinaryTuple keyTuple = RowHashJoinIndexImpl.extractKey(valueTuple, this.keyFields);
        this.externalHashIndex.put(keyTuple, valueTuple, entry.touched());
    }

    private static BinaryTuple extractKey(BinaryTuple row, int[] keyFields) {
        ProjectedTuple tuple = new ProjectedTuple((InternalTupleEx)row, keyFields);
        return new BinaryTuple(keyFields.length, tuple.byteBuffer());
    }

    @Override
    public int size() {
        return this.externalHashIndex.size();
    }

    @Override
    public void clear() {
        this.externalHashIndex.reset();
    }

    @Override
    public boolean isEmpty() {
        return this.externalHashIndex.size() == 0;
    }

    @Override
    @TestOnly
    public Iterator<RowT> iterator() {
        return new TransformingIterator(this.externalHashIndex.iterator(), arg_0 -> this.rowFactory.create(arg_0));
    }

    public void close() throws Exception {
        this.externalHashIndex.close();
    }
}

