/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.file;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.ignite.internal.fileio.FileIoFactory;
import org.apache.ignite.internal.fileio.RandomAccessFileIoFactory;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.engine.api.expressions.RowFactory;
import org.apache.ignite.internal.sql.engine.api.expressions.RowFactoryFactory;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.KeyValueCodec;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowHashJoinIndex;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowHashTable;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowList;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowQueue;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowSet;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowStorageFactory;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.SingleNativeTypeValueCodec;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.BoundedSortedRowQueueImpl;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.DataDirectory;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.FileIoTracker;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.RowHashJoinIndexImpl;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.RowHashTableImpl;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.RowListImpl;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.RowQueueImpl;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.RowSetImpl;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.SortedRowQueueImpl;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.TrackableFileIoFactory;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.StructNativeType;

public class FileRowStorageFactoryImpl<RowT>
implements RowStorageFactory<RowT> {
    private static final IgniteLogger log = Loggers.forClass(FileRowStorageFactoryImpl.class);
    private final DataDirectory workDir;
    private final FileIoTracker fileIoTracker;
    private final FileIoFactory fileIoFactory;

    public FileRowStorageFactoryImpl(DataDirectory workDir, FileIoTracker fileIoTracker) {
        this.workDir = workDir;
        this.fileIoTracker = fileIoTracker;
        this.fileIoFactory = new TrackableFileIoFactory((FileIoFactory)new RandomAccessFileIoFactory(), fileIoTracker);
    }

    @Override
    public RowList<RowT> list(RowHandler<RowT> rowHandler, RowFactory<RowT> rowFactory) {
        return new RowListImpl<RowT>(this.workDir, this.fileIoFactory, rowHandler, rowFactory);
    }

    @Override
    public RowList<RowT> list(RowHandler<RowT> rowHandler, RowFactory<RowT> rowFactory, int initialCapacity) {
        return this.list(rowHandler, rowFactory);
    }

    @Override
    public RowQueue<RowT> queue(RowHandler<RowT> rowHandler, RowFactory<RowT> rowFactory, int initialCapacity) {
        assert (rowFactory.rowSchema().fieldsCount() > 0);
        return new RowQueueImpl<RowT>(this.workDir, this.fileIoFactory, rowHandler, rowFactory, initialCapacity);
    }

    @Override
    public RowQueue<RowT> priorityQueue(RowHandler<RowT> rowHandler, RowFactory<RowT> rowFactory, Comparator<RowT> valueComparator, Comparator<ByteBuffer> tupleComp) {
        return new SortedRowQueueImpl<RowT>(this.workDir, this.fileIoFactory, rowHandler, rowFactory, tupleComp);
    }

    @Override
    public RowQueue<RowT> boundedPriorityQueue(RowHandler<RowT> rowHandler, RowFactory<RowT> rowFactory, int capacity, Comparator<RowT> valueComparator, Comparator<ByteBuffer> tupleComp) {
        return new BoundedSortedRowQueueImpl<RowT>(this.workDir, this.fileIoFactory, rowHandler, rowFactory, tupleComp, capacity);
    }

    @Override
    public <K, V> RowHashTable<K, V> hashTable(KeyValueCodec<K, V> keyValueCodec) {
        return new RowHashTableImpl(this.workDir, this.fileIoFactory, keyValueCodec);
    }

    @Override
    public <E> RowSet<E> hashSet(Class<E> elementClass, NativeType elementType) {
        return this.hashSet(new SingleNativeTypeValueCodec<E>(elementClass, elementType));
    }

    @Override
    public <E> RowSet<E> hashSet(KeyValueCodec<E, Void> codec) {
        return new RowSetImpl<E>(this.workDir, this.fileIoFactory, codec);
    }

    @Override
    public RowHashJoinIndex<RowT, RowT> hashJoinIndex(RowFactoryFactory<RowT> rowFactory, RowHandler<RowT> rowHandler, StructNativeType rowType, int[] keyFields) {
        return new RowHashJoinIndexImpl<RowT>(this.workDir, this.fileIoFactory, rowFactory, rowHandler, rowType, keyFields);
    }

    @Override
    public void close() throws Exception {
        this.fileIoTracker.close();
        if (!this.workDir.deleteIfExists()) {
            log.info("Unable to delete spill data directory: {}", new Object[]{this.workDir});
        }
    }
}

