/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.file;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.ToIntFunction;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite.internal.fileio.FileIo;
import org.apache.ignite.internal.fileio.FileIoFactory;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.InternalTupleEx;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.DataDirectory;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.ExternalCollectionUtils;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.ExternalFileStore;
import org.apache.ignite.internal.sql.engine.util.ProjectedTuple;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.TransformingIterator;
import org.apache.ignite.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ExternalHashJoinTable
implements AutoCloseable {
    private static final IgniteLogger log = Loggers.forClass(ExternalHashJoinTable.class);
    private static final double LOAD_FACTOR = 0.5;
    private static final long MAX_CAPACITY = 0x400000000000000L;
    private static final long UNTOUCHED_FLAG = Long.MIN_VALUE;
    static final int ENTRY_SIZE = 12;
    static final int LIST_NODE_HEADER_SIZE = 8;
    private static final long NULL_ADDRESS = -1L;
    private static final BinaryTuple EMPTY_KEY = new BinaryTuple(0, new BinaryTupleBuilder(0, 0).build());
    private final FileIoFactory fileIoFactory;
    private final DataDirectory workDir;
    private final ByteBuffer reusableBuff = ByteBuffer.allocate(12);
    private final Comparator<BinaryTuple> keyComparator = Comparator.comparing(BinaryTupleParser::byteBuffer);
    private final ToIntFunction<BinaryTuple> hashFunction = k -> k == null ? 0 : k.byteBuffer().hashCode();
    private final int[] keyFields;
    private final int rowColumnsCount;
    private final ExternalFileStore rowDataStore;
    private final long initialCapacity;
    private ByteBuffer rowBuffer = ExternalHashJoinTable.allocateNewBuffer(128);
    private FileIo fileIo;
    private Path file;
    private long capacity;
    private int usedSlots;
    private boolean isClosed = false;

    public ExternalHashJoinTable(DataDirectory workDir, FileIoFactory fileIoFactory, int capacity, int columnsCount, int[] keyFields) {
        this.workDir = workDir;
        this.fileIoFactory = fileIoFactory;
        this.rowColumnsCount = columnsCount;
        this.capacity = this.initialCapacity = (long)capacity;
        this.keyFields = keyFields;
        this.rowDataStore = new ExternalFileStore(fileIoFactory, workDir, columnsCount);
        this.initNewIndexFile(capacity);
    }

    public synchronized boolean contains(BinaryTuple key) {
        this.checkCancelled();
        if (ExternalHashJoinTable.hasNullFieldsOrEmpty(key)) {
            return false;
        }
        TableEntry entry = this.findEntry(key, this.getHashCode(key));
        return entry != null;
    }

    public synchronized Iterator<BinaryTuple> lookup(BinaryTuple key) {
        this.checkCancelled();
        if (ExternalHashJoinTable.hasNullFieldsOrEmpty(key)) {
            return Collections.emptyIterator();
        }
        int hashCode = this.getHashCode(key);
        TableEntry entry = this.findEntry(key, hashCode);
        if (entry == null) {
            return Collections.emptyIterator();
        }
        ListIterator iterator = new ListIterator(entry.rowAddress(), true);
        return new TransformingIterator((Iterator)iterator, node -> new BinaryTuple(this.rowColumnsCount, node.rowContent));
    }

    public void put(BinaryTuple key, BinaryTuple row) {
        this.put(key, row, false);
    }

    public synchronized void put(BinaryTuple key, BinaryTuple row, boolean touched) {
        this.checkCancelled();
        if (ExternalHashJoinTable.hasNullFieldsOrEmpty(key)) {
            key = EMPTY_KEY;
        }
        int hashCode = this.getHashCode(key);
        TableEntry entry = this.findEntry(key, hashCode);
        ByteBuffer valueBuff = row.byteBuffer();
        ByteBuffer rowBuffer = this.allocateRowBuffer(8 + valueBuff.remaining());
        long nextNodeAddress = entry == null ? -1L : entry.rowAddress();
        rowBuffer.putLong(touched ? nextNodeAddress & Long.MAX_VALUE : nextNodeAddress | Long.MIN_VALUE);
        rowBuffer.put(valueBuff);
        rowBuffer.flip();
        long newRowAddress = this.rowDataStore.write(rowBuffer);
        if (entry == null) {
            this.ensureCapacity();
            this.putEntryToFreeSlot(hashCode, newRowAddress);
        } else {
            this.writeEntryToIndexFile(entry.slot, hashCode, newRowAddress);
        }
    }

    public synchronized Iterator<BinaryTuple> untouchedIterator() {
        this.checkCancelled();
        return new TransformingIterator((Iterator)new Iterator<ListNode>(){
            final TableIterator tableIterator;
            Iterator<ListNode> listIterator;
            {
                this.tableIterator = new TableIterator(ExternalHashJoinTable.this.capacity);
                this.listIterator = Collections.emptyIterator();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                ExternalHashJoinTable externalHashJoinTable = ExternalHashJoinTable.this;
                synchronized (externalHashJoinTable) {
                    this.advance();
                    return this.listIterator.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ListNode next() {
                ExternalHashJoinTable externalHashJoinTable = ExternalHashJoinTable.this;
                synchronized (externalHashJoinTable) {
                    this.advance();
                    return this.listIterator.next();
                }
            }

            void advance() {
                ExternalHashJoinTable.this.checkCancelled();
                while (!this.listIterator.hasNext() && this.tableIterator.hasNext()) {
                    TableEntry tableEntry = this.tableIterator.next();
                    assert (tableEntry != null && !tableEntry.isEmpty());
                    this.listIterator = new ListIterator(tableEntry.rowAddress(), false);
                }
            }
        }, node -> new BinaryTuple(this.rowColumnsCount, node.rowContent));
    }

    @TestOnly
    public Iterator<BinaryTuple> iterator() {
        this.checkCancelled();
        ExternalFileStore.RowReader rowReader = (rowSize, reader) -> {
            ByteBuffer buffer = this.allocateRowBuffer(rowSize);
            reader.accept(buffer);
            buffer.flip();
        };
        return new TransformingIterator(this.rowDataStore.rowIterator(rowReader, this.rowBuffer), inBuf -> {
            inBuf.getLong();
            ByteBuffer valueBuffer = ByteBuffer.allocate(inBuf.remaining()).order(inBuf.order());
            valueBuffer.put((ByteBuffer)inBuf);
            valueBuffer.flip();
            return new BinaryTuple(this.rowColumnsCount, valueBuffer);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Path idxFile;
        ExternalHashJoinTable externalHashJoinTable = this;
        synchronized (externalHashJoinTable) {
            this.checkCancelled();
            idxFile = this.file;
            this.capacity = this.initialCapacity;
            this.usedSlots = 0;
            this.reusableBuff.clear();
            try {
                this.fileIo.clear();
                this.fileIo.write(ByteBuffer.allocate(1), this.capacity * 12L - 1L);
            }
            catch (IOException e) {
                this.close();
                throw ExternalCollectionUtils.accessFailedException(e);
            }
            this.rowDataStore.reset();
        }
        if (log.isDebugEnabled()) {
            log.debug("External row store file cleaned: " + idxFile.getFileName(), new Object[0]);
        }
    }

    public synchronized int size() {
        this.checkCancelled();
        return this.rowDataStore.size();
    }

    private int getHashCode(BinaryTuple row) {
        return this.hashFunction.applyAsInt(row);
    }

    private BinaryTuple extractKey(BinaryTuple row) {
        BinaryTuple key = new BinaryTuple(this.keyFields.length, new ProjectedTuple((InternalTupleEx)row, this.keyFields).byteBuffer());
        return ExternalHashJoinTable.hasNullFieldsOrEmpty(key) ? EMPTY_KEY : key;
    }

    private long putEntryToFreeSlot(int hashCode, long rowAddr) {
        long slot = this.findFreeSlotForInsert(hashCode);
        this.writeEntryToIndexFile(slot, hashCode, rowAddr);
        ++this.usedSlots;
        return slot;
    }

    private long findFreeSlotForInsert(int hashCode) {
        long slot;
        long startSlot = slot = this.slot(hashCode);
        while (!this.readEntryFromIndexFile(slot).isEmpty()) {
            if ((slot = (slot + 1L) % this.capacity) != startSlot) continue;
            throw new IllegalStateException("Failed to find an empty slot in hash table.");
        }
        return slot;
    }

    private long slot(long hashCode) {
        long hc64 = hashCode << 48 ^ hashCode << 32 ^ hashCode << 16 ^ hashCode;
        return hc64 & this.capacity - 1L;
    }

    @Nullable
    private TableEntry findEntry(BinaryTuple key, int hashCode) {
        long slot;
        long initialSlot = slot = this.slot(hashCode);
        TableEntry entry = this.readEntryFromIndexFile(slot);
        while (!entry.isEmpty()) {
            if (hashCode == entry.hash()) {
                ListNode listNode = this.readListNode(entry.rowAddress(), false);
                BinaryTuple foundRow = new BinaryTuple(this.rowColumnsCount, listNode.rowContent);
                assert (foundRow != null);
                BinaryTuple foundKey = this.extractKey(foundRow);
                if (this.keyComparator.compare(key, foundKey) == 0) break;
            }
            if ((slot = (slot + 1L) % this.capacity) == initialSlot) {
                return null;
            }
            entry = this.readEntryFromIndexFile(slot);
        }
        return entry.isEmpty() ? null : entry;
    }

    private ByteBuffer allocateRowBuffer(int size) {
        if (this.rowBuffer.capacity() < size) {
            this.rowBuffer = ByteBuffer.allocate(size).order(BinaryTupleParser.ORDER);
        } else {
            this.rowBuffer.clear();
            this.rowBuffer.limit(size);
        }
        return this.rowBuffer;
    }

    private TableEntry readEntryFromIndexFile(long slot) {
        return this.readEntryFromIndexFile(slot, this.fileIo);
    }

    private TableEntry readEntryFromIndexFile(long slot, FileIo fileCh) {
        try {
            if (slot != -1L) {
                this.gotoSlot(slot);
            } else {
                slot = fileCh.position() / 12L;
            }
            if (slot >= this.capacity || slot < 0L) {
                throw new IndexOutOfBoundsException("HashTable bin index out of range: " + slot);
            }
            this.reusableBuff.clear();
            fileCh.readFully(this.reusableBuff);
            this.reusableBuff.flip();
            int hashCode = this.reusableBuff.getInt();
            long addr = this.reusableBuff.getLong() - 1L;
            return new TableEntry(hashCode, addr, slot);
        }
        catch (IOException e) {
            IgniteUtils.closeQuiet((AutoCloseable)this);
            throw ExternalCollectionUtils.accessFailedException(e);
        }
    }

    private void writeEntryToIndexFile(long slot, int hashCode, long addr) {
        try {
            this.gotoSlot(slot);
            this.reusableBuff.clear();
            this.reusableBuff.putInt(hashCode);
            this.reusableBuff.putLong(addr + 1L);
            this.reusableBuff.flip();
            this.fileIo.writeFully(this.reusableBuff);
        }
        catch (IOException e) {
            IgniteUtils.closeQuiet((AutoCloseable)this);
            throw ExternalCollectionUtils.accessFailedException(e);
        }
    }

    private void gotoSlot(long slot) {
        try {
            this.fileIo.position(slot * 12L);
        }
        catch (IOException e) {
            IgniteUtils.closeQuiet((AutoCloseable)this);
            throw ExternalCollectionUtils.accessFailedException(e);
        }
    }

    private static boolean validNodeAddress(long nodeAddress) {
        return (nodeAddress | Long.MIN_VALUE) != -1L;
    }

    private ListNode readListNode(long nodeAddress, boolean touch) {
        assert (ExternalHashJoinTable.validNodeAddress(nodeAddress)) : nodeAddress;
        ExternalFileStore.RowReader rowReader = (rowSize, reader) -> {
            ByteBuffer buffer = this.allocateRowBuffer(rowSize);
            reader.accept(buffer);
            buffer.flip();
        };
        this.rowDataStore.read(nodeAddress, rowReader);
        long nextNodeAddress = this.rowBuffer.getLong();
        ByteBuffer buffer = ByteBuffer.allocate(this.rowBuffer.remaining()).order(this.rowBuffer.order());
        buffer.put(this.rowBuffer);
        buffer.flip();
        if (touch) {
            ExternalFileStore.RowWriter rowWriter = writer -> {
                ByteBuffer buf = this.allocateRowBuffer(8);
                buf.putLong(nextNodeAddress & Long.MAX_VALUE);
                buf.flip();
                writer.accept(buf);
            };
            this.rowDataStore.update(nodeAddress, rowWriter);
        }
        return new ListNode(nextNodeAddress, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCapacity() {
        if ((double)this.usedSlots <= 0.5 * (double)this.capacity) {
            return;
        }
        FileIo oldFileIo = this.fileIo;
        File oldIdxFile = this.file.toFile();
        long oldSize = this.capacity;
        try {
            this.initNewIndexFile(oldSize * 2L);
            this.copyDataFromOldFile(oldFileIo, oldSize);
        }
        finally {
            IgniteUtils.closeQuiet((AutoCloseable)oldFileIo);
            this.deleteUnusedFile(oldIdxFile);
        }
    }

    private void copyDataFromOldFile(FileIo oldFile, long oldSize) {
        try {
            this.usedSlots = 0;
            oldFile.position(0L);
            for (long i = 0L; i < oldSize; ++i) {
                TableEntry e = this.readEntryFromIndexFile(-1L, oldFile);
                if (e.isEmpty()) continue;
                this.putEntryToFreeSlot(e.hash(), e.rowAddress());
            }
        }
        catch (IOException e) {
            IgniteUtils.closeQuiet((AutoCloseable)oldFile);
            IgniteUtils.closeQuiet((AutoCloseable)this);
            throw ExternalCollectionUtils.accessFailedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initNewIndexFile(long cap) {
        try {
            assert (cap > 0L && (cap & cap - 1L) == 0L) : "cap=" + cap;
            if (cap > 0x400000000000000L) {
                throw new IllegalArgumentException("Maximum capacity is exceeded [curCapacity=" + cap + ", maxCapacity=288230376151711744]");
            }
            Path newFile = this.workDir.createFile("hashIdx");
            ExternalHashJoinTable externalHashJoinTable = this;
            synchronized (externalHashJoinTable) {
                this.capacity = cap;
                this.file = newFile;
                this.fileIo = this.fileIoFactory.create(this.file, new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE});
                this.reusableBuff.clear();
                this.fileIo.write(this.reusableBuff, (cap - 1L) * 12L);
            }
        }
        catch (IOException e) {
            this.close();
            throw ExternalCollectionUtils.accessFailedException(e);
        }
    }

    private void checkCancelled() {
        if (this.isClosed) {
            throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Hash join index store has been closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ExternalHashJoinTable externalHashJoinTable = this;
        synchronized (externalHashJoinTable) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        IgniteUtils.closeQuiet((AutoCloseable)this.fileIo);
        this.rowDataStore.close();
        this.deleteUnusedFile(this.file.toFile());
    }

    private void deleteUnusedFile(File file) {
        if (!file.delete()) {
            log.info("Failed to remove spill file " + file.getName(), new Object[0]);
        } else if (log.isDebugEnabled()) {
            log.debug("Spill file removed " + file.getName(), new Object[0]);
        }
    }

    private static boolean hasNullFieldsOrEmpty(@Nullable BinaryTuple key) {
        if (key == null || key.elementCount() == 0) {
            return true;
        }
        for (int i = 0; i < key.elementCount(); ++i) {
            if (!key.hasNullValue(i)) continue;
            return true;
        }
        return false;
    }

    private static ByteBuffer allocateNewBuffer(int capacity) {
        return ByteBuffer.allocate(capacity).order(BinaryTupleParser.ORDER);
    }

    private static class TableEntry {
        private final int hashCode;
        private final long nodeAddress;
        private final long slot;

        TableEntry(int hashCode, long rowAddress, long slot) {
            this.hashCode = hashCode;
            this.nodeAddress = rowAddress;
            this.slot = slot;
        }

        int hash() {
            return this.hashCode;
        }

        long rowAddress() {
            return this.nodeAddress;
        }

        long slot() {
            return this.slot;
        }

        boolean isEmpty() {
            return this.nodeAddress == -1L;
        }
    }

    private class ListIterator
    implements Iterator<ListNode> {
        private final boolean touch;
        long nextNodeAddress;
        ListNode currentNode;

        ListIterator(long headNodeAddress, boolean touch) {
            this.nextNodeAddress = headNodeAddress;
            this.touch = touch;
        }

        @Override
        public boolean hasNext() {
            this.advance();
            return this.currentNode != null;
        }

        @Override
        public ListNode next() {
            ExternalHashJoinTable.this.checkCancelled();
            this.advance();
            if (this.currentNode != null) {
                ListNode node = this.currentNode;
                this.currentNode = null;
                return node;
            }
            throw new NoSuchElementException();
        }

        void advance() {
            while (this.currentNode == null && ExternalHashJoinTable.validNodeAddress(this.nextNodeAddress)) {
                ListNode listNode = ExternalHashJoinTable.this.readListNode(this.nextNodeAddress, this.touch);
                this.nextNodeAddress = listNode.nextNodeAddress();
                if (!this.touch && listNode.touched()) continue;
                this.currentNode = listNode;
                return;
            }
        }
    }

    private static class ListNode {
        final long nextNode;
        final ByteBuffer rowContent;

        ListNode(long nextNode, ByteBuffer rowContent) {
            this.nextNode = nextNode;
            this.rowContent = rowContent;
        }

        long nextNodeAddress() {
            return this.nextNode & Long.MAX_VALUE;
        }

        boolean touched() {
            return (this.nextNode & Long.MIN_VALUE) == 0L;
        }
    }

    private class TableIterator
    implements Iterator<TableEntry> {
        private final long size;
        private long currentSlot;
        @Nullable
        private TableEntry tableEntry;

        TableIterator(long size) {
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            this.advance();
            return this.tableEntry != null;
        }

        @Override
        public TableEntry next() {
            this.advance();
            TableEntry entry = this.tableEntry;
            if (entry != null) {
                this.tableEntry = null;
                return entry;
            }
            throw new NoSuchElementException();
        }

        void advance() {
            ExternalHashJoinTable.this.checkCancelled();
            while (this.tableEntry == null && this.currentSlot < this.size) {
                TableEntry tableEntry;
                if ((tableEntry = ExternalHashJoinTable.this.readEntryFromIndexFile(this.currentSlot++)).isEmpty()) continue;
                this.tableEntry = tableEntry;
            }
        }
    }
}

