/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.fsm;

import org.apache.ignite.internal.sql.engine.exec.fsm.CursorInitializationPhaseHandler;
import org.apache.ignite.internal.sql.engine.exec.fsm.CursorPublicationPhaseHandler;
import org.apache.ignite.internal.sql.engine.exec.fsm.ExecutionPhaseHandler;
import org.apache.ignite.internal.sql.engine.exec.fsm.NoOpHandler;
import org.apache.ignite.internal.sql.engine.exec.fsm.OptimizingPhaseHandler;
import org.apache.ignite.internal.sql.engine.exec.fsm.ParsingPhaseHandler;
import org.apache.ignite.internal.sql.engine.exec.fsm.Query;
import org.apache.ignite.internal.sql.engine.exec.fsm.Result;
import org.apache.ignite.internal.sql.engine.exec.fsm.ScriptInitializationPhaseHandler;

public enum ExecutionPhase {
    REGISTERED(NoOpHandler.INSTANCE),
    PARSING(ParsingPhaseHandler.INSTANCE),
    OPTIMIZING(OptimizingPhaseHandler.INSTANCE),
    CURSOR_INITIALIZATION(CursorInitializationPhaseHandler.INSTANCE),
    CURSOR_PUBLICATION(CursorPublicationPhaseHandler.INSTANCE),
    SCRIPT_INITIALIZATION(ScriptInitializationPhaseHandler.INSTANCE),
    EXECUTING(NoOpHandler.INSTANCE),
    TERMINATED(NoOpHandler.INSTANCE);

    private final ExecutionPhaseHandler handler;

    private ExecutionPhase(ExecutionPhaseHandler handler) {
        this.handler = handler;
    }

    Result evaluate(Query query) {
        return this.handler.handle(query);
    }
}

