/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.ignite.internal.sql.engine.api.expressions.RowFactory;
import org.apache.ignite.internal.sql.engine.exec.SqlEvaluationContext;
import org.apache.ignite.internal.sql.engine.exec.exp.CodegenUtils;
import org.apache.ignite.internal.sql.engine.exec.exp.CorrelatesBuilder;
import org.apache.ignite.internal.sql.engine.exec.exp.NoOpFieldGetter;
import org.apache.ignite.internal.sql.engine.exec.exp.RexToLixTranslator;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlExpressionFactoryImpl;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlRowProvider;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.IgniteMethod;
import org.apache.ignite.internal.sql.engine.util.Primitives;
import org.apache.ignite.internal.sql.engine.util.RexUtils;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.sql.engine.util.cache.Cache;
import org.apache.ignite.internal.type.StructNativeType;

class RowProviderImplementor {
    private final RelDataType nullType;
    private final RelDataType emptyType;
    private final Cache<String, Object> cache;
    private final RexBuilder rexBuilder;
    private final JavaTypeFactory typeFactory;
    private final SqlConformance conformance;

    RowProviderImplementor(Cache<String, Object> cache, RexBuilder rexBuilder, JavaTypeFactory typeFactory, SqlConformance conformance) {
        this.cache = cache;
        this.rexBuilder = rexBuilder;
        this.typeFactory = typeFactory;
        this.conformance = conformance;
        this.nullType = typeFactory.createSqlType(SqlTypeName.NULL);
        this.emptyType = new RelDataTypeFactory.Builder((RelDataTypeFactory)typeFactory).build();
    }

    SqlRowProvider implement(List<RexNode> values) {
        List<RelDataType> typeList = Commons.transform(values, v -> v != null ? v.getType() : this.nullType);
        ArrayList<RexLiteral> literalValues = new ArrayList<RexLiteral>(values.size());
        ArrayList types = new ArrayList(values.size());
        for (int i = 0; i < values.size(); ++i) {
            if (!(values.get(i) instanceof RexLiteral)) {
                String digest = SqlExpressionFactoryImpl.digest(SqlRowProvider.class, values, null);
                Cache cache = (Cache)Commons.cast(this.cache);
                return cache.get(digest, key -> {
                    StructNativeType rowType = TypeUtils.structuredTypeFromRelTypeList(typeList);
                    return new SqlRowProviderImpl(this.implementInternal(values), rowType);
                });
            }
            Class javaType = Primitives.wrap((Class)this.typeFactory.getJavaClass(typeList.get(i)));
            types.add(javaType);
            literalValues.add((RexLiteral)values.get(i));
        }
        StructNativeType rowType = TypeUtils.structuredTypeFromRelTypeList(typeList);
        return new ConstantRow(literalValues, types, rowType);
    }

    private SqlRowProviderExt implementInternal(List<RexNode> values) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(this.emptyType, this.rexBuilder);
        for (RexNode node : values) {
            assert (node != null) : "unexpected nullable node";
            programBuilder.addProject(node, null);
        }
        RexProgram program = programBuilder.getProgram();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression ctx = Expressions.parameter(SqlEvaluationContext.class, (String)"ctx");
        ParameterExpression outBuilder = Expressions.parameter(RowFactory.RowBuilder.class, (String)"outBuilder");
        builder.add((Statement)Expressions.declare((int)16, (ParameterExpression)DataContext.ROOT, (Expression)Expressions.convert_((Expression)ctx, DataContext.class)));
        Expression rowHandler = builder.append("hnd", (Expression)Expressions.call((Expression)ctx, (Method)IgniteMethod.CONTEXT_ROW_HANDLER.method(), (Expression[])new Expression[0]));
        Function1<String, RexToLixTranslator.InputGetter> correlates = new CorrelatesBuilder(builder, (Expression)ctx, rowHandler).build(values);
        List<Expression> projects = RexToLixTranslator.translateProjects(program, this.typeFactory, this.conformance, builder, null, null, (Expression)ctx, NoOpFieldGetter.INSTANCE, correlates);
        for (Expression val : projects) {
            MethodCallExpression addRowField = Expressions.call((Expression)outBuilder, (Method)IgniteMethod.ROW_BUILDER_ADD_FIELD.method(), (Expression[])new Expression[]{val});
            builder.add(Expressions.statement((Expression)addRowField));
        }
        BlockStatement methodBody = CodegenUtils.wrapWithConversionToEvaluationException((Statement)builder.toBlock());
        List<ParameterExpression> params = List.of(ctx, outBuilder);
        MethodDeclaration declaration = Expressions.methodDecl((int)1, Void.TYPE, (String)"get", params, (BlockStatement)methodBody);
        Class clazz = (Class)Commons.cast(SqlRowProviderExt.class);
        String body = Expressions.toString(List.of(declaration), (String)"\n", (boolean)false);
        return (SqlRowProviderExt)Commons.compile(clazz, body);
    }

    private static class ConstantRow
    extends AbstractRowProvider {
        private final List<RexLiteral> values;
        private final List<Class<?>> types;

        private ConstantRow(List<RexLiteral> values, List<Class<?>> types, StructNativeType rowType) {
            super(rowType);
            this.values = values;
            this.types = types;
        }

        @Override
        <RowT> void buildRow(SqlEvaluationContext<RowT> context, RowFactory.RowBuilder<RowT> rowBuilder) {
            for (int i = 0; i < this.values.size(); ++i) {
                RexLiteral literal = this.values.get(i);
                Class<?> type = this.types.get(i);
                Object value = RexUtils.literalValue(context, literal, type);
                rowBuilder.addField(value);
            }
        }
    }

    @FunctionalInterface
    public static interface SqlRowProviderExt {
        public <RowT> void get(SqlEvaluationContext<RowT> var1, RowFactory.RowBuilder<RowT> var2);
    }

    private static class SqlRowProviderImpl
    extends AbstractRowProvider {
        private final SqlRowProviderExt rowProvider;

        private SqlRowProviderImpl(SqlRowProviderExt rowProvider, StructNativeType rowType) {
            super(rowType);
            this.rowProvider = rowProvider;
        }

        @Override
        <RowT> void buildRow(SqlEvaluationContext<RowT> context, RowFactory.RowBuilder<RowT> rowBuilder) {
            this.rowProvider.get(context, rowBuilder);
        }
    }

    private static abstract class AbstractRowProvider
    implements SqlRowProvider {
        private final StructNativeType rowType;

        private AbstractRowProvider(StructNativeType rowType) {
            this.rowType = rowType;
        }

        private <RowT> RowFactory.RowBuilder<RowT> builder(SqlEvaluationContext<RowT> context) {
            return context.rowFactoryFactory().create(this.rowType).rowBuilder();
        }

        abstract <RowT> void buildRow(SqlEvaluationContext<RowT> var1, RowFactory.RowBuilder<RowT> var2);

        @Override
        public <RowT> RowT get(SqlEvaluationContext<RowT> context) {
            RowFactory.RowBuilder<RowT> rowBuilder = this.builder(context);
            this.buildRow(context, rowBuilder);
            return (RowT)rowBuilder.buildAndReset();
        }
    }
}

