/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.CatchBlock;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.FunctionExpression;
import org.apache.calcite.linq4j.tree.IndexExpression;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLambda;
import org.apache.calcite.rex.RexLambdaRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexNodeAndFieldIndex;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.runtime.SpatialTypeFunctions;
import org.apache.calcite.runtime.rtti.RuntimeTypeInformation;
import org.apache.calcite.runtime.variant.VariantValue;
import org.apache.calcite.schema.FunctionContext;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.sql.engine.exec.exp.ConverterUtils;
import org.apache.ignite.internal.sql.engine.exec.exp.RexImpTable;
import org.apache.ignite.internal.sql.engine.util.IgniteMethod;
import org.apache.ignite.internal.sql.engine.util.Primitives;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;

public class RexToLixTranslator
implements RexVisitor<Result> {
    public static final Map<Method, SqlOperator> JAVA_TO_SQL_METHOD_MAP = ImmutableMap.builder().put((Object)BuiltInMethod.STRING_TO_UPPER.method, (Object)SqlStdOperatorTable.UPPER).put((Object)BuiltInMethod.SUBSTRING.method, (Object)SqlStdOperatorTable.SUBSTRING).put((Object)BuiltInMethod.OCTET_LENGTH.method, (Object)SqlStdOperatorTable.OCTET_LENGTH).put((Object)BuiltInMethod.CHAR_LENGTH.method, (Object)SqlStdOperatorTable.CHAR_LENGTH).put((Object)BuiltInMethod.TRANSLATE3.method, (Object)SqlLibraryOperators.TRANSLATE3).build();
    final JavaTypeFactory typeFactory;
    final RexBuilder builder;
    @Nullable
    private final RexProgram program;
    final SqlConformance conformance;
    private final Expression root;
    final @Nullable InputGetter inputGetter;
    private final BlockBuilder list;
    @Nullable
    private final BlockBuilder staticList;
    @Nullable
    private final Function1<String, InputGetter> correlates;
    private final Map<Expression, Expression> literalMap = new HashMap<Expression, Expression>();
    private final Map<RexCall, List<Result>> callOperandResultMap = new HashMap<RexCall, List<Result>>();
    private final Map<Pair<RexNode, @Nullable Type>, Result> rexWithStorageTypeResultMap = new HashMap<Pair<RexNode, Type>, Result>();
    private final Map<RexNode, Result> rexResultMap = new HashMap<RexNode, Result>();
    @Nullable
    private Type currentStorageType;

    private RexToLixTranslator(@Nullable RexProgram program, JavaTypeFactory typeFactory, Expression root, @Nullable InputGetter inputGetter, BlockBuilder list, @Nullable BlockBuilder staticList, RexBuilder builder, SqlConformance conformance, @Nullable Function1<String, InputGetter> correlates) {
        this.program = program;
        this.typeFactory = Objects.requireNonNull(typeFactory, "typeFactory");
        this.conformance = Objects.requireNonNull(conformance, "conformance");
        this.root = Objects.requireNonNull(root, "root");
        this.inputGetter = inputGetter;
        this.list = Objects.requireNonNull(list, "list");
        this.staticList = staticList;
        this.builder = Objects.requireNonNull(builder, "builder");
        this.correlates = correlates;
    }

    public static List<Expression> translateProjects(RexProgram program, JavaTypeFactory typeFactory, SqlConformance conformance, BlockBuilder list, @Nullable BlockBuilder staticList, @Nullable PhysType outputPhysType, Expression root, InputGetter inputGetter, @Nullable Function1<String, InputGetter> correlates) {
        ArrayList<Type> storageTypes = null;
        if (outputPhysType != null) {
            RelDataType rowType = outputPhysType.getRowType();
            storageTypes = new ArrayList<Type>(rowType.getFieldCount());
            for (int i = 0; i < rowType.getFieldCount(); ++i) {
                storageTypes.add(outputPhysType.getJavaFieldType(i));
            }
        }
        return new RexToLixTranslator(program, typeFactory, root, inputGetter, list, staticList, new RexBuilder((RelDataTypeFactory)typeFactory), conformance, null).setCorrelates(correlates).translateList(program.getProjectList(), storageTypes);
    }

    @Deprecated
    public static List<Expression> translateProjects(RexProgram program, JavaTypeFactory typeFactory, SqlConformance conformance, BlockBuilder list, @Nullable PhysType outputPhysType, Expression root, InputGetter inputGetter, @Nullable Function1<String, InputGetter> correlates) {
        return RexToLixTranslator.translateProjects(program, typeFactory, conformance, list, null, outputPhysType, root, inputGetter, correlates);
    }

    public static RexToLixTranslator forAggregation(JavaTypeFactory typeFactory, BlockBuilder list, @Nullable InputGetter inputGetter, SqlConformance conformance) {
        ParameterExpression root = DataContext.ROOT;
        return new RexToLixTranslator(null, typeFactory, (Expression)root, inputGetter, list, null, new RexBuilder((RelDataTypeFactory)typeFactory), conformance, null);
    }

    Expression translate(RexNode expr) {
        RexImpTable.NullAs nullAs = RexImpTable.NullAs.of(this.isNullable(expr));
        return this.translate(expr, nullAs);
    }

    Expression translate(RexNode expr, RexImpTable.NullAs nullAs) {
        return this.translate(expr, nullAs, null);
    }

    Expression translate(RexNode expr, @Nullable Type storageType) {
        RexImpTable.NullAs nullAs = RexImpTable.NullAs.of(this.isNullable(expr));
        return this.translate(expr, nullAs, storageType);
    }

    Expression translate(RexNode expr, RexImpTable.NullAs nullAs, @Nullable Type storageType) {
        this.currentStorageType = storageType;
        Result result = (Result)expr.accept((RexVisitor)this);
        Expression translated = Objects.requireNonNull(ConverterUtils.toInternal((Expression)result.valueVariable, storageType));
        if (RexImpTable.NullAs.NOT_POSSIBLE == nullAs && translated.type.equals(storageType)) {
            return translated;
        }
        return nullAs.handle(translated);
    }

    private Expression expressionHandlingSafe(Expression body, boolean safe, RelDataType targetType) {
        return safe ? this.safeExpression(body, targetType) : body;
    }

    private Expression safeExpression(Expression body, RelDataType targetType) {
        ParameterExpression e_ = Expressions.parameter(Exception.class, (String)new BlockBuilder().newName("e"));
        RelDataType nullableTargetType = this.typeFactory.createTypeWithNullability(targetType, true);
        MethodCallExpression result = Expressions.call((Expression)Expressions.lambda((BlockStatement)Expressions.block((Statement[])new Statement[]{Expressions.tryCatch((Statement)Expressions.return_(null, (Expression)body), (CatchBlock[])new CatchBlock[]{Expressions.catch_((ParameterExpression)e_, (Statement)Expressions.return_(null, (Expression)Expressions.constant(null)))})}), (ParameterExpression[])new ParameterExpression[0]), (Method)BuiltInMethod.FUNCTION0_APPLY.method, (Expression[])new Expression[0]);
        return ConverterUtils.convert((Expression)result, nullableTargetType);
    }

    Expression translateCast(RelDataType sourceType, RelDataType targetType, Expression operand, boolean safe, ConstantExpression format) {
        Expression convert = this.getConvertExpression(sourceType, targetType, operand, format);
        Expression convert2 = RexToLixTranslator.checkExpressionPadTruncate(convert, sourceType, targetType, operand);
        Expression convert3 = this.expressionHandlingSafe(convert2, safe, targetType);
        return RexToLixTranslator.scaleValue(sourceType, targetType, convert3);
    }

    private Expression getConvertExpression(RelDataType sourceType, RelDataType targetType, Expression operand, ConstantExpression format) {
        Supplier<Expression> defaultExpression = () -> ConverterUtils.convert(operand, targetType);
        if (sourceType.getSqlTypeName() == SqlTypeName.VARIANT) {
            if (targetType.getSqlTypeName() == SqlTypeName.VARIANT) {
                return defaultExpression.get();
            }
            UnaryExpression operandCast = Expressions.convert_((Expression)operand, VariantValue.class);
            MethodCallExpression cast = Expressions.call((Expression)operandCast, (Method)BuiltInMethod.VARIANT_CAST.method, (Expression[])new Expression[]{RuntimeTypeInformation.createExpression((RelDataType)targetType)});
            RelDataType nullableTarget = this.typeFactory.createTypeWithNullability(targetType, true);
            return Expressions.convert_((Expression)cast, (Type)this.typeFactory.getJavaClass(nullableTarget));
        }
        if (targetType.getSqlTypeName() == SqlTypeName.ROW) {
            assert (sourceType.getSqlTypeName() == SqlTypeName.ROW);
            List targetTypes = targetType.getFieldList();
            List sourceTypes = sourceType.getFieldList();
            assert (targetTypes.size() == sourceTypes.size());
            ArrayList<Expression> fields = new ArrayList<Expression>();
            for (int i = 0; i < targetTypes.size(); ++i) {
                RelDataTypeField targetField = (RelDataTypeField)targetTypes.get(i);
                RelDataTypeField sourceField = (RelDataTypeField)sourceTypes.get(i);
                IndexExpression field = Expressions.arrayIndex((Expression)operand, (Expression)Expressions.constant((Object)i));
                RelDataType nullableSourceFieldType = this.typeFactory.createTypeWithNullability(sourceField.getType(), true);
                Type javaType = this.typeFactory.getJavaClass(nullableSourceFieldType);
                if (!javaType.getTypeName().equals("java.lang.Void") && !nullableSourceFieldType.isStruct()) {
                    field = Expressions.convert_((Expression)field, (Type)javaType);
                }
                Expression convert = this.getConvertExpression(sourceField.getType(), targetField.getType(), (Expression)field, format);
                fields.add(convert);
            }
            return Expressions.call((Method)BuiltInMethod.ARRAY.method, fields);
        }
        switch (targetType.getSqlTypeName()) {
            case ARRAY: 
            case MULTISET: {
                RelDataType sourceDataType = sourceType.getComponentType();
                RelDataType targetDataType = targetType.getComponentType();
                assert (sourceDataType != null);
                assert (targetDataType != null);
                ParameterExpression parameter = Expressions.parameter((Type)this.typeFactory.getJavaClass(sourceDataType), (String)"root");
                Expression convert = this.getConvertExpression(sourceDataType, targetDataType, (Expression)parameter, format);
                return Expressions.call((Method)BuiltInMethod.LIST_TRANSFORM.method, (Expression[])new Expression[]{operand, Expressions.lambda(Function1.class, (Expression)convert, (ParameterExpression[])new ParameterExpression[]{parameter})});
            }
            case VARIANT: {
                Expression rtti = RuntimeTypeInformation.createExpression((RelDataType)sourceType);
                ConstantExpression roundingMode = Expressions.constant((Object)((Object)this.typeFactory.getTypeSystem().roundingMode()));
                return Expressions.call((Method)BuiltInMethod.VARIANT_CREATE.method, (Expression[])new Expression[]{roundingMode, operand, rtti});
            }
            case ANY: {
                return operand;
            }
            case BINARY: 
            case VARBINARY: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        return Expressions.call((Method)IgniteMethod.STRING_TO_BYTESTRING.method(), (Expression[])new Expression[]{operand});
                    }
                }
                return defaultExpression.get();
            }
            case GEOMETRY: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        return Expressions.call((Method)BuiltInMethod.ST_GEOM_FROM_EWKT.method, (Expression[])new Expression[]{operand});
                    }
                }
                return defaultExpression.get();
            }
            case DATE: {
                return this.translateCastToDate(sourceType, operand, format, defaultExpression);
            }
            case TIME: {
                return this.translateCastToTime(sourceType, targetType, operand, format, defaultExpression);
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return this.translateCastToTimeWithLocalTimeZone(sourceType, operand, defaultExpression);
            }
            case TIMESTAMP: {
                return this.translateCastToTimestamp(sourceType, targetType, operand, format, defaultExpression);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.translateCastToTimestampWithLocalTimeZone(sourceType, targetType, operand, format, defaultExpression);
            }
            case BOOLEAN: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        return Expressions.call((Method)BuiltInMethod.STRING_TO_BOOLEAN.method, (Expression[])new Expression[]{operand});
                    }
                }
                return defaultExpression.get();
            }
            case UUID: {
                switch (sourceType.getSqlTypeName()) {
                    case UUID: {
                        return operand;
                    }
                }
                return defaultExpression.get();
            }
            case CHAR: 
            case VARCHAR: {
                SqlIntervalQualifier interval = sourceType.getIntervalQualifier();
                switch (sourceType.getSqlTypeName()) {
                    case DATE: {
                        return RexImpTable.optimize2(operand, (Expression)(Expressions.isConstantNull((Expression)format) ? Expressions.call((Method)BuiltInMethod.UNIX_DATE_TO_STRING.method, (Expression[])new Expression[]{operand}) : Expressions.call((Method)IgniteMethod.FORMAT_DATE.method(), (Expression[])new Expression[]{format, operand})));
                    }
                    case TIME: {
                        return RexImpTable.optimize2(operand, (Expression)(Expressions.isConstantNull((Expression)format) ? Expressions.call((Method)IgniteMethod.UNIX_TIME_TO_STRING_PRECISION_AWARE.method(), (Expression[])new Expression[]{operand, Expressions.constant((Object)sourceType.getPrecision())}) : Expressions.call((Method)IgniteMethod.FORMAT_TIME.method(), (Expression[])new Expression[]{format, operand})));
                    }
                    case TIME_WITH_LOCAL_TIME_ZONE: {
                        return RexImpTable.optimize2(operand, (Expression)(Expressions.isConstantNull((Expression)format) ? Expressions.call((Method)BuiltInMethod.TIME_WITH_LOCAL_TIME_ZONE_TO_STRING.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})}) : Expressions.call((Expression)Expressions.new_(BuiltInMethod.FORMAT_TIME.method.getDeclaringClass()), (Method)BuiltInMethod.FORMAT_TIME.method, (Expression[])new Expression[]{format, operand})));
                    }
                    case TIMESTAMP: {
                        return RexImpTable.optimize2(operand, (Expression)(Expressions.isConstantNull((Expression)format) ? Expressions.call((Method)IgniteMethod.UNIX_TIMESTAMP_TO_STRING_PRECISION_AWARE.method(), (Expression[])new Expression[]{operand, Expressions.constant((Object)sourceType.getPrecision())}) : Expressions.call((Method)IgniteMethod.FORMAT_TIMESTAMP.method(), (Expression[])new Expression[]{format, operand})));
                    }
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        MethodCallExpression getTimeZone = Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root});
                        return RexImpTable.optimize2(operand, (Expression)(Expressions.isConstantNull((Expression)format) ? Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_STRING.method, (Expression[])new Expression[]{operand, getTimeZone}) : Expressions.call((Method)IgniteMethod.FORMAT_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method(), (Expression[])new Expression[]{format, operand, getTimeZone})));
                    }
                    case INTERVAL_YEAR: 
                    case INTERVAL_YEAR_MONTH: 
                    case INTERVAL_MONTH: {
                        return RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.INTERVAL_YEAR_MONTH_TO_STRING.method, (Expression[])new Expression[]{operand, Expressions.constant((Object)Objects.requireNonNull(interval, (String)"interval").timeUnitRange)}));
                    }
                    case INTERVAL_DAY: 
                    case INTERVAL_DAY_HOUR: 
                    case INTERVAL_DAY_MINUTE: 
                    case INTERVAL_DAY_SECOND: 
                    case INTERVAL_HOUR: 
                    case INTERVAL_HOUR_MINUTE: 
                    case INTERVAL_HOUR_SECOND: 
                    case INTERVAL_MINUTE: 
                    case INTERVAL_MINUTE_SECOND: 
                    case INTERVAL_SECOND: {
                        return RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.INTERVAL_DAY_TIME_TO_STRING.method, (Expression[])new Expression[]{operand, Expressions.constant((Object)Objects.requireNonNull(interval, (String)"interval").timeUnitRange), Expressions.constant((Object)interval.getFractionalSecondPrecision(this.typeFactory.getTypeSystem()))}));
                    }
                    case BOOLEAN: {
                        return RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.BOOLEAN_TO_STRING.method, (Expression[])new Expression[]{operand}));
                    }
                    case BINARY: 
                    case VARBINARY: {
                        return RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)IgniteMethod.BYTESTRING_TO_STRING.method(), (Expression[])new Expression[]{operand}));
                    }
                }
                return defaultExpression.get();
            }
        }
        return defaultExpression.get();
    }

    private static Expression checkExpressionPadTruncate(Expression operand, RelDataType sourceType, RelDataType targetType, Expression sourceOperand) {
        boolean pad = false;
        boolean truncate = true;
        switch (targetType.getSqlTypeName()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                int targetPrecision = targetType.getPrecision();
                if (targetPrecision < 0) {
                    return operand;
                }
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: 
                    case BINARY: 
                    case VARBINARY: {
                        int sourcePrecision = sourceType.getPrecision();
                        if (SqlTypeUtil.comparePrecision((int)sourcePrecision, (int)targetPrecision) <= 0) {
                            truncate = false;
                        }
                        if (SqlTypeUtil.comparePrecision((int)sourcePrecision, (int)targetPrecision) < 0) break;
                        pad = false;
                    }
                }
                if (truncate || pad) {
                    Method method = pad ? BuiltInMethod.TRUNCATE_OR_PAD.method : BuiltInMethod.TRUNCATE.method;
                    return Expressions.call((Method)method, (Expression[])new Expression[]{operand, Expressions.constant((Object)targetPrecision)});
                }
                return operand;
            }
            case TIMESTAMP: {
                int targetScale = targetType.getScale();
                if (targetScale == Integer.MIN_VALUE) {
                    targetScale = 0;
                }
                if (targetScale < sourceType.getScale()) {
                    return Expressions.call((Method)BuiltInMethod.ROUND_LONG.method, (Expression[])new Expression[]{operand, Expressions.constant((Object)((long)Math.pow(10.0, 3 - targetScale)))});
                }
                return operand;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                SqlTypeFamily family = Objects.requireNonNull(sourceType.getSqlTypeName().getFamily(), () -> "null SqlTypeFamily for " + sourceType + ", SqlTypeName " + sourceType.getSqlTypeName());
                switch (family) {
                    case NUMERIC: {
                        BigDecimal multiplier = targetType.getSqlTypeName().getEndUnit().multiplier;
                        BigDecimal divider = BigDecimal.ONE;
                        return RexImpTable.multiplyDivide(operand, multiplier, divider);
                    }
                    case CHARACTER: {
                        SqlIntervalQualifier intervalQualifier = targetType.getIntervalQualifier();
                        Method method = intervalQualifier.isYearMonth() ? IgniteMethod.PARSE_INTERVAL_YEAR_MONTH.method() : IgniteMethod.PARSE_INTERVAL_DAY_TIME.method();
                        return Expressions.call((Method)method, (Expression[])new Expression[]{sourceOperand, Expressions.new_(SqlIntervalQualifier.class, (Expression[])new Expression[]{Expressions.constant((Object)intervalQualifier.getStartUnit()), Expressions.constant((Object)intervalQualifier.getStartPrecisionPreservingDefault()), Expressions.constant((Object)intervalQualifier.getEndUnit()), Expressions.constant((Object)intervalQualifier.getFractionalSecondPrecisionPreservingDefault()), Expressions.field(null, SqlParserPos.class, (String)"ZERO")})});
                    }
                }
                return operand;
            }
        }
        return operand;
    }

    private Expression translateCastToDate(RelDataType sourceType, Expression operand, ConstantExpression format, Supplier<Expression> defaultExpression) {
        switch (sourceType.getSqlTypeName()) {
            case CHAR: 
            case VARCHAR: {
                return Expressions.isConstantNull((Expression)format) ? Expressions.call((Method)BuiltInMethod.STRING_TO_DATE.method, (Expression[])new Expression[]{operand}) : Expressions.call((Method)IgniteMethod.DATE_STRING_TO_DATE.method(), (Expression[])new Expression[]{operand, format});
            }
            case TIMESTAMP: {
                return Expressions.convert_((Expression)Expressions.call((Method)BuiltInMethod.FLOOR_DIV.method, (Expression[])new Expression[]{operand, Expressions.constant((Object)86400000L)}), Integer.TYPE);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_DATE.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})}));
            }
        }
        return defaultExpression.get();
    }

    private Expression translateCastToTime(RelDataType sourceType, RelDataType targetType, Expression operand, ConstantExpression format, Supplier<Expression> defaultExpression) {
        switch (sourceType.getSqlTypeName()) {
            case CHAR: 
            case VARCHAR: {
                MethodCallExpression result = Expressions.isConstantNull((Expression)format) ? Expressions.call((Method)IgniteMethod.STRING_TO_TIME.method(), (Expression[])new Expression[]{operand}) : Expressions.call((Method)IgniteMethod.TIME_STRING_TO_TIME.method(), (Expression[])new Expression[]{operand, format});
                return RexToLixTranslator.adjustTimeMillis(sourceType, targetType, (Expression)result);
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.TIME_WITH_LOCAL_TIME_ZONE_TO_TIME.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})}));
            }
            case TIMESTAMP: {
                return RexToLixTranslator.adjustTimeMillis(sourceType, targetType, (Expression)Expressions.convert_((Expression)Expressions.call((Method)BuiltInMethod.FLOOR_MOD.method, (Expression[])new Expression[]{operand, Expressions.constant((Object)86400000L)}), Integer.TYPE));
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return RexToLixTranslator.adjustTimeMillis(sourceType, targetType, RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIME.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})})));
            }
            case TIME: {
                return RexToLixTranslator.adjustTimeMillis(sourceType, targetType, operand);
            }
        }
        return defaultExpression.get();
    }

    private Expression translateCastToTimeWithLocalTimeZone(RelDataType sourceType, Expression operand, Supplier<Expression> defaultExpression) {
        switch (sourceType.getSqlTypeName()) {
            case CHAR: 
            case VARCHAR: {
                return Expressions.call((Method)BuiltInMethod.STRING_TO_TIME_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{operand});
            }
            case TIME: {
                return Expressions.call((Method)BuiltInMethod.TIME_STRING_TO_TIME_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.UNIX_TIME_TO_STRING.method, (Expression[])new Expression[]{operand})), Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})});
            }
            case TIMESTAMP: {
                return Expressions.call((Method)BuiltInMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, (Expression[])new Expression[]{operand})), Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})});
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIME_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{operand}));
            }
        }
        return defaultExpression.get();
    }

    private Expression translateCastToTimestamp(RelDataType sourceType, RelDataType targetType, Expression operand, ConstantExpression format, Supplier<Expression> defaultExpression) {
        switch (sourceType.getSqlTypeName()) {
            case CHAR: 
            case VARCHAR: {
                MethodCallExpression result = Expressions.isConstantNull((Expression)format) ? Expressions.call((Method)IgniteMethod.TO_TIMESTAMP_EXACT.method(), (Expression[])new Expression[]{Expressions.call((Method)IgniteMethod.STRING_TO_TIMESTAMP.method(), (Expression[])new Expression[]{operand})}) : Expressions.call((Method)IgniteMethod.TIMESTAMP_STRING_TO_TIMESTAMP.method(), (Expression[])new Expression[]{operand, format});
                return RexToLixTranslator.adjustTimestampMillis(sourceType, targetType, (Expression)result);
            }
            case DATE: {
                return Expressions.multiply((Expression)Expressions.convert_((Expression)operand, Long.TYPE), (Expression)Expressions.constant((Object)86400000L));
            }
            case TIME: {
                return RexToLixTranslator.adjustTimestampMillis(sourceType, targetType, (Expression)Expressions.add((Expression)Expressions.multiply((Expression)Expressions.convert_((Expression)Expressions.call((Method)IgniteMethod.CURRENT_DATE.method(), (Expression[])new Expression[]{this.root}), Long.TYPE), (Expression)Expressions.constant((Object)86400000L)), (Expression)Expressions.convert_((Expression)operand, Long.TYPE)));
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.TIME_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, (Expression[])new Expression[]{Expressions.call((Method)BuiltInMethod.UNIX_DATE_TO_STRING.method, (Expression[])new Expression[]{Expressions.call((Method)BuiltInMethod.CURRENT_DATE.method, (Expression[])new Expression[]{this.root})}), operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})}));
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return RexToLixTranslator.adjustTimestampMillis(sourceType, targetType, RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})})));
            }
            case TIMESTAMP: {
                return RexToLixTranslator.adjustTimestampMillis(sourceType, targetType, operand);
            }
        }
        return defaultExpression.get();
    }

    private Expression translateCastToTimestampWithLocalTimeZone(RelDataType sourceType, RelDataType targetType, Expression operand, ConstantExpression format, Supplier<Expression> defaultExpression) {
        switch (sourceType.getSqlTypeName()) {
            case CHAR: 
            case VARCHAR: {
                MethodCallExpression getTimeZone = Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root});
                MethodCallExpression result = Expressions.isConstantNull((Expression)format) ? Expressions.call((Method)IgniteMethod.TO_TIMESTAMP_LTZ_EXACT.method(), (Expression[])new Expression[]{Expressions.call((Method)BuiltInMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{operand, getTimeZone})}) : Expressions.call((Method)IgniteMethod.TO_TIMESTAMP_LTZ_EXACT.method(), (Expression[])new Expression[]{Expressions.call((Method)IgniteMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method(), (Expression[])new Expression[]{operand, format, getTimeZone})});
                return RexToLixTranslator.adjustTimestampMillis(sourceType, targetType, (Expression)result);
            }
            case DATE: {
                return Expressions.call((Method)IgniteMethod.TO_TIMESTAMP_LTZ_EXACT.method(), (Expression[])new Expression[]{Expressions.call((Method)BuiltInMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, (Expression[])new Expression[]{Expressions.multiply((Expression)Expressions.convert_((Expression)operand, Long.TYPE), (Expression)Expressions.constant((Object)86400000L))})), Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})})});
            }
            case TIME: {
                return Expressions.call((Method)BuiltInMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)IgniteMethod.UNIX_TIMESTAMP_TO_STRING_PRECISION_AWARE.method(), (Expression[])new Expression[]{Expressions.add((Expression)Expressions.multiply((Expression)Expressions.convert_((Expression)Expressions.call((Method)IgniteMethod.CURRENT_DATE.method(), (Expression[])new Expression[]{this.root}), Long.TYPE), (Expression)Expressions.constant((Object)86400000L)), (Expression)Expressions.convert_((Expression)operand, Long.TYPE)), Expressions.constant((Object)targetType.getPrecision())})), Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})});
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.TIME_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{Expressions.call((Method)BuiltInMethod.UNIX_DATE_TO_STRING.method, (Expression[])new Expression[]{Expressions.call((Method)BuiltInMethod.CURRENT_DATE.method, (Expression[])new Expression[]{this.root})}), operand}));
            }
            case TIMESTAMP: {
                return Expressions.call((Method)IgniteMethod.TO_TIMESTAMP_LTZ_EXACT.method(), (Expression[])new Expression[]{Expressions.call((Method)BuiltInMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)IgniteMethod.UNIX_TIMESTAMP_TO_STRING_PRECISION_AWARE.method(), (Expression[])new Expression[]{operand, Expressions.constant((Object)targetType.getPrecision())})), Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})})});
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return RexToLixTranslator.adjustTimestampMillis(sourceType, targetType, operand);
            }
        }
        return defaultExpression.get();
    }

    private static Expression adjustTimestampMillis(RelDataType sourceType, RelDataType targetType, Expression operand) {
        if (sourceType.getSqlTypeName() == SqlTypeName.VARCHAR || sourceType.getPrecision() > targetType.getPrecision()) {
            return Expressions.call((Method)IgniteMethod.ADJUST_TIMESTAMP_MILLIS.method(), (Expression[])new Expression[]{operand, Expressions.constant((Object)targetType.getPrecision())});
        }
        return operand;
    }

    private static Expression adjustTimeMillis(RelDataType sourceType, RelDataType targetType, Expression operand) {
        if (sourceType.getSqlTypeName() == SqlTypeName.VARCHAR || sourceType.getPrecision() > targetType.getPrecision()) {
            return Expressions.call((Method)IgniteMethod.ADJUST_TIME_MILLIS.method(), (Expression[])new Expression[]{operand, Expressions.constant((Object)targetType.getPrecision())});
        }
        return operand;
    }

    Expression handleMethodCheckedExceptions(Expression callExpr) {
        ParameterExpression methodCall = Expressions.parameter((Type)callExpr.getType(), (String)this.list.newName("method_call"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)methodCall, null));
        Statement st = Expressions.statement((Expression)Expressions.assign((Expression)methodCall, (Expression)callExpr));
        ParameterExpression e = Expressions.parameter((int)0, Exception.class, (String)"e");
        NewExpression uncheckedException = Expressions.new_(RuntimeException.class, (Expression[])new Expression[]{e});
        CatchBlock cb = Expressions.catch_((ParameterExpression)e, (Statement)Expressions.throw_((Expression)uncheckedException));
        this.list.add((Statement)Expressions.tryCatch((Statement)st, (CatchBlock[])new CatchBlock[]{cb}));
        return methodCall;
    }

    public RexNode deref(RexNode expr) {
        if (expr instanceof RexLocalRef) {
            RexLocalRef ref = (RexLocalRef)expr;
            RexNode e2 = (RexNode)Objects.requireNonNull(this.program, "program").getExprList().get(ref.getIndex());
            assert (ref.getType().equals(e2.getType()));
            return e2;
        }
        return expr;
    }

    public static Expression translateLiteral(RexLiteral literal, RelDataType type, JavaTypeFactory typeFactory, RexImpTable.NullAs nullAs) {
        Object value2;
        if (literal.isNull()) {
            switch (nullAs) {
                case TRUE: 
                case IS_NULL: {
                    return RexImpTable.TRUE_EXPR;
                }
                case FALSE: 
                case IS_NOT_NULL: {
                    return RexImpTable.FALSE_EXPR;
                }
                case NOT_POSSIBLE: {
                    throw new ControlFlowException();
                }
            }
            return RexImpTable.NULL_EXPR;
        }
        switch (nullAs) {
            case IS_NOT_NULL: {
                return RexImpTable.TRUE_EXPR;
            }
            case IS_NULL: {
                return RexImpTable.FALSE_EXPR;
            }
        }
        Class<Number> javaClass = typeFactory.getJavaClass(type);
        switch (literal.getType().getSqlTypeName()) {
            case DECIMAL: {
                BigDecimal bd = (BigDecimal)literal.getValueAs(BigDecimal.class);
                if (javaClass == Float.TYPE) {
                    return Expressions.constant((Object)bd, javaClass);
                }
                if (javaClass == Double.TYPE) {
                    return Expressions.constant((Object)bd, javaClass);
                }
                assert (javaClass == BigDecimal.class);
                return Expressions.new_(BigDecimal.class, (Expression[])new Expression[]{Expressions.constant((Object)Objects.requireNonNull(bd, () -> "value for " + literal).toString())});
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                Object val = literal.getValueAs(Long.class);
                return Expressions.call((Method)IgniteMethod.SUBTRACT_TIMEZONE_OFFSET.method(), (Expression[])new Expression[]{Expressions.constant((Object)val, Long.TYPE), Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{DataContext.ROOT})});
            }
            case DATE: 
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                value2 = literal.getValueAs(Integer.class);
                javaClass = Integer.TYPE;
                break;
            }
            case TIMESTAMP: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                value2 = literal.getValueAs(Long.class);
                javaClass = Long.TYPE;
                break;
            }
            case CHAR: 
            case VARCHAR: {
                value2 = literal.getValueAs(String.class);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                return Expressions.new_(ByteString.class, (Expression[])new Expression[]{Expressions.constant((Object)literal.getValueAs(byte[].class), byte[].class)});
            }
            case GEOMETRY: {
                Geometry geom = Objects.requireNonNull((Geometry)literal.getValueAs(Geometry.class), () -> "getValueAs(Geometries.Geom) for " + literal);
                String wkt = SpatialTypeFunctions.ST_AsWKT((Geometry)geom);
                return Expressions.call(null, (Method)BuiltInMethod.ST_GEOM_FROM_EWKT.method, (Expression[])new Expression[]{Expressions.constant((Object)wkt)});
            }
            case SYMBOL: {
                value2 = Objects.requireNonNull((Enum)literal.getValueAs(Enum.class), () -> "getValueAs(Enum.class) for " + literal);
                javaClass = value2.getClass();
                break;
            }
            case UUID: {
                UUID value = (UUID)literal.getValueAs(UUID.class);
                assert (value != null);
                return Expressions.new_(UUID.class, (Expression[])new Expression[]{Expressions.constant((Object)value.getMostSignificantBits()), Expressions.constant((Object)value.getLeastSignificantBits())});
            }
            default: {
                Primitive primitive = Primitive.ofBoxOr((Type)javaClass);
                Comparable value = (Comparable)literal.getValueAs(Comparable.class);
                value2 = primitive != null && value instanceof Number ? Primitives.convertPrimitiveExact(primitive, (Number)((Object)value)) : value;
            }
        }
        return Expressions.constant((Object)value2, javaClass);
    }

    public List<Expression> translateList(List<RexNode> operandList, RexImpTable.NullAs nullAs) {
        return this.translateList(operandList, nullAs, ConverterUtils.internalTypes(operandList));
    }

    public List<Expression> translateList(List<RexNode> operandList, RexImpTable.NullAs nullAs, List<? extends @Nullable Type> storageTypes) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (Pair e : Pair.zip(operandList, storageTypes)) {
            list.add(this.translate((RexNode)e.left, nullAs, (Type)e.right));
        }
        return list;
    }

    public List<Expression> translateList(List<? extends RexNode> operandList) {
        return this.translateList(operandList, ConverterUtils.internalTypes(operandList));
    }

    public List<Expression> translateList(List<? extends RexNode> operandList, @Nullable @Nullable List<? extends @Nullable Type> storageTypes) {
        ArrayList<Expression> list = new ArrayList<Expression>(operandList.size());
        for (int i = 0; i < operandList.size(); ++i) {
            RexNode rex = operandList.get(i);
            Type desiredType = null;
            if (storageTypes != null) {
                desiredType = storageTypes.get(i);
            }
            Expression translate = this.translate(rex, desiredType);
            list.add(translate);
            if (desiredType == null && !this.isNullable(rex)) assert (!Primitive.isBox((Type)translate.getType())) : "Not-null boxed primitive should come back as primitive: " + rex + ", " + translate.getType();
        }
        return list;
    }

    public static Expression translateCondition(RexProgram program, JavaTypeFactory typeFactory, BlockBuilder list, InputGetter inputGetter, Function1<String, InputGetter> correlates, SqlConformance conformance, Expression root) {
        RexLocalRef condition = program.getCondition();
        if (condition == null) {
            return RexImpTable.TRUE_EXPR;
        }
        RexToLixTranslator translator = new RexToLixTranslator(program, typeFactory, root, inputGetter, list, null, new RexBuilder((RelDataTypeFactory)typeFactory), conformance, null);
        translator = translator.setCorrelates(correlates);
        return translator.translate((RexNode)condition, RexImpTable.NullAs.FALSE);
    }

    public boolean isNullable(RexNode e) {
        return e.getType().isNullable();
    }

    public RexToLixTranslator setBlock(BlockBuilder list) {
        if (list == this.list) {
            return this;
        }
        return new RexToLixTranslator(this.program, this.typeFactory, this.root, this.inputGetter, list, this.staticList, this.builder, this.conformance, this.correlates);
    }

    public RexToLixTranslator setCorrelates(@Nullable Function1<String, InputGetter> correlates) {
        if (this.correlates == correlates) {
            return this;
        }
        return new RexToLixTranslator(this.program, this.typeFactory, this.root, this.inputGetter, this.list, this.staticList, this.builder, this.conformance, correlates);
    }

    public Expression getRoot() {
        return this.root;
    }

    private static Expression scaleValue(RelDataType sourceType, RelDataType targetType, Expression operand) {
        SqlTypeFamily targetFamily = targetType.getSqlTypeName().getFamily();
        SqlTypeFamily sourceFamily = sourceType.getSqlTypeName().getFamily();
        if (targetFamily == SqlTypeFamily.NUMERIC && targetType.getSqlTypeName() != SqlTypeName.DECIMAL && (sourceFamily == SqlTypeFamily.INTERVAL_YEAR_MONTH || sourceFamily == SqlTypeFamily.INTERVAL_DAY_TIME)) {
            BigDecimal multiplier = BigDecimal.ONE;
            BigDecimal divider = sourceType.getSqlTypeName().getEndUnit().multiplier;
            return RexImpTable.multiplyDivide(operand, multiplier, divider);
        }
        return operand;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Result visitInputRef(RexInputRef inputRef) {
        @Nullable Pair key = Pair.of((Object)inputRef, (Object)this.currentStorageType);
        if (this.rexWithStorageTypeResultMap.containsKey(key)) {
            return this.rexWithStorageTypeResultMap.get(key);
        }
        Expression valueExpression = Objects.requireNonNull(this.inputGetter, "inputGetter").field(this.list, inputRef.getIndex(), this.currentStorageType);
        ParameterExpression valueVariable = Expressions.parameter((Type)valueExpression.getType(), (String)this.list.newName("input_value"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)valueVariable, (Expression)valueExpression));
        Expression isNullExpression = this.checkNull((Expression)valueVariable);
        ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)this.list.newName("input_isNull"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)isNullExpression));
        Result result = new Result(isNullVariable, valueVariable);
        this.rexWithStorageTypeResultMap.put((Pair<RexNode, Type>)key, result);
        return new Result(isNullVariable, valueVariable);
    }

    public Result visitLambdaRef(RexLambdaRef ref) {
        ParameterExpression valueVariable = Expressions.parameter((Type)this.typeFactory.getJavaClass(ref.getType()), (String)ref.getName());
        Expression isNullExpression = this.checkNull((Expression)valueVariable);
        ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)this.list.newName("input_isNull"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)isNullExpression));
        return new Result(isNullVariable, valueVariable);
    }

    public Result visitLocalRef(RexLocalRef localRef) {
        return (Result)this.deref((RexNode)localRef).accept((RexVisitor)this);
    }

    public Result visitLiteral(RexLiteral literal) {
        ParameterExpression valueVariable;
        if (this.rexResultMap.containsKey(literal)) {
            return this.rexResultMap.get(literal);
        }
        Object valueExpression = literal.isNull() ? this.getTypedNullLiteral(literal) : RexToLixTranslator.translateLiteral(literal, literal.getType(), this.typeFactory, RexImpTable.NullAs.NOT_POSSIBLE);
        Expression literalValue = this.appendConstant("literal_value", (Expression)valueExpression);
        if (literalValue instanceof ParameterExpression) {
            valueVariable = (ParameterExpression)literalValue;
        } else {
            valueVariable = Expressions.parameter((Type)valueExpression.getType(), (String)this.list.newName("literal_value"));
            this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)valueVariable, (Expression)valueExpression));
        }
        ConstantExpression isNullExpression = literal.isNull() ? RexImpTable.TRUE_EXPR : RexImpTable.FALSE_EXPR;
        ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)this.list.newName("literal_isNull"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)isNullExpression));
        this.literalMap.put((Expression)valueVariable, (Expression)valueExpression);
        Result result = new Result(isNullVariable, valueVariable);
        this.rexResultMap.put((RexNode)literal, result);
        return result;
    }

    private ConstantExpression getTypedNullLiteral(RexLiteral literal) {
        assert (literal.isNull());
        Class<Long> javaClass = this.typeFactory.getJavaClass(literal.getType());
        switch (literal.getType().getSqlTypeName()) {
            case DATE: 
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                javaClass = Integer.class;
                break;
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                javaClass = Long.class;
                break;
            }
        }
        return javaClass == null || javaClass == Void.class ? RexImpTable.NULL_EXPR : Expressions.constant(null, javaClass);
    }

    public Result visitCall(RexCall call) {
        if (this.rexResultMap.containsKey(call)) {
            return this.rexResultMap.get(call);
        }
        SqlOperator operator = call.getOperator();
        if (operator == SqlStdOperatorTable.CASE) {
            return this.implementCaseWhen(call);
        }
        if (operator == SqlStdOperatorTable.SEARCH) {
            return (Result)RexUtil.expandSearch((RexBuilder)this.builder, (RexProgram)this.program, (RexNode)call).accept((RexVisitor)this);
        }
        RexImpTable.RexCallImplementor implementor = RexImpTable.INSTANCE.get(operator);
        if (implementor == null) {
            throw new RuntimeException("cannot translate call " + call);
        }
        List operandList = call.getOperands();
        List<@Nullable Type> storageTypes = ConverterUtils.internalTypes(operandList);
        ArrayList<Result> operandResults = new ArrayList<Result>();
        for (int i = 0; i < operandList.size(); ++i) {
            Result operandResult = RexToLixTranslator.implementCallOperand((RexNode)operandList.get(i), storageTypes.get(i), this);
            operandResults.add(operandResult);
        }
        this.callOperandResultMap.put(call, operandResults);
        Result result = implementor.implement(this, call, operandResults);
        this.rexResultMap.put((RexNode)call, result);
        return result;
    }

    private static Result implementCallOperand(RexNode operand, @Nullable Type storageType, RexToLixTranslator translator) {
        Type originalStorageType = translator.currentStorageType;
        translator.currentStorageType = storageType;
        Result operandResult = (Result)operand.accept((RexVisitor)translator);
        if (storageType != null) {
            operandResult = translator.toInnerStorageType(operandResult, storageType);
        }
        translator.currentStorageType = originalStorageType;
        return operandResult;
    }

    private static Expression implementCallOperand2(RexNode operand, @Nullable Type storageType, RexToLixTranslator translator) {
        Type originalStorageType = translator.currentStorageType;
        translator.currentStorageType = storageType;
        Expression result = translator.translate(operand);
        translator.currentStorageType = originalStorageType;
        return result;
    }

    private Result implementCaseWhen(RexCall call) {
        Type returnType = this.typeFactory.getJavaClass(call.getType());
        ParameterExpression valueVariable = Expressions.parameter((Type)returnType, (String)this.list.newName("case_when_value"));
        this.list.add((Statement)Expressions.declare((int)0, (ParameterExpression)valueVariable, null));
        List operandList = call.getOperands();
        RexToLixTranslator.implementRecursively(this, operandList, valueVariable, call.getType(), 0);
        Expression isNullExpression = this.checkNull((Expression)valueVariable);
        ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)this.list.newName("case_when_isNull"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)isNullExpression));
        Result result = new Result(isNullVariable, valueVariable);
        this.rexResultMap.put((RexNode)call, result);
        return result;
    }

    private static void implementRecursively(RexToLixTranslator currentTranslator, List<RexNode> operandList, ParameterExpression valueVariable, RelDataType valueType, int pos) {
        BlockBuilder currentBlockBuilder = currentTranslator.getBlockBuilder();
        List<@Nullable Type> storageTypes = ConverterUtils.internalTypes(operandList);
        if (pos == operandList.size() - 1) {
            Expression res = RexToLixTranslator.implementCallOperand2(operandList.get(pos), storageTypes.get(pos), currentTranslator);
            currentBlockBuilder.add(Expressions.statement((Expression)Expressions.assign((Expression)valueVariable, (Expression)ConverterUtils.convert(res, valueType))));
            return;
        }
        RexNode testerNode = operandList.get(pos);
        Result testerResult = RexToLixTranslator.implementCallOperand(testerNode, storageTypes.get(pos), currentTranslator);
        BinaryExpression tester = Expressions.andAlso((Expression)Expressions.not((Expression)testerResult.isNullVariable), (Expression)testerResult.valueVariable);
        RexNode ifTrueNode = operandList.get(pos + 1);
        BlockBuilder ifTrueBlockBuilder = new BlockBuilder(true, currentBlockBuilder);
        RexToLixTranslator ifTrueTranslator = currentTranslator.setBlock(ifTrueBlockBuilder);
        Expression ifTrueRes = RexToLixTranslator.implementCallOperand2(ifTrueNode, storageTypes.get(pos + 1), ifTrueTranslator);
        ifTrueBlockBuilder.add(Expressions.statement((Expression)Expressions.assign((Expression)valueVariable, (Expression)ConverterUtils.convert(ifTrueRes, valueType))));
        BlockStatement ifTrue = ifTrueBlockBuilder.toBlock();
        if (pos + 1 == operandList.size() - 1) {
            currentBlockBuilder.add((Statement)Expressions.ifThen((Expression)tester, (Node)ifTrue));
            return;
        }
        BlockBuilder ifFalseBlockBuilder = new BlockBuilder(true, currentBlockBuilder);
        RexToLixTranslator ifFalseTranslator = currentTranslator.setBlock(ifFalseBlockBuilder);
        RexToLixTranslator.implementRecursively(ifFalseTranslator, operandList, valueVariable, valueType, pos + 2);
        BlockStatement ifFalse = ifFalseBlockBuilder.toBlock();
        currentBlockBuilder.add((Statement)Expressions.ifThenElse((Expression)tester, (Node)ifTrue, (Node)ifFalse));
    }

    private Result toInnerStorageType(Result result, Type storageType) {
        Expression valueExpression = ConverterUtils.toInternal((Expression)result.valueVariable, storageType);
        if (valueExpression.equals((Object)result.valueVariable)) {
            return result;
        }
        ParameterExpression valueVariable = Expressions.parameter((Type)valueExpression.getType(), (String)this.list.newName(result.valueVariable.name + "_inner_type"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)valueVariable, (Expression)valueExpression));
        ParameterExpression isNullVariable = result.isNullVariable;
        return new Result(isNullVariable, valueVariable);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Result visitDynamicParam(RexDynamicParam dynamicParam) {
        @Nullable Pair key = Pair.of((Object)dynamicParam, (Object)this.currentStorageType);
        if (this.rexWithStorageTypeResultMap.containsKey(key)) {
            return this.rexWithStorageTypeResultMap.get(key);
        }
        MethodCallExpression ctxGet = Expressions.call((Expression)this.root, (Method)BuiltInMethod.DATA_CONTEXT_GET.method, (Expression[])new Expression[]{Expressions.constant((Object)("?" + dynamicParam.getIndex()))});
        Expression valueExpression = ConverterUtils.convert((Expression)ctxGet, dynamicParam.getType());
        ParameterExpression valueVariable = Expressions.parameter((Type)valueExpression.getType(), (String)this.list.newName("value_dynamic_param"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)valueVariable, (Expression)valueExpression));
        ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)this.list.newName("isNull_dynamic_param"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)this.checkNull((Expression)valueVariable)));
        Result result = new Result(isNullVariable, valueVariable);
        this.rexWithStorageTypeResultMap.put((Pair<RexNode, Type>)key, result);
        return result;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Result visitFieldAccess(RexFieldAccess fieldAccess) {
        @Nullable Pair key = Pair.of((Object)fieldAccess, (Object)this.currentStorageType);
        if (this.rexWithStorageTypeResultMap.containsKey(key)) {
            return this.rexWithStorageTypeResultMap.get(key);
        }
        RexNode target = this.deref(fieldAccess.getReferenceExpr());
        int fieldIndex = fieldAccess.getField().getIndex();
        String fieldName = fieldAccess.getField().getName();
        switch (target.getKind()) {
            case CORREL_VARIABLE: {
                if (this.correlates == null) {
                    throw new RuntimeException("Cannot translate " + fieldAccess + " since correlate variables resolver is not defined");
                }
                InputGetter getter = (InputGetter)this.correlates.apply((Object)((RexCorrelVariable)target).getName());
                Expression input = getter.field(this.list, fieldIndex, this.currentStorageType);
                Expression condition = this.checkNull(input);
                ParameterExpression valueVariable = Expressions.parameter((Type)input.getType(), (String)this.list.newName("corInp_value"));
                this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)valueVariable, (Expression)input));
                ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)this.list.newName("corInp_isNull"));
                Expression isNullExpression = Expressions.condition((Expression)condition, (Expression)RexImpTable.TRUE_EXPR, (Expression)this.checkNull((Expression)valueVariable));
                this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)isNullExpression));
                Result result1 = new Result(isNullVariable, valueVariable);
                this.rexWithStorageTypeResultMap.put((Pair<RexNode, Type>)key, result1);
                return result1;
            }
        }
        RexNode rxIndex = this.builder.makeLiteral((Object)fieldIndex, this.typeFactory.createType(Integer.TYPE), true);
        RexNode rxName = this.builder.makeLiteral((Object)fieldName, this.typeFactory.createType(String.class), true);
        RexCall accessCall = (RexCall)this.builder.makeCall(fieldAccess.getType(), (SqlOperator)SqlStdOperatorTable.STRUCT_ACCESS, (List)ImmutableList.of((Object)target, (Object)rxIndex, (Object)rxName));
        Result result2 = (Result)accessCall.accept((RexVisitor)this);
        this.rexWithStorageTypeResultMap.put((Pair<RexNode, Type>)key, result2);
        return result2;
    }

    public Result visitOver(RexOver over) {
        throw new RuntimeException("cannot translate expression " + over);
    }

    public Result visitCorrelVariable(RexCorrelVariable correlVariable) {
        throw new RuntimeException("Cannot translate " + correlVariable + ". Correlated variables should always be referenced by field access");
    }

    public Result visitRangeRef(RexRangeRef rangeRef) {
        throw new RuntimeException("cannot translate expression " + rangeRef);
    }

    public Result visitSubQuery(RexSubQuery subQuery) {
        throw new RuntimeException("cannot translate expression " + subQuery);
    }

    public Result visitTableInputRef(RexTableInputRef fieldRef) {
        throw new RuntimeException("cannot translate expression " + fieldRef);
    }

    public Result visitPatternFieldRef(RexPatternFieldRef fieldRef) {
        return this.visitInputRef((RexInputRef)fieldRef);
    }

    public Result visitLambda(RexLambda lambda) {
        RexNode expression = lambda.getExpression();
        List rexLambdaRefs = lambda.getParameters();
        ParameterExpression[] parameterExpressions = new ParameterExpression[rexLambdaRefs.size()];
        for (int i = 0; i < rexLambdaRefs.size(); ++i) {
            RexLambdaRef rexLambdaRef = (RexLambdaRef)rexLambdaRefs.get(i);
            parameterExpressions[i] = Expressions.parameter((Type)this.typeFactory.getJavaClass(rexLambdaRef.getType()), (String)rexLambdaRef.getName());
        }
        RexToLixTranslator exprTranslator = this.setBlock(new BlockBuilder());
        Result exprResult = (Result)expression.accept((RexVisitor)exprTranslator);
        exprTranslator.list.add((Statement)Expressions.return_(null, (Expression)exprResult.valueVariable));
        FunctionExpression functionExpression = Expressions.lambda((BlockStatement)exprTranslator.list.toBlock(), (ParameterExpression[])parameterExpressions);
        ParameterExpression valueVariable = Expressions.parameter((Type)functionExpression.getType(), (String)this.list.newName("function_value"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)valueVariable, (Expression)functionExpression));
        Expression isNullExpression = this.checkNull((Expression)valueVariable);
        ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)this.list.newName("function_isNull"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)isNullExpression));
        return new Result(isNullVariable, valueVariable);
    }

    public Result visitNodeAndFieldIndex(RexNodeAndFieldIndex nodeAndFieldIndex) {
        throw new RuntimeException("cannot translate expression " + nodeAndFieldIndex);
    }

    Expression checkNull(Expression expr) {
        if (Primitive.flavor((Type)expr.getType()) == Primitive.Flavor.PRIMITIVE) {
            return RexImpTable.FALSE_EXPR;
        }
        return Expressions.equal((Expression)expr, (Expression)RexImpTable.NULL_EXPR);
    }

    Expression checkNotNull(Expression expr) {
        if (Primitive.flavor((Type)expr.getType()) == Primitive.Flavor.PRIMITIVE) {
            return RexImpTable.TRUE_EXPR;
        }
        return Expressions.notEqual((Expression)expr, (Expression)RexImpTable.NULL_EXPR);
    }

    BlockBuilder getBlockBuilder() {
        return this.list;
    }

    Expression getLiteral(Expression literalVariable) {
        return Objects.requireNonNull(this.literalMap.get(literalVariable), () -> "literalMap.get(literalVariable) for " + literalVariable);
    }

    @Nullable
    Object getLiteralValue(@Nullable Expression expr) {
        if (expr instanceof ParameterExpression) {
            Expression constantExpr = this.literalMap.get(expr);
            return this.getLiteralValue(constantExpr);
        }
        if (expr instanceof ConstantExpression) {
            return ((ConstantExpression)expr).value;
        }
        return null;
    }

    List<Result> getCallOperandResult(RexCall call) {
        return Objects.requireNonNull(this.callOperandResultMap.get(call), () -> "callOperandResultMap.get(call) for " + call);
    }

    Expression functionInstance(RexCall call, Method method) {
        RexCallBinding callBinding = RexCallBinding.create((RelDataTypeFactory)this.typeFactory, (RexCall)call, (RexProgram)this.program, (List)ImmutableList.of());
        Expression target = this.getInstantiationExpression(method, callBinding);
        return this.appendConstant("f", target);
    }

    private Expression getInstantiationExpression(Method method, RexCallBinding callBinding) {
        Class<?> declaringClass = method.getDeclaringClass();
        try {
            Constructor<?> constructor = declaringClass.getConstructor(FunctionContext.class);
            ArrayList constantArgs = new ArrayList();
            Ord.forEach((Object[])method.getParameterTypes(), (parameterType, i) -> constantArgs.add(callBinding.isOperandLiteral(i, true) ? this.appendConstant("_arg", (Expression)Expressions.constant((Object)callBinding.getOperandLiteralValue(i, Primitive.box((Class)parameterType)))) : Expressions.constant(null)));
            MethodCallExpression context = Expressions.call((Method)BuiltInMethod.FUNCTION_CONTEXTS_OF.method, (Expression[])new Expression[]{DataContext.ROOT, Expressions.newArrayInit(Object.class, constantArgs)});
            return Expressions.new_(constructor, (Expression[])new Expression[]{context});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return Expressions.new_(declaringClass);
        }
    }

    private Expression appendConstant(String name, Expression e) {
        if (this.staticList != null) {
            String upperName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, name);
            return this.staticList.append(upperName, e);
        }
        return this.list.append(name, e);
    }

    public static interface InputGetter {
        public Expression field(BlockBuilder var1, int var2, @Nullable Type var3);
    }

    public static class Result {
        final ParameterExpression isNullVariable;
        final ParameterExpression valueVariable;

        public Result(ParameterExpression isNullVariable, ParameterExpression valueVariable) {
            this.isNullVariable = isNullVariable;
            this.valueVariable = valueVariable;
        }
    }

    public static class InputGetterImpl
    implements InputGetter {
        private final ImmutableMap<Expression, PhysType> inputs;

        @Deprecated
        public InputGetterImpl(List<Pair<Expression, PhysType>> inputs) {
            this(InputGetterImpl.mapOf(inputs));
        }

        public InputGetterImpl(Expression e, PhysType physType) {
            this((Map<Expression, PhysType>)ImmutableMap.of((Object)e, (Object)physType));
        }

        public InputGetterImpl(Map<Expression, PhysType> inputs) {
            this.inputs = ImmutableMap.copyOf(inputs);
        }

        private static <K, V> Map<K, V> mapOf(Iterable<? extends Map.Entry<K, V>> entries) {
            ImmutableMap.Builder b = ImmutableMap.builder();
            Pair.forEach(entries, (arg_0, arg_1) -> ((ImmutableMap.Builder)b).put(arg_0, arg_1));
            return b.build();
        }

        @Override
        public Expression field(BlockBuilder list, int index, @Nullable Type storageType) {
            int offset = 0;
            for (Map.Entry input : this.inputs.entrySet()) {
                PhysType physType = (PhysType)input.getValue();
                int fieldCount = physType.getRowType().getFieldCount();
                if (index >= offset + fieldCount) {
                    offset += fieldCount;
                    continue;
                }
                Expression left = list.append("current", (Expression)input.getKey());
                return physType.fieldReference(left, index - offset, storageType);
            }
            throw new IllegalArgumentException("Unable to find field #" + index);
        }
    }
}

