/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.ignite.internal.sql.engine.api.expressions.RowFactory;
import org.apache.ignite.internal.sql.engine.exec.SqlEvaluationContext;
import org.apache.ignite.internal.sql.engine.exec.exp.BiFieldGetter;
import org.apache.ignite.internal.sql.engine.exec.exp.CodegenUtils;
import org.apache.ignite.internal.sql.engine.exec.exp.CorrelatesBuilder;
import org.apache.ignite.internal.sql.engine.exec.exp.RexToLixTranslator;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlExpressionFactoryImpl;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlJoinProjection;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.IgniteMethod;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.sql.engine.util.cache.Cache;
import org.apache.ignite.internal.type.StructNativeType;

class JoinProjectionImplementor {
    private final Cache<String, Object> cache;
    private final RexBuilder rexBuilder;
    private final JavaTypeFactory typeFactory;
    private final SqlConformance conformance;

    JoinProjectionImplementor(Cache<String, Object> cache, RexBuilder rexBuilder, JavaTypeFactory typeFactory, SqlConformance conformance) {
        this.cache = cache;
        this.rexBuilder = rexBuilder;
        this.typeFactory = typeFactory;
        this.conformance = conformance;
    }

    SqlJoinProjection implement(List<RexNode> projections, RelDataType type, int firstRowSize) {
        String digest = SqlExpressionFactoryImpl.digest(SqlJoinProjection.class, projections, type, "firstRowSize=" + firstRowSize);
        Cache cache = (Cache)Commons.cast(this.cache);
        return cache.get(digest, key -> {
            SqlJoinProjectionExt projectionExt = this.implementInternal(projections, type, firstRowSize);
            return new SqlJoinProjectionImpl(projectionExt, TypeUtils.structuredTypeFromRelTypeList(RexUtil.types((List)projections)));
        });
    }

    private SqlJoinProjectionExt implementInternal(List<RexNode> projections, RelDataType type, int firstRowSize) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(type, this.rexBuilder);
        for (RexNode node : projections) {
            assert (node != null) : "unexpected nullable node";
            programBuilder.addProject(node, null);
        }
        RexProgram program = programBuilder.getProgram();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression ctx = Expressions.parameter(SqlEvaluationContext.class, (String)"ctx");
        ParameterExpression left = Expressions.parameter(Object.class, (String)"left");
        ParameterExpression right = Expressions.parameter(Object.class, (String)"right");
        ParameterExpression outBuilder = Expressions.parameter(RowFactory.RowBuilder.class, (String)"outBuilder");
        builder.add((Statement)Expressions.declare((int)16, (ParameterExpression)DataContext.ROOT, (Expression)Expressions.convert_((Expression)ctx, DataContext.class)));
        Expression rowHandler = builder.append("hnd", (Expression)Expressions.call((Expression)ctx, (Method)IgniteMethod.CONTEXT_ROW_HANDLER.method(), (Expression[])new Expression[0]));
        BiFieldGetter inputGetter = new BiFieldGetter(rowHandler, (Expression)left, (Expression)right, type, firstRowSize);
        Function1<String, RexToLixTranslator.InputGetter> correlates = new CorrelatesBuilder(builder, (Expression)ctx, rowHandler).build(projections);
        List<Expression> projects = RexToLixTranslator.translateProjects(program, this.typeFactory, this.conformance, builder, null, null, (Expression)ctx, inputGetter, correlates);
        for (Expression val : projects) {
            MethodCallExpression addRowField = Expressions.call((Expression)outBuilder, (Method)IgniteMethod.ROW_BUILDER_ADD_FIELD.method(), (Expression[])new Expression[]{val});
            builder.add(Expressions.statement((Expression)addRowField));
        }
        BlockStatement methodBody = CodegenUtils.wrapWithConversionToEvaluationException((Statement)builder.toBlock());
        List<ParameterExpression> params = List.of(ctx, left, right, outBuilder);
        MethodDeclaration declaration = Expressions.methodDecl((int)1, Void.TYPE, (String)"project", params, (BlockStatement)methodBody);
        Class clazz = (Class)Commons.cast(SqlJoinProjectionExt.class);
        String body = Expressions.toString(List.of(declaration), (String)"\n", (boolean)false);
        return (SqlJoinProjectionExt)Commons.compile(clazz, body);
    }

    @FunctionalInterface
    public static interface SqlJoinProjectionExt {
        public <RowT> void project(SqlEvaluationContext<RowT> var1, RowT var2, RowT var3, RowFactory.RowBuilder<RowT> var4);
    }

    private static class SqlJoinProjectionImpl
    implements SqlJoinProjection {
        private final SqlJoinProjectionExt projection;
        private final StructNativeType rowType;

        private SqlJoinProjectionImpl(SqlJoinProjectionExt projection, StructNativeType rowType) {
            this.projection = projection;
            this.rowType = rowType;
        }

        private <RowT> RowFactory.RowBuilder<RowT> builder(SqlEvaluationContext<RowT> context) {
            return context.rowFactoryFactory().create(this.rowType).rowBuilder();
        }

        @Override
        public <RowT> RowT project(SqlEvaluationContext<RowT> context, RowT left, RowT right) {
            RowFactory.RowBuilder<RowT> rowBuilder = this.builder(context);
            this.projection.project(context, left, right, rowBuilder);
            return (RowT)rowBuilder.buildAndReset();
        }
    }
}

