/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import org.apache.ignite.internal.lang.InternalTuple;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.sql.engine.api.expressions.RowFactory;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.SqlOutputBinaryRow;
import org.apache.ignite.internal.sql.engine.exec.TableRowConverter;

public class TableRowConverterImpl
implements TableRowConverter {
    protected final SchemaRegistry schemaRegistry;
    protected final SchemaDescriptor schemaDescriptor;

    public TableRowConverterImpl(SchemaRegistry schemaRegistry, SchemaDescriptor schemaDescriptor) {
        this.schemaRegistry = schemaRegistry;
        this.schemaDescriptor = schemaDescriptor;
    }

    @Override
    public <RowT> BinaryRowEx toFullRow(ExecutionContext<RowT> ectx, RowT row) {
        BinaryTuple binaryTuple = ectx.rowAccessor().toBinaryTuple(row);
        return SqlOutputBinaryRow.newRow(this.schemaDescriptor, (InternalTuple)binaryTuple);
    }

    @Override
    public <RowT> BinaryRowEx toKeyRow(ExecutionContext<RowT> ectx, RowT row) {
        BinaryTuple binaryTuple = ectx.rowAccessor().toBinaryTuple(row);
        return SqlOutputBinaryRow.newKeyRow(this.schemaDescriptor, (InternalTuple)binaryTuple);
    }

    @Override
    public <RowT> RowT toRow(ExecutionContext<RowT> ectx, BinaryRow tableRow, RowFactory<RowT> factory) {
        Object tuple = tableRow.schemaVersion() == this.schemaDescriptor.version() ? new BinaryTuple(this.schemaDescriptor.length(), tableRow.tupleSlice()) : this.schemaRegistry.resolve(tableRow, this.schemaDescriptor);
        return (RowT)factory.create((InternalTuple)tuple);
    }
}

