/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.SqlOperationContext;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.exec.AsyncDataCursor;
import org.apache.ignite.internal.sql.engine.exec.ExecutionService;
import org.apache.ignite.internal.sql.engine.exec.PrivilegesCollector;
import org.apache.ignite.internal.sql.engine.prepare.DdlPlan;
import org.apache.ignite.internal.sql.engine.prepare.ExplainPlan;
import org.apache.ignite.internal.sql.engine.prepare.ExplainablePlan;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.security.context.GridGainSecurity;
import org.gridgain.internal.security.context.SecurityContext;

public class SecuredExecutionService
implements ExecutionService {
    private final ExecutionService executionService;
    private final Authorizer authorizer;

    public SecuredExecutionService(ExecutionService executionService, Authorizer authorizer) {
        this.executionService = executionService;
        this.authorizer = authorizer;
    }

    @Override
    public CompletableFuture<AsyncDataCursor<InternalSqlRow>> executePlan(QueryPlan plan, SqlOperationContext ctx) {
        return (CompletableFuture)GridGainSecurity.getWith((SecurityContext)ctx.securityContext(), () -> this.doExecutePlan(plan, ctx));
    }

    @Override
    public CompletableFuture<List<AsyncDataCursor<InternalSqlRow>>> executeDdlBatch(List<DdlPlan> batch, SecurityContext securityContext, Consumer<HybridTimestamp> activationTimeListener) {
        return (CompletableFuture)GridGainSecurity.getWith((SecurityContext)securityContext, () -> this.executionService.executeDdlBatch(batch, securityContext, activationTimeListener));
    }

    private CompletableFuture<AsyncDataCursor<InternalSqlRow>> doExecutePlan(QueryPlan plan, SqlOperationContext ctx) {
        SqlQueryType queryType = plan.type();
        assert (queryType != null) : "Root plan can not be a fragment";
        switch (queryType) {
            case DML: 
            case QUERY: 
            case EXPLAIN: {
                return this.authorizeQueryPlan(plan).thenCompose(ignored -> this.executionService.executePlan(plan, ctx));
            }
            case DDL: 
            case DCL: 
            case KILL: 
            case SHOW: 
            case COPY: {
                return this.executionService.executePlan(plan, ctx);
            }
        }
        throw new AssertionError((Object)("Unexpected query type: " + queryType));
    }

    private CompletableFuture<Void> authorizeQueryPlan(QueryPlan plan) {
        IgniteRel igniteRel = SecuredExecutionService.extractNode(plan);
        Set<Privilege> privileges = PrivilegesCollector.getPrivileges(igniteRel);
        return this.authorizer.authorizeAsync(privileges);
    }

    private static IgniteRel extractNode(QueryPlan plan) {
        if (plan instanceof ExplainablePlan) {
            return ((ExplainablePlan)plan).getRel();
        }
        assert (plan instanceof ExplainPlan) : plan.getClass();
        return SecuredExecutionService.extractNode(((ExplainPlan)plan).plan());
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() throws Exception {
    }
}

