/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiFunction;
import org.apache.ignite.internal.sql.engine.prepare.dcl.AssignRolesCommand;
import org.apache.ignite.internal.sql.engine.prepare.dcl.CreateRoleCommand;
import org.apache.ignite.internal.sql.engine.prepare.dcl.CreateUserCommand;
import org.apache.ignite.internal.sql.engine.prepare.dcl.DclCommand;
import org.apache.ignite.internal.sql.engine.prepare.dcl.DropRoleCommand;
import org.apache.ignite.internal.sql.engine.prepare.dcl.DropUserCommand;
import org.apache.ignite.internal.sql.engine.prepare.dcl.PrivilegesCommand;
import org.apache.ignite.internal.sql.engine.prepare.dcl.RevokeRolesCommand;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.license.MissingRequiredFeaturesException;
import org.gridgain.internal.rbac.assignments.RoleAssignmentManagement;
import org.gridgain.internal.rbac.privileges.PrivilegeAlias;
import org.gridgain.internal.rbac.privileges.PrivilegeManagement;
import org.gridgain.internal.rbac.roles.Role;
import org.gridgain.internal.rbac.roles.RoleManagement;
import org.gridgain.internal.rbac.roles.exception.RoleAlreadyExistsException;
import org.gridgain.internal.rbac.roles.exception.RoleNotFoundException;
import org.gridgain.internal.rbac.users.User;
import org.gridgain.internal.rbac.users.UserManagement;
import org.gridgain.internal.rbac.users.exception.UserAlreadyExistsException;
import org.gridgain.internal.rbac.users.exception.UserNotFoundException;

public class DclCommandHandler {
    private static final Set<LicenseFeature> FEATURES = Set.of(LicenseFeature.RBAC, LicenseFeature.SECURITY);
    private final LicenseFeatureChecker licenseFeatureChecker;
    private final UserManagement userManagement;
    private final RoleManagement roleManagement;
    private final PrivilegeManagement privilegeManagement;
    private final RoleAssignmentManagement roleAssignmentManagement;

    public DclCommandHandler(UserManagement userManagement, RoleManagement roleManagement, PrivilegeManagement privilegeManagement, RoleAssignmentManagement roleAssignmentManagement, LicenseFeatureChecker licenseFeatureChecker) {
        this.userManagement = userManagement;
        this.roleManagement = roleManagement;
        this.privilegeManagement = privilegeManagement;
        this.roleAssignmentManagement = roleAssignmentManagement;
        this.licenseFeatureChecker = licenseFeatureChecker;
    }

    public CompletableFuture<Boolean> handle(DclCommand cmd) {
        try {
            this.licenseFeatureChecker.checkAnyFeature(FEATURES);
        }
        catch (MissingRequiredFeaturesException e) {
            return CompletableFuture.failedFuture(e);
        }
        if (cmd instanceof CreateUserCommand) {
            return this.handleCreateUser((CreateUserCommand)cmd);
        }
        if (cmd instanceof DropUserCommand) {
            return this.handleDropUser((DropUserCommand)cmd);
        }
        if (cmd instanceof CreateRoleCommand) {
            return this.handleCreateRole((CreateRoleCommand)cmd);
        }
        if (cmd instanceof DropRoleCommand) {
            return this.handleDropRole((DropRoleCommand)cmd);
        }
        if (cmd instanceof AssignRolesCommand) {
            return this.handleAssignRoles((AssignRolesCommand)cmd);
        }
        if (cmd instanceof RevokeRolesCommand) {
            return this.handleRevokeRoles((RevokeRolesCommand)cmd);
        }
        if (cmd instanceof PrivilegesCommand) {
            return this.handlePrivileges((PrivilegesCommand)cmd).thenApply(v -> true);
        }
        throw new UnsupportedOperationException("Unsupported command: " + cmd.getClass().getCanonicalName());
    }

    private CompletableFuture<Boolean> handleCreateUser(CreateUserCommand cmd) {
        User user = User.builder().username(cmd.username()).password(cmd.password()).build();
        return this.userManagement.createAsync(user).handle(DclCommandHandler.handleRbacResult(cmd.ifNotExists(), UserAlreadyExistsException.class));
    }

    private CompletableFuture<Boolean> handleDropUser(DropUserCommand cmd) {
        return this.userManagement.dropByUsernameAsync(cmd.username()).handle(DclCommandHandler.handleRbacResult(cmd.ifExists(), UserNotFoundException.class));
    }

    private CompletableFuture<Boolean> handleCreateRole(CreateRoleCommand cmd) {
        return this.roleManagement.createAsync(Role.builder().name(cmd.name()).build()).handle(DclCommandHandler.handleRbacResult(cmd.ifNotExists(), RoleAlreadyExistsException.class));
    }

    private CompletableFuture<Boolean> handleDropRole(DropRoleCommand cmd) {
        return this.roleManagement.dropAsync(cmd.name(), true).handle(DclCommandHandler.handleRbacResult(cmd.ifExists(), RoleNotFoundException.class));
    }

    private CompletableFuture<Boolean> handleAssignRoles(AssignRolesCommand cmd) {
        return this.roleAssignmentManagement.assignAsync(cmd.rolenames(), cmd.usernames()).thenApply(v -> true);
    }

    private CompletableFuture<Boolean> handleRevokeRoles(RevokeRolesCommand cmd) {
        return this.roleAssignmentManagement.revokeAsync(cmd.rolenames(), cmd.usernames()).thenApply(v -> true);
    }

    private CompletableFuture<Void> handlePrivileges(PrivilegesCommand cmd) {
        PrivilegeAlias privilegeAlias = cmd.privilegeAlias();
        if (privilegeAlias != null) {
            return cmd.isGrant() ? this.privilegeManagement.grantAsync(privilegeAlias, cmd.rolenames()) : this.privilegeManagement.revokeAsync(privilegeAlias, cmd.rolenames());
        }
        return cmd.isGrant() ? this.privilegeManagement.grantAsync(cmd.privileges(), cmd.rolenames()) : this.privilegeManagement.revokeAsync(cmd.privileges(), cmd.rolenames());
    }

    private static BiFunction<Void, Throwable, Boolean> handleRbacResult(boolean ignoreExpectedError, Class<?> expErrCls) {
        return (none, err) -> {
            if (err == null) {
                return true;
            }
            if (ignoreExpectedError) {
                Throwable err0;
                Throwable throwable = err0 = err instanceof CompletionException ? err.getCause() : err;
                if (expErrCls.isAssignableFrom(err0.getClass())) {
                    return false;
                }
            }
            throw err instanceof RuntimeException ? (RuntimeException)err : new CompletionException((Throwable)err);
        };
    }
}

