/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine;

import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.SchemaAwareConverter;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.jetbrains.annotations.Nullable;

public class InternalSqlRowImpl<RowT>
implements InternalSqlRow {
    private final RowT row;
    private final RowHandler<RowT> rowHandler;
    private final SchemaAwareConverter<Object, Object> internalTypeConverter;

    public InternalSqlRowImpl(RowT row, RowHandler<RowT> rowHandler, SchemaAwareConverter<Object, Object> internalTypeConverter) {
        this.row = row;
        this.rowHandler = rowHandler;
        this.internalTypeConverter = internalTypeConverter;
    }

    @Nullable
    public Object get(int idx) {
        Object res = this.rowHandler.get(idx, this.row);
        return this.internalTypeConverter.convert(idx, res);
    }

    public int fieldCount() {
        return this.rowHandler.columnsCount(this.row);
    }

    public BinaryTuple asBinaryTuple() {
        return this.rowHandler.toBinaryTuple(this.row);
    }
}

