/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql.dcl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.ignite.internal.sql.engine.sql.IgniteDdlOperator;
import org.apache.ignite.internal.sql.engine.sql.dcl.GridgainSqlDcl;
import org.jetbrains.annotations.Nullable;

public class GridgainSqlCreateUser
extends SqlCreate
implements GridgainSqlDcl {
    private final SqlIdentifier username;
    private final SqlIdentifier authenticationMethod;
    private final SqlLiteral password;

    public GridgainSqlCreateUser(SqlParserPos pos, boolean ifNotExists, SqlIdentifier username, SqlIdentifier authenticationMethod, SqlLiteral password) {
        super((SqlOperator)new Operator(ifNotExists), pos, false, ifNotExists);
        this.username = username;
        this.authenticationMethod = authenticationMethod;
        this.password = password;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.username, (Object)this.authenticationMethod, (Object)this.password);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        writer.keyword("USER");
        if (this.ifNotExists()) {
            writer.keyword("IF NOT EXISTS");
        }
        this.username.unparse(writer, leftPrec, rightPrec);
        writer.keyword("IDENTIFIED");
        writer.keyword("WITH");
        this.authenticationMethod.unparse(writer, leftPrec, rightPrec);
        writer.keyword("BY");
        this.password.unparse(writer, leftPrec, rightPrec);
    }

    public SqlIdentifier username() {
        return this.username;
    }

    public SqlIdentifier authenticationMethod() {
        return this.authenticationMethod;
    }

    public String password() {
        return (String)this.password.getValueAs(String.class);
    }

    public boolean ifNotExists() {
        Operator operator = (Operator)this.getOperator();
        return operator.existFlag();
    }

    public String toString() {
        return "CREATE USER " + (this.ifNotExists() ? "IF NOT EXIST " : "") + this.username + "IDENTIFIED WITH " + this.authenticationMethod + "BY ******";
    }

    protected static class Operator
    extends IgniteDdlOperator {
        public Operator(boolean existFlag) {
            super("CREATE USER", SqlKind.OTHER_DDL, existFlag);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new GridgainSqlCreateUser(pos, this.existFlag(), (SqlIdentifier)operands[0], (SqlIdentifier)operands[1], (SqlLiteral)operands[2]);
        }
    }
}

