/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.externalize;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.sql.engine.externalize.RelInputEx;
import org.apache.ignite.internal.sql.engine.externalize.RelJson;
import org.apache.ignite.internal.sql.engine.externalize.RelOptSchemaImpl;
import org.apache.ignite.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.lang.ErrorGroups;

public class RelJsonReader {
    static final TypeReference<LinkedHashMap<String, Object>> TYPE_REF = new TypeReference<LinkedHashMap<String, Object>>(){};
    private static final Map<String, Object> EMPTY_JSON_RELS = Map.of("rels", List.of());
    private final ObjectMapper mapper = new ObjectMapper().enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
    private final RelJson relJson;
    private final RelOptSchema relOptSchema;
    private final Map<String, RelNode> relMap = new LinkedHashMap<String, RelNode>();
    private RelNode lastRel;

    public static <T extends RelNode> T fromJson(SchemaPlus rootSchema, String json) {
        RelJsonReader reader = new RelJsonReader(rootSchema);
        return (T)reader.read(json);
    }

    public static RexNode fromExprJson(String json) {
        try {
            RelJsonReader reader = new RelJsonReader(null);
            RelInput relInput = reader.newInput(EMPTY_JSON_RELS);
            LinkedHashMap val = (LinkedHashMap)reader.mapper.readValue(json, TYPE_REF);
            return reader.relJson.toRex(relInput, val);
        }
        catch (IOException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "RelJson expression serialization error", (Throwable)e);
        }
    }

    public RelJsonReader(SchemaPlus rootSchema) {
        this.relOptSchema = new RelOptSchemaImpl(rootSchema);
        this.relJson = new RelJson();
    }

    public RelNode read(String s) {
        try {
            this.lastRel = null;
            Map o = (Map)this.mapper.readValue(s, TYPE_REF);
            List rels = (List)o.get("rels");
            this.readRels(rels);
            return this.lastRel;
        }
        catch (IOException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "RelJson deserialization error", (Throwable)e);
        }
    }

    private void readRels(List<Map<String, Object>> jsonRels) {
        for (Map<String, Object> jsonRel : jsonRels) {
            this.readRel(jsonRel);
        }
    }

    private void readRel(Map<String, Object> jsonRel) {
        String id = (String)jsonRel.get("id");
        String type = (String)jsonRel.get("relOp");
        Function<RelInput, RelNode> factory = this.relJson.factory(type);
        RelNode rel = factory.apply(this.newInput(jsonRel));
        this.relMap.put(id, rel);
        this.lastRel = rel;
    }

    private RelInput newInput(Map<String, Object> jsonRel) {
        return new RelInputImpl(jsonRel);
    }

    private class RelInputImpl
    implements RelInputEx {
        private final Map<String, Object> jsonRel;

        private RelInputImpl(Map<String, Object> jsonRel) {
            this.jsonRel = jsonRel;
        }

        public RelOptCluster getCluster() {
            return Commons.emptyCluster();
        }

        public RelTraitSet getTraitSet() {
            return Commons.emptyCluster().traitSet();
        }

        public RelOptTable getTable(String table) {
            List<String> list = this.getStringList(table);
            return RelJsonReader.this.relOptSchema.getTableForMember(list);
        }

        public RelNode getInput() {
            List<RelNode> inputs = this.getInputs();
            assert (inputs.size() == 1);
            return inputs.get(0);
        }

        public List<RelNode> getInputs() {
            List<String> jsonInputs = this.getStringList("inputs");
            if (jsonInputs == null) {
                return List.of(RelJsonReader.this.lastRel);
            }
            ArrayList<RelNode> inputs = new ArrayList<RelNode>();
            for (String jsonInput : jsonInputs) {
                inputs.add(this.lookupInput(jsonInput));
            }
            return inputs;
        }

        public RexNode getExpression(String tag) {
            return RelJsonReader.this.relJson.toRex(this, this.jsonRel.get(tag));
        }

        public ImmutableBitSet getBitSet(String tag) {
            return ImmutableBitSet.of(this.getIntegerList(tag));
        }

        public List<ImmutableBitSet> getBitSetList(String tag) {
            List<List<Integer>> list = this.getIntegerListList(tag);
            if (list == null) {
                return null;
            }
            ArrayList<ImmutableBitSet> bitSets = new ArrayList<ImmutableBitSet>();
            for (List<Integer> integers : list) {
                bitSets.add(ImmutableBitSet.of(integers));
            }
            return List.copyOf(bitSets);
        }

        public List<String> getStringList(String tag) {
            return (List)this.jsonRel.get(tag);
        }

        public List<Integer> getIntegerList(String tag) {
            return (List)this.jsonRel.get(tag);
        }

        public List<List<Integer>> getIntegerListList(String tag) {
            return (List)this.jsonRel.get(tag);
        }

        public List<AggregateCall> getAggregateCalls(String tag) {
            List jsonAggs = (List)this.jsonRel.get(tag);
            ArrayList<AggregateCall> inputs = new ArrayList<AggregateCall>();
            for (Map jsonAggCall : jsonAggs) {
                inputs.add(this.toAggCall(jsonAggCall));
            }
            return inputs;
        }

        public Object get(String tag) {
            return this.jsonRel.get(tag);
        }

        public String getString(String tag) {
            return (String)this.jsonRel.get(tag);
        }

        public float getFloat(String tag) {
            return ((Number)this.jsonRel.get(tag)).floatValue();
        }

        public BigDecimal getBigDecimal(String tag) {
            return SqlFunctions.toBigDecimal((Object)this.getNonNull(tag));
        }

        private Object getNonNull(String tag) {
            return Objects.requireNonNull(this.get(tag), () -> "no entry for tag " + tag);
        }

        public boolean getBoolean(String tag, boolean def) {
            Boolean b = (Boolean)this.jsonRel.get(tag);
            return b != null ? b : def;
        }

        public <E extends Enum<E>> E getEnum(String tag, Class<E> enumClass) {
            return (E)Util.enumVal(enumClass, (String)this.getString(tag).toUpperCase(Locale.ROOT));
        }

        public List<RexNode> getExpressionList(String tag) {
            List jsonNodes = (List)this.jsonRel.get(tag);
            ArrayList<RexNode> nodes = new ArrayList<RexNode>();
            for (Object jsonNode : jsonNodes) {
                nodes.add(RelJsonReader.this.relJson.toRex(this, jsonNode));
            }
            return nodes;
        }

        public RelDataType getRowType(String tag) {
            Object o = this.jsonRel.get(tag);
            return RelJsonReader.this.relJson.toType((RelDataTypeFactory)Commons.typeFactory(), o);
        }

        public RelDataType getRowType(String expressionsTag, String fieldsTag) {
            final List<RexNode> expressionList = this.getExpressionList(expressionsTag);
            final List names = (List)this.get(fieldsTag);
            return Commons.typeFactory().createStructType(new AbstractList<Map.Entry<String, RelDataType>>(){

                @Override
                public Map.Entry<String, RelDataType> get(int index) {
                    return Pair.of((Object)((String)names.get(index)), (Object)((RexNode)expressionList.get(index)).getType());
                }

                @Override
                public int size() {
                    return names.size();
                }
            });
        }

        public RelCollation getCollation() {
            return RelJsonReader.this.relJson.toCollation((List)this.get("collation"));
        }

        @Override
        public RelCollation getCollation(String tag) {
            return RelJsonReader.this.relJson.toCollation((List)this.get(tag));
        }

        @Override
        public List<SearchBounds> getSearchBounds(String tag) {
            return RelJsonReader.this.relJson.toSearchBoundList(this, (List)this.get(tag));
        }

        public RelDistribution getDistribution() {
            return RelJsonReader.this.relJson.toDistribution(this.get("distribution"));
        }

        public ImmutableList<ImmutableList<RexLiteral>> getTuples(String tag) {
            List jsonTuples = (List)this.get(tag);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (List jsonTuple : jsonTuples) {
                builder.add(this.getTuple(jsonTuple));
            }
            return builder.build();
        }

        private RelNode lookupInput(String jsonInput) {
            RelNode node = RelJsonReader.this.relMap.get(jsonInput);
            if (node == null) {
                throw new RuntimeException("unknown id " + jsonInput + " for relational expression");
            }
            return node;
        }

        private ImmutableList<RexLiteral> getTuple(List jsonTuple) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object jsonValue : jsonTuple) {
                builder.add((Object)((RexLiteral)RelJsonReader.this.relJson.toRex(this, jsonValue)));
            }
            return builder.build();
        }

        private AggregateCall toAggCall(Map<String, Object> jsonAggCall) {
            Map aggMap = (Map)jsonAggCall.get("agg");
            SqlAggFunction aggregation = Objects.requireNonNull((SqlAggFunction)RelJsonReader.this.relJson.toOp(aggMap), () -> "relJson.toAggregation output for " + aggMap);
            Boolean distinct = (Boolean)jsonAggCall.get("distinct");
            List operands = (List)jsonAggCall.get("operands");
            Integer filterOperand = (Integer)jsonAggCall.get("filter");
            RelDataType type = RelJsonReader.this.relJson.toType((RelDataTypeFactory)Commons.typeFactory(), jsonAggCall.get("type"));
            String name = (String)jsonAggCall.get("name");
            List<RexNode> rexList = Commons.transform((List)jsonAggCall.get("rexList"), node -> RelJsonReader.this.relJson.toRex(this, node));
            return AggregateCall.create((SqlAggFunction)aggregation, (boolean)distinct, (boolean)false, (boolean)false, rexList, (List)operands, (int)(filterOperand == null ? -1 : filterOperand), null, (RelCollation)RelCollations.EMPTY, (RelDataType)type, (String)name);
        }
    }
}

