/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.expressions;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import org.apache.ignite.internal.sql.engine.api.expressions.RowAccessor;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

class ToInternalGenericAdapter<RowT>
implements RowAccessor<RowT> {
    private final RowAccessor<RowT> delegate;

    ToInternalGenericAdapter(RowAccessor<RowT> delegate) {
        this.delegate = delegate;
    }

    @Nullable
    public Object get(int field, RowT row) {
        Object value = this.delegate.get(field, row);
        if (value instanceof byte[]) {
            return TypeUtils.toInternal(value, ColumnType.BYTE_ARRAY);
        }
        if (value instanceof LocalDate) {
            return TypeUtils.toInternal(value, ColumnType.DATE);
        }
        if (value instanceof LocalTime) {
            return TypeUtils.toInternal(value, ColumnType.TIME);
        }
        if (value instanceof LocalDateTime) {
            return TypeUtils.toInternal(value, ColumnType.DATETIME);
        }
        if (value instanceof Instant) {
            return TypeUtils.toInternal(value, ColumnType.TIMESTAMP);
        }
        if (value instanceof Duration) {
            return TypeUtils.toInternal(value, ColumnType.DURATION);
        }
        if (value instanceof Period) {
            return TypeUtils.toInternal(value, ColumnType.PERIOD);
        }
        return value;
    }

    public boolean isNull(int field, RowT row) {
        return this.delegate.isNull(field, row);
    }

    public int columnsCount(RowT row) {
        return this.delegate.columnsCount(row);
    }
}

