/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Flow;
import org.apache.ignite.internal.sql.engine.api.expressions.RowFactory;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.PartitionWithConsistencyToken;
import org.apache.ignite.internal.sql.engine.exec.ScannableTable;
import org.apache.ignite.internal.sql.engine.exec.TxAttributes;
import org.apache.ignite.internal.sql.engine.exec.rel.StorageScanNode;
import org.apache.ignite.internal.storage.operation.StorageOptimizedOperation;
import org.apache.ignite.internal.util.SubscriptionUtils;
import org.apache.ignite.internal.util.TransformingIterator;
import org.jetbrains.annotations.TestOnly;

public class TableScanWithStorageOptimizedOperationNode<RowT>
extends StorageScanNode<RowT> {
    private final ScannableTable scannableTable;
    private final Collection<PartitionWithConsistencyToken> partsWithConsistencyToken;
    private final StorageOptimizedOperation storageOptimizedOperation;
    private final RowFactory<RowT> rowFactory;

    public TableScanWithStorageOptimizedOperationNode(ExecutionContext<RowT> ctx, ScannableTable scannableTable, Collection<PartitionWithConsistencyToken> partsWithConsistencyToken, RowFactory<RowT> rowFactory, StorageOptimizedOperation storageOptimizedOperation) {
        super(ctx, rowFactory, null, null);
        assert (!partsWithConsistencyToken.isEmpty());
        assert (ctx.txAttributes().readOnly()) : "Current node should be executed in RO transaction only";
        this.scannableTable = scannableTable;
        this.rowFactory = rowFactory;
        this.partsWithConsistencyToken = partsWithConsistencyToken;
        this.storageOptimizedOperation = storageOptimizedOperation;
    }

    @TestOnly
    public StorageOptimizedOperation storageOptimizedOperation() {
        return this.storageOptimizedOperation;
    }

    @Override
    protected Flow.Publisher<RowT> scan() {
        TxAttributes tx = this.context().txAttributes();
        assert (tx.readOnly());
        TransformingIterator it = new TransformingIterator(this.partsWithConsistencyToken.iterator(), partWithTerm -> this.scannableTable.executeStorageOperation(this.context(), (PartitionWithConsistencyToken)partWithTerm, this.storageOptimizedOperation, this.rowFactory));
        return SubscriptionUtils.concat((Iterator)it);
    }
}

