/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.internal.lang.InternalTuple;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.sql.engine.api.expressions.RowFactory;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.ScannableDataSource;
import org.apache.ignite.internal.sql.engine.exec.rel.StorageScanNode;
import org.apache.ignite.internal.sql.engine.util.FieldDeserializingProjectedTuple;
import org.apache.ignite.internal.util.subscription.TransformingPublisher;
import org.jetbrains.annotations.Nullable;

public class DataSourceScanNode<RowT>
extends StorageScanNode<RowT> {
    private final ScannableDataSource dataSource;
    private final Function<InternalTuple, RowT> converter;

    /*
     * Enabled aggressive block sorting
     */
    public DataSourceScanNode(ExecutionContext<RowT> ctx, RowFactory<RowT> rowFactory, BinaryTupleSchema schema, ScannableDataSource dataSource, @Nullable Predicate<RowT> filters, @Nullable Function<RowT, RowT> rowTransformer, @Nullable ImmutableIntList requiredColumns) {
        super(ctx, rowFactory, filters, rowTransformer);
        this.dataSource = dataSource;
        if (requiredColumns != null && !DataSourceScanNode.isFullIdentityMapping(requiredColumns, schema)) {
            int[] mapping = requiredColumns.toIntArray();
            this.converter = tuple -> rowFactory.create((InternalTuple)new FieldDeserializingProjectedTuple(schema, (InternalTuple)tuple, mapping));
            return;
        }
        this.converter = arg_0 -> rowFactory.create(arg_0);
    }

    private static boolean isFullIdentityMapping(ImmutableIntList requiredColumns, BinaryTupleSchema schema) {
        if (requiredColumns.size() != schema.elementCount()) {
            return false;
        }
        for (int i = 0; i < requiredColumns.size(); ++i) {
            if (requiredColumns.getInt(i) == schema.columnIndex(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Flow.Publisher<RowT> scan() {
        return new TransformingPublisher(this.dataSource.scan(), this.converter);
    }
}

