/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.internal.sql.engine.api.expressions.RowFactory;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowQueue;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.Node;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRightMaterializedJoinNode<RowT>
extends AbstractNode<RowT> {
    protected boolean inLoop;
    protected int requested;
    int waitingLeft;
    int waitingRight;
    final RowQueue<RowT> leftInBuf;
    @Nullable
    protected RowT left;

    AbstractRightMaterializedJoinNode(RowFactory<RowT> leftRowFactory, ExecutionContext<RowT> ctx) {
        super(ctx);
        this.leftInBuf = ctx.storageFactory().queue((RowHandler<RowT>)ctx.rowAccessor(), leftRowFactory, this.inBufSize);
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 2);
        assert (rowsCnt > 0 && this.requested == 0);
        this.requested = rowsCnt;
        if (!this.inLoop) {
            this.execute(this::join);
        }
    }

    @Override
    protected void rewindInternal() {
        this.releaseNullableRow(this.left);
        this.requested = 0;
        this.waitingLeft = 0;
        this.waitingRight = 0;
        this.left = null;
        this.leftInBuf.clear();
    }

    @Override
    protected void closeInternal() {
        this.releaseNullableRow(this.left);
        IgniteUtils.closeQuiet(() -> this.leftInBuf.close());
        super.closeInternal();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx == 0) {
            return new Downstream<RowT>(){

                @Override
                public void push(RowT row) throws Exception {
                    AbstractRightMaterializedJoinNode.this.pushLeft(row);
                }

                @Override
                public void end() throws Exception {
                    AbstractRightMaterializedJoinNode.this.endLeft();
                }

                @Override
                public void onError(Throwable e) {
                    AbstractRightMaterializedJoinNode.this.onError(e);
                }
            };
        }
        if (idx == 1) {
            return new Downstream<RowT>(){

                @Override
                public void push(RowT row) throws Exception {
                    AbstractRightMaterializedJoinNode.this.pushRight(row);
                }

                @Override
                public void end() throws Exception {
                    AbstractRightMaterializedJoinNode.this.endRight();
                }

                @Override
                public void onError(Throwable e) {
                    AbstractRightMaterializedJoinNode.this.onError(e);
                }
            };
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    protected void dumpDebugInfo0(IgniteStringBuilder buf) {
        buf.app("class=").app(this.getClass().getSimpleName()).app(", requested=").app(this.requested).app(", waitingLeft=").app(this.waitingLeft).app(", waitingRight=").app(this.waitingRight);
    }

    protected void pushLeft(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingLeft > 0);
        --this.waitingLeft;
        this.leftInBuf.add(row);
        this.join();
    }

    private void endLeft() throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingLeft > 0);
        this.waitingLeft = -1;
        this.join();
    }

    private void endRight() throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingRight > 0);
        this.waitingRight = -1;
        this.join();
    }

    Node<RowT> leftSource() {
        return this.sources().get(0);
    }

    Node<RowT> rightSource() {
        return this.sources().get(1);
    }

    protected abstract void join() throws Exception;

    protected abstract void pushRight(RowT var1) throws Exception;
}

