/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.offload;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite.internal.sql.engine.exec.memory.NoOpMemoryContext;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowList;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.offload.OffloadAwareCollection;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
class OffloadAwareListAdapter<RowT>
implements RowList<RowT>,
OffloadAwareCollection {
    private final Supplier<RowList<RowT>> fileCollectionSupplier;
    private MemoryContext<RowT> memoryContext;
    private RowList<RowT> delegate;
    private final Runnable spillingAction;
    private boolean wasSpilled;
    private boolean wasClosed;

    OffloadAwareListAdapter(MemoryContext<RowT> memoryContext, RowList<RowT> delegate, Runnable spillingAction, Supplier<RowList<RowT>> fileCollectionSupplier) {
        this.memoryContext = memoryContext;
        this.delegate = delegate;
        this.spillingAction = spillingAction;
        this.fileCollectionSupplier = fileCollectionSupplier;
    }

    @Override
    @Nullable
    public RowT get(int index) {
        this.checkClosed();
        return this.delegate.get(index);
    }

    @Override
    public RowT removeLast() {
        this.checkClosed();
        return this.delegate.removeLast();
    }

    @Override
    public List<RowT> listView(final UnaryOperator<RowT> transformer) {
        this.checkClosed();
        return new AbstractList<RowT>(){

            @Override
            @Nullable
            public RowT get(int index) {
                return transformer.apply(OffloadAwareListAdapter.this.get(index));
            }

            @Override
            public int size() {
                return OffloadAwareListAdapter.this.size();
            }
        };
    }

    @Override
    public void add(RowT element) {
        this.checkClosed();
        this.acquire(element);
        this.delegate.add(element);
    }

    @Override
    public int size() {
        this.checkClosed();
        return this.delegate.size();
    }

    @Override
    public void clear() {
        this.checkClosed();
        this.release((RowT)this.delegate);
        this.delegate.clear();
    }

    @Override
    public boolean isEmpty() {
        this.checkClosed();
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<RowT> iterator() {
        this.checkClosed();
        return new Iterator<RowT>(){
            private int cursor;

            @Override
            public boolean hasNext() {
                return this.cursor < OffloadAwareListAdapter.this.size();
            }

            @Override
            public RowT next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return OffloadAwareListAdapter.this.get(this.cursor++);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSpillToDisk() {
        if (this.wasSpilled || this.wasClosed) {
            return;
        }
        this.wasSpilled = true;
        RowList<RowT> inMemoryCollection = this.delegate;
        RowList fileCollection = this.fileCollectionSupplier.get();
        this.delegate = fileCollection;
        try {
            for (Object row : inMemoryCollection) {
                fileCollection.add(row);
                this.release(row);
            }
        }
        finally {
            this.memoryContext = NoOpMemoryContext.instance();
            IgniteUtils.closeQuiet(() -> inMemoryCollection.close());
        }
    }

    public void close() throws Exception {
        if (this.wasClosed) {
            return;
        }
        this.wasClosed = true;
        this.release((RowT)this.delegate);
        this.delegate.close();
    }

    private void checkClosed() {
        if (this.wasClosed) {
            throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Row store has been closed.");
        }
    }

    private void acquire(RowT element) {
        if (!this.memoryContext.tryAcquire(element)) {
            this.spillingAction.run();
        }
    }

    private void release(Iterable<RowT> rows) {
        if (this.wasSpilled) {
            return;
        }
        rows.forEach(this::release);
    }

    private void release(RowT row) {
        this.memoryContext.release(row);
    }
}

