/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.file;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.lang.InternalTuple;
import org.apache.ignite.internal.schema.BinaryRowConverter;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.Accumulator;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AccumulatorWrapper;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AccumulatorsState;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.GroupKey;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.GroupState;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.KeyValueCodec;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.AccumulatorsStateCodec;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.type.StructNativeType;
import org.jetbrains.annotations.Nullable;

public class HashAggregateNodeKeyValueCodec
implements KeyValueCodec<GroupKey, GroupState> {
    private final StructNativeType inputSchema;
    private final BinaryTupleSchema.Element[] elements;
    private final int keyNum;
    private final int accNum;
    private final AccumulatorsStateCodec accStateCodec;
    private final Supplier<BinaryTupleBuilder> keyBuilder;
    private final int minEstimatedValueSize;

    public <RowT> HashAggregateNodeKeyValueCodec(StructNativeType inputSchema, int keyNum, List<AccumulatorWrapper<RowT>> accs) {
        this.keyNum = keyNum;
        this.inputSchema = inputSchema;
        this.elements = new BinaryTupleSchema.Element[keyNum];
        for (int i = 0; i < keyNum; ++i) {
            StructNativeType.Field field = (StructNativeType.Field)inputSchema.fields().get(i);
            NativeType nativeType = field.type();
            this.elements[i] = nativeType == null ? null : new BinaryTupleSchema.Element(nativeType, field.nullable());
        }
        IntArrayList keys = new IntArrayList(keyNum);
        IntStream.range(0, keyNum).forEach(arg_0 -> ((IntList)keys).add(arg_0));
        this.keyBuilder = KeyValueCodec.createBinaryTupleBuilder(inputSchema, (IntList)keys);
        ArrayList<Accumulator> accumulators = new ArrayList<Accumulator>(accs.size());
        ArrayList<NativeType> types = new ArrayList<NativeType>(accs.size());
        for (AccumulatorWrapper<RowT> wrapper : accs) {
            accumulators.add(wrapper.accumulator());
            if (wrapper.isGrouping()) {
                types.add(NativeTypes.NULL);
                continue;
            }
            types.addAll(wrapper.getArgumentTypes());
        }
        this.accNum = accs.size();
        this.accStateCodec = new AccumulatorsStateCodec(types, accumulators);
        int stateMinSize = this.accStateCodec.minEstimatedSize();
        this.minEstimatedValueSize = stateMinSize == 0 ? 0 : stateMinSize;
    }

    @Override
    public BinaryTuple encodeKey(GroupKey key) {
        BinaryTupleBuilder builder = this.keyBuilder.get();
        for (int i = 0; i < this.keyNum; ++i) {
            BinaryTupleSchema.Element element = this.elements[i];
            Object internal = key.field(i);
            if (element == null || internal == null) {
                builder.appendNull();
                continue;
            }
            Object val = TypeUtils.fromInternal(internal, element.typeSpec());
            assert (val != null);
            BinaryRowConverter.appendValue((BinaryTupleBuilder)builder, (BinaryTupleSchema.Element)element, (Object)val);
        }
        return new BinaryTuple(this.elements.length, builder.build());
    }

    @Override
    public GroupKey decodeKey(BinaryTuple key) {
        GroupKey.Builder groupKey = GroupKey.builder(this.keyNum);
        for (int i = 0; i < this.keyNum; ++i) {
            NativeType nativeType = ((StructNativeType.Field)this.inputSchema.fields().get(i)).type();
            if (nativeType == NativeTypes.NULL) {
                groupKey.add(null);
                continue;
            }
            Object val = Commons.readValue((InternalTuple)key, nativeType, i);
            Object internal = val == null ? val : TypeUtils.toInternal(val, nativeType.spec());
            groupKey.add(internal);
        }
        return groupKey.build();
    }

    @Override
    @Nullable
    public ByteBuffer encodeValue(GroupState val, ByteBuffer buf) {
        ByteBuffer encodedState = this.accStateCodec.encode(val.state());
        if (buf.remaining() < encodedState.capacity()) {
            buf = ByteBuffer.allocate(encodedState.capacity()).order(buf.order());
        }
        buf.put(encodedState);
        return buf;
    }

    @Override
    public GroupState decodeValue(ByteBuffer buf) {
        AccumulatorsState state = new AccumulatorsState(this.accNum);
        this.accStateCodec.decode(buf, state);
        return new GroupState(state);
    }

    @Override
    public int initialValueSizeInBytes() {
        return this.minEstimatedValueSize;
    }
}

