/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.fsm;

import java.time.Instant;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.QueryCancel;
import org.apache.ignite.internal.sql.engine.SqlOperationContext;
import org.apache.ignite.internal.sql.engine.SqlProperties;
import org.apache.ignite.internal.sql.engine.exec.fsm.ExecutionPhase;
import org.apache.ignite.internal.sql.engine.exec.fsm.Program;
import org.apache.ignite.internal.sql.engine.exec.fsm.ProgramExecutionHandle;
import org.apache.ignite.internal.sql.engine.exec.fsm.ProgramExecutionState;
import org.apache.ignite.internal.sql.engine.exec.fsm.QueryExecutor;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite.internal.sql.engine.sql.ParsedResult;
import org.apache.ignite.internal.sql.engine.tx.QueryTransactionContext;
import org.apache.ignite.internal.sql.engine.tx.QueryTransactionWrapper;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;

class Query {
    private static final IgniteLogger LOG = Loggers.forClass(Query.class);
    private static final int MAX_ATTEMPTS_COUNT = 1024;
    final CompletableFuture<Void> terminationFuture = new CompletableFuture();
    final AtomicReference<@Nullable ProgramExecutionHandle> activeProgram = new AtomicReference();
    final SecurityContext securityContext;
    final Instant createdAt;
    @Nullable
    final UUID parentId;
    final int statementNum;
    final UUID id;
    final String sql;
    final Object[] params;
    final QueryCancel cancel = new QueryCancel();
    final QueryExecutor executor;
    final SqlProperties properties;
    final QueryTransactionContext txContext;
    final AtomicReference<Throwable> error = new AtomicReference();
    @Nullable
    final CompletableFuture<AsyncSqlCursor<InternalSqlRow>> nextCursorFuture;
    @Nullable
    volatile ParsedResult parsedResult = null;
    @Nullable
    volatile SqlOperationContext operationContext = null;
    @Nullable
    volatile QueryPlan plan = null;
    @Nullable
    volatile QueryTransactionWrapper usedTransaction = null;
    @Nullable
    volatile AsyncSqlCursor<InternalSqlRow> cursor = null;
    @Nullable
    volatile List<ParsedResult> parsedScript = null;
    private volatile ExecutionPhase currentPhase = ExecutionPhase.REGISTERED;

    Query(SecurityContext securityContext, Instant createdAt, QueryExecutor executor, UUID id, String sql, SqlProperties properties, QueryTransactionContext txContext, Object[] params) {
        this.securityContext = securityContext;
        this.createdAt = createdAt;
        this.executor = executor;
        this.id = id;
        this.sql = sql;
        this.properties = properties;
        this.txContext = txContext;
        this.params = params;
        this.parentId = null;
        this.statementNum = -1;
        this.nextCursorFuture = null;
    }

    Query(Instant createdAt, Query parent, ParsedResult parsedResult, int statementNum, UUID id, QueryTransactionContext txContext, Object[] params, @Nullable CompletableFuture<AsyncSqlCursor<InternalSqlRow>> nextCursorFuture) {
        this.securityContext = parent.securityContext;
        this.createdAt = createdAt;
        this.executor = parent.executor;
        this.parentId = parent.id;
        this.statementNum = statementNum;
        this.id = id;
        this.sql = parsedResult.originalQuery();
        this.properties = parent.properties;
        this.txContext = txContext;
        this.params = params;
        this.nextCursorFuture = nextCursorFuture;
        this.parsedResult = parsedResult;
    }

    <ResultT> CompletableFuture<ResultT> runProgram(Program<ResultT> program) {
        ProgramExecutionState<ResultT> state = program.createState();
        ProgramExecutionHandle currentProgram = this.activeProgram.compareAndExchange(null, state);
        if (currentProgram != null) {
            String message = IgniteStringFormatter.format((String)"Attempt to run query program while another is still active [runningProgram={}, newProgram={}].", (Object[])new Object[]{currentProgram, program});
            throw new SqlException(ErrorGroups.Common.INTERNAL_ERR, message);
        }
        program.run(this, state);
        return state.resultHolder;
    }

    void terminate() {
        this.tryTerminate(1);
    }

    private void tryTerminate(int attemptNo) {
        if (attemptNo >= 1024) {
            LOG.warn("Unable to terminate query after several attempts. Try to cancel it explicitly using KILL statement,or restart the node as some resources mays still be held by this query [queryId={}, attempts={}].", new Object[]{this.id, attemptNo});
            return;
        }
        if (this.currentPhase == ExecutionPhase.TERMINATED) {
            return;
        }
        if (this.tryRunTerminationProgram()) {
            return;
        }
        ProgramExecutionHandle handle = this.activeProgram.get();
        if (handle != null) {
            handle.completionFuture().whenComplete((r, e) -> this.tryTerminate(attemptNo + 1));
            return;
        }
        this.tryTerminate(attemptNo + 1);
    }

    void moveTo(ExecutionPhase newPhase) {
        this.currentPhase = newPhase;
        if (newPhase == ExecutionPhase.TERMINATED) {
            this.terminationFuture.complete(null);
        }
    }

    ExecutionPhase currentPhase() {
        return this.currentPhase;
    }

    void terminateExceptionally(Throwable th) {
        this.setError(th);
        ProgramExecutionHandle handle = this.activeProgram.get();
        if (handle != null) {
            handle.notifyError(th);
        }
        this.terminate();
    }

    private boolean tryRunTerminationProgram() {
        ProgramExecutionState state = new ProgramExecutionState("QUERY_TERMINATION");
        if (this.activeProgram.compareAndSet(null, state)) {
            this.moveTo(ExecutionPhase.TERMINATED);
            this.activeProgram.set(null);
            return true;
        }
        return false;
    }

    void setError(Throwable err) {
        Throwable prevErr = this.error.compareAndExchange(null, err);
        if (prevErr != null && prevErr != err) {
            this.error.get().addSuppressed(err);
        }
    }

    CompletableFuture<Void> cancel() {
        this.cancel.cancel();
        return this.terminationFuture;
    }

    void reset() {
        this.error.set(null);
    }
}

