/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp.func;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.ignite.internal.sql.engine.api.expressions.RowFactory;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.exp.func.TableFunction;
import org.apache.ignite.internal.sql.engine.exec.exp.func.TableFunctionInstance;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.type.StructNativeType;
import org.jetbrains.annotations.Nullable;

public final class SystemRangeTableFunction<RowT>
implements TableFunction<RowT> {
    private final StructNativeType rowSchema = NativeTypes.structBuilder().addField("X", NativeTypes.INT64, false).build();
    private final Supplier<Long> startExpr;
    private final Supplier<Long> endExpr;
    private final Supplier<Long> incrementExpr;

    public SystemRangeTableFunction(Supplier<Long> startExpr, Supplier<Long> endExpr, @Nullable Supplier<Long> incrementExpr) {
        this.startExpr = Objects.requireNonNull(startExpr, "startExpr");
        this.endExpr = Objects.requireNonNull(endExpr, "endExpr");
        this.incrementExpr = incrementExpr != null ? incrementExpr : () -> 1L;
    }

    @Override
    public TableFunctionInstance<RowT> createInstance(ExecutionContext<RowT> ctx) {
        RowFactory factory = ctx.rowFactoryFactory().create(this.rowSchema);
        Long start = this.startExpr.get();
        Long end = this.endExpr.get();
        Long increment = this.incrementExpr.get();
        if (increment == null) {
            increment = 1L;
        } else if (increment == 0L) {
            throw new IllegalArgumentException("Increment can't be 0");
        }
        if (start == null || end == null) {
            return TableFunctionInstance.empty();
        }
        return new SystemRangeInstance(factory, start, end, increment);
    }

    private static class SystemRangeInstance<RowT>
    implements TableFunctionInstance<RowT> {
        private final long end;
        private final long increment;
        private long current;
        private final RowFactory<RowT> factory;

        SystemRangeInstance(RowFactory<RowT> factory, long start, long end, long increment) {
            this.factory = factory;
            this.end = end;
            this.increment = increment;
            this.current = start;
        }

        @Override
        public boolean hasNext() {
            return this.increment > 0L ? this.current <= this.end : this.current >= this.end;
        }

        @Override
        public RowT next() {
            if (this.increment > 0L && this.current > this.end) {
                throw new NoSuchElementException();
            }
            if (this.increment < 0L && this.current < this.end) {
                throw new NoSuchElementException();
            }
            Object row = this.factory.create(new Object[]{this.current});
            this.current += this.increment;
            return (RowT)row;
        }

        @Override
        public void close() {
        }
    }
}

