/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp.agg;

import java.util.List;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AccumulatorWrapper;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AccumulatorsState;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.GroupKey;
import org.apache.ignite.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowSet;

public class AggregateRow<RowT> {
    public static final byte NO_GROUP_ID = -1;
    private final AggregateType type;
    private final List<AccumulatorWrapper<RowT>> accs;
    private final byte groupId;
    private final ImmutableBitSet allFields;

    public AggregateRow(byte groupId, ImmutableBitSet allFields, AggregateType type, List<AccumulatorWrapper<RowT>> accs) {
        this.groupId = groupId;
        this.allFields = allFields;
        this.type = type;
        this.accs = accs;
    }

    public static boolean addEmptyGroup(ImmutableBitSet groupKeys, AggregateType type) {
        return groupKeys.isEmpty() && (type == AggregateType.REDUCE || type == AggregateType.SINGLE);
    }

    public static <RowT> boolean groupMatches(RowHandler<RowT> handler, RowT row, AggregateType type, byte groupId) {
        if (type == AggregateType.REDUCE) {
            int columnCount = handler.columnsCount(row);
            byte targetGroupId = (Byte)handler.get(columnCount - 1, row);
            return targetGroupId == groupId;
        }
        return groupId != -1;
    }

    public List<AccumulatorWrapper<RowT>> getAccumulators() {
        return this.accs;
    }

    public void update(AccumulatorsState state, ImmutableBitSet grpFields, RowHandler<RowT> handler, RowT row, List<RowSet<Object>> distinctSets, MemoryContext<RowT> memoryContext) {
        for (int i = 0; i < this.accs.size(); ++i) {
            AccumulatorWrapper<RowT> acc = this.accs.get(i);
            RowSet<Object> distinctSet = distinctSets.get(i);
            Object[] args = acc.getArguments(row);
            if (args == null || distinctSet != null && (args[0] == null || !distinctSet.add(args[0]))) continue;
            state.setIndex(i);
            acc.accumulator().add(state, args);
            state.resetIndex();
        }
    }

    public Object[] createOutput() {
        int extra = this.groupId == -1 || this.type != AggregateType.MAP ? 0 : 1;
        int rowSize = this.allFields.cardinality() + this.accs.size() + extra;
        return new Object[rowSize];
    }

    public void writeTo(AccumulatorsState state, ImmutableBitSet grpFields, Object[] output) {
        int cardinality = this.allFields.cardinality();
        AccumulatorsState result = new AccumulatorsState(this.accs.size());
        for (int i = 0; i < this.accs.size(); ++i) {
            AccumulatorWrapper<RowT> acc = this.accs.get(i);
            state.setIndex(i);
            result.setIndex(i);
            if (acc.isGrouping()) {
                state.set(grpFields);
            }
            acc.accumulator().end(state, result);
            output[i + cardinality] = acc.convertResult(result.get());
            state.resetIndex();
            result.resetIndex();
        }
        if (this.groupId != -1 && this.type == AggregateType.MAP) {
            output[output.length - 1] = this.groupId;
        }
    }

    public void updateSingleDistinctSet(byte groupId, GroupKey groupKey, AccumulatorsState state, ImmutableBitSet grpFields, RowHandler<RowT> handler, RowT row, RowSet<GroupKey> distinctSet, MemoryContext<RowT> memoryContext) {
        for (int i = 0; i < this.accs.size(); ++i) {
            AccumulatorWrapper<RowT> acc = this.accs.get(i);
            Object[] args = acc.getArguments(row);
            if (args == null) continue;
            if (acc.isDistinct()) {
                GroupKey distinctKey;
                assert (!acc.isGrouping());
                if (args[0] == null || !distinctSet.add(distinctKey = AggregateRow.newDistinctKey(groupKey, i, args[0]))) continue;
            }
            state.setIndex(i);
            if (acc.isGrouping()) {
                state.set(grpFields);
            } else {
                acc.accumulator().add(state, args);
            }
            state.resetIndex();
        }
    }

    public static GroupKey newDistinctKey(GroupKey key, int accIndex, Object argument) {
        GroupKey.Builder distinctKey = GroupKey.builder(2 + key.fieldsCount());
        distinctKey.add(accIndex);
        distinctKey.add(argument);
        for (int i = 0; i < key.fieldsCount(); ++i) {
            distinctKey.add(key.field(i));
        }
        return distinctKey.build();
    }
}

