/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.ignite.internal.sql.engine.exec.SqlEvaluationContext;
import org.apache.ignite.internal.sql.engine.exec.exp.CodegenUtils;
import org.apache.ignite.internal.sql.engine.exec.exp.CorrelatesBuilder;
import org.apache.ignite.internal.sql.engine.exec.exp.FieldGetter;
import org.apache.ignite.internal.sql.engine.exec.exp.RexToLixTranslator;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlExpressionFactoryImpl;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlPredicate;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.IgniteMethod;
import org.apache.ignite.internal.sql.engine.util.cache.Cache;

class PredicateImplementor {
    private final Cache<String, Object> cache;
    private final RexBuilder rexBuilder;
    private final JavaTypeFactory typeFactory;
    private final SqlConformance conformance;

    PredicateImplementor(Cache<String, Object> cache, RexBuilder rexBuilder, JavaTypeFactory typeFactory, SqlConformance conformance) {
        this.cache = cache;
        this.rexBuilder = rexBuilder;
        this.typeFactory = typeFactory;
        this.conformance = conformance;
    }

    SqlPredicate implement(RexNode predicateExpression, RelDataType type) {
        String digest = SqlExpressionFactoryImpl.digest(SqlPredicate.class, List.of(predicateExpression), type);
        Cache cache = (Cache)Commons.cast(this.cache);
        return cache.get(digest, ignored -> this.implementInternal(predicateExpression, type));
    }

    private SqlPredicate implementInternal(RexNode predicateExpression, RelDataType type) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(type, this.rexBuilder);
        programBuilder.addCondition(predicateExpression);
        RexProgram program = programBuilder.getProgram();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression ctx = Expressions.parameter(SqlEvaluationContext.class, (String)"ctx");
        ParameterExpression row = Expressions.parameter(Object.class, (String)"row");
        builder.add((Statement)Expressions.declare((int)16, (ParameterExpression)DataContext.ROOT, (Expression)Expressions.convert_((Expression)ctx, DataContext.class)));
        Expression rowHandler = builder.append("hnd", (Expression)Expressions.call((Expression)ctx, (Method)IgniteMethod.CONTEXT_ROW_HANDLER.method(), (Expression[])new Expression[0]));
        FieldGetter inputGetter = new FieldGetter(rowHandler, (Expression)row, type);
        Function1<String, RexToLixTranslator.InputGetter> correlates = new CorrelatesBuilder(builder, (Expression)ctx, rowHandler).build(List.of(predicateExpression));
        Expression condition = RexToLixTranslator.translateCondition(program, this.typeFactory, builder, inputGetter, correlates, this.conformance, (Expression)ctx);
        builder.add(condition);
        BlockStatement methodBody = CodegenUtils.wrapWithConversionToEvaluationException((Statement)builder.toBlock());
        List<ParameterExpression> params = List.of(ctx, row);
        MethodDeclaration declaration = Expressions.methodDecl((int)1, Boolean.TYPE, (String)"test", params, (BlockStatement)methodBody);
        Class clazz = (Class)Commons.cast(SqlPredicate.class);
        String body = Expressions.toString(List.of(declaration), (String)"\n", (boolean)false);
        return (SqlPredicate)Commons.compile(clazz, body);
    }
}

