/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.sql.engine.exec.AbstractIndexScan;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RuntimeIndex;
import org.apache.ignite.internal.sql.engine.exec.TreeIndex;
import org.apache.ignite.internal.sql.engine.exec.exp.RangeIterable;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public class RuntimeSortedIndex<RowT>
implements RuntimeIndex<RowT>,
TreeIndex<RowT> {
    protected final ExecutionContext<RowT> ectx;
    protected final Comparator<RowT> comp;
    private final RelCollation collation;
    private final ArrayList<RowT> rows = new ArrayList();

    public RuntimeSortedIndex(ExecutionContext<RowT> ectx, RelCollation collation, Comparator<RowT> comp) {
        this.ectx = ectx;
        this.comp = comp;
        assert (Objects.nonNull(collation));
        this.collation = collation;
    }

    @Override
    public void push(RowT r) {
        assert (this.rows.isEmpty() || this.comp.compare(r, this.rows.get(this.rows.size() - 1)) >= 0) : "Not sorted input";
        this.rows.add(r);
    }

    @Override
    public void close() {
        this.rows.clear();
    }

    @Override
    public Cursor<RowT> find(RowT lower, RowT upper, boolean lowerInclude, boolean upperInclude) {
        int firstCol = (Integer)CollectionUtils.first((List)this.collation.getKeys());
        Object lowerBound = lower == null ? null : this.ectx.rowAccessor().get(firstCol, lower);
        Object upperBound = upper == null ? null : this.ectx.rowAccessor().get(firstCol, upper);
        Object lowerRow = lowerBound == null ? null : (Object)lower;
        Object upperRow = upperBound == null ? null : (Object)upper;
        return new CursorImpl(this.rows, lowerRow, upperRow, lowerInclude, upperInclude);
    }

    public Iterable<RowT> scan(ExecutionContext<RowT> ectx, RelDataType rowType, Predicate<RowT> filter, RangeIterable<RowT> ranges) {
        return new IndexScan(rowType, this, filter, ranges);
    }

    private class CursorImpl
    implements Cursor<RowT> {
        private final List<RowT> rows;
        private final RowT upper;
        private final boolean includeUpper;
        private int idx;

        CursorImpl(@Nullable List<RowT> rows, @Nullable RowT lower, RowT upper, boolean lowerInclude, boolean upperInclude) {
            this.rows = rows;
            this.upper = upper;
            this.includeUpper = upperInclude;
            this.idx = lower == null ? 0 : this.lowerBound(rows, lower, lowerInclude);
        }

        private int lowerBound(List<RowT> rows, RowT bound, boolean includeBound) {
            int low = 0;
            int high = rows.size() - 1;
            int idx = -1;
            while (low <= high) {
                int mid = (high - low) / 2 + low;
                int compRes = RuntimeSortedIndex.this.comp.compare(rows.get(mid), bound);
                if (compRes > 0) {
                    high = mid - 1;
                    continue;
                }
                if (compRes == 0 && includeBound) {
                    idx = mid;
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
            return idx == -1 ? low : idx;
        }

        public boolean hasNext() {
            return this.idx != this.rows.size() && (this.upper == null || RuntimeSortedIndex.this.comp.compare(this.upper, this.rows.get(this.idx)) >= (this.includeUpper ? 0 : 1));
        }

        public RowT next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.rows.get(this.idx++);
        }

        public void close() {
        }
    }

    private class IndexScan
    extends AbstractIndexScan<RowT, RowT> {
        IndexScan(RelDataType rowType, TreeIndex<RowT> idx, Predicate<RowT> filter, RangeIterable<RowT> ranges) {
            super(RuntimeSortedIndex.this.ectx, rowType, idx, filter, ranges, null);
        }

        @Override
        protected RowT row2indexRow(RowT bound) {
            return bound;
        }

        @Override
        protected RowT indexRow2Row(RowT row) {
            return row;
        }
    }
}

