/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.metrics;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.internal.metrics.IntGauge;
import org.apache.ignite.internal.metrics.LongGauge;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.sql.metrics.SqlOffloadingMetricsProvider;

public class SqlOffloadingMetricSource
extends AbstractMetricSource<Holder> {
    public static final String NAME = "sql.offloading";
    public static final String METRIC_DATA_LIMIT = "DataLimit";
    public static final String METRIC_DISK_USAGE = "DiskUsage";
    public static final String METRIC_MAX_DISK_USAGE = "MaxDiskUsage";
    public static final String METRIC_OPEN_FILES_COUNT = "OpenedFilesCount";
    public static final String METRIC_OFFLOADED_QUERIES = "OffloadedActiveQueries";
    public static final String METRIC_TOTAL_OFFLOADED_QUERIES = "TotalOffloadedQueries";
    public static final String METRIC_BYTES_READ = "TotalBytesRead";
    public static final String METRIC_BYTES_WRITTEN = "TotalBytesWritten";
    public static final String METRIC_WRITE_OPERATIONS = "TotalWriteOperationsCount";
    public static final String METRIC_READ_OPERATIONS = "TotalReadOperationsCount";
    private final LongSupplier offloadingDataLimitSupplier;
    private final AtomicReference<? extends SqlOffloadingMetricsProvider> offloadingMetricsProvider;

    public SqlOffloadingMetricSource(LongSupplier offloadingDataLimitSupplier, AtomicReference<? extends SqlOffloadingMetricsProvider> offloadingMetricsProvider) {
        super(NAME);
        this.offloadingDataLimitSupplier = offloadingDataLimitSupplier;
        this.offloadingMetricsProvider = offloadingMetricsProvider;
    }

    protected Holder createHolder() {
        return new Holder();
    }

    protected class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final LongGauge dataLimit;
        private final LongGauge diskUsage;
        private final LongGauge maxDiskUsage;
        private final IntGauge openedFilesCount;
        private final IntGauge offloadedQueriesCount;
        private final LongGauge totalOffloadedQueriesCount;
        private final LongGauge totalBytesRead;
        private final LongGauge totalBytesWritten;
        private final LongGauge totalReadOperations;
        private final LongGauge totalWriteOperations;

        protected Holder() {
            this.dataLimit = new LongGauge(SqlOffloadingMetricSource.METRIC_DATA_LIMIT, "SQL offloading data limit in bytes.", SqlOffloadingMetricSource.this.offloadingDataLimitSupplier);
            this.diskUsage = new LongGauge(SqlOffloadingMetricSource.METRIC_DISK_USAGE, "The amount of space currently used by the offloading in bytes.", () -> SqlOffloadingMetricSource.this.offloadingMetricsProvider.get().offloaded());
            this.maxDiskUsage = new LongGauge(SqlOffloadingMetricSource.METRIC_MAX_DISK_USAGE, "The maximum amount of space used by the offloading in bytes.", () -> SqlOffloadingMetricSource.this.offloadingMetricsProvider.get().maxOffloaded());
            this.openedFilesCount = new IntGauge(SqlOffloadingMetricSource.METRIC_OPEN_FILES_COUNT, "The number of open files used for offloading.", () -> SqlOffloadingMetricSource.this.offloadingMetricsProvider.get().openFiles());
            this.offloadedQueriesCount = new IntGauge(SqlOffloadingMetricSource.METRIC_OFFLOADED_QUERIES, "The number of active queries that have been spilled to disk.", () -> SqlOffloadingMetricSource.this.offloadingMetricsProvider.get().offloadedActiveQueries());
            this.totalOffloadedQueriesCount = new LongGauge(SqlOffloadingMetricSource.METRIC_TOTAL_OFFLOADED_QUERIES, "The total number of queries that have been spilled to disk.", () -> SqlOffloadingMetricSource.this.offloadingMetricsProvider.get().offloadedQueries());
            this.totalBytesRead = new LongGauge(SqlOffloadingMetricSource.METRIC_BYTES_READ, "The total number of bytes read from disk by the offloading.", () -> SqlOffloadingMetricSource.this.offloadingMetricsProvider.get().bytesRead());
            this.totalBytesWritten = new LongGauge(SqlOffloadingMetricSource.METRIC_BYTES_WRITTEN, "The total number of bytes written to disk by the offloading.", () -> SqlOffloadingMetricSource.this.offloadingMetricsProvider.get().bytesWritten());
            this.totalReadOperations = new LongGauge(SqlOffloadingMetricSource.METRIC_READ_OPERATIONS, "The total number of read operations performed by the offloading.", () -> SqlOffloadingMetricSource.this.offloadingMetricsProvider.get().reads());
            this.totalWriteOperations = new LongGauge(SqlOffloadingMetricSource.METRIC_WRITE_OPERATIONS, "The total number of write operations performed by the offloading.", () -> SqlOffloadingMetricSource.this.offloadingMetricsProvider.get().writes());
        }

        public Iterable<Metric> metrics() {
            return List.of(this.dataLimit, this.diskUsage, this.maxDiskUsage, this.openedFilesCount, this.offloadedQueriesCount, this.totalOffloadedQueriesCount, this.totalBytesRead, this.totalBytesWritten, this.totalReadOperations, this.totalWriteOperations);
        }
    }
}

