/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.ignite.internal.sql.engine.SchemaAwareConverter;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.prepare.ParameterType;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.IgniteMath;
import org.apache.ignite.internal.type.DecimalNativeType;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.type.StructNativeType;
import org.apache.ignite.internal.type.TemporalNativeType;
import org.apache.ignite.internal.type.VarlenNativeType;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public class TypeUtils {
    public static final SchemaAwareConverter<Object, Object> IDENTITY_ROW_CONVERTER = (idx, r) -> r;
    private static final Set<SqlTypeName> CONVERTABLE_TYPES = EnumSet.of(SqlTypeName.DATE, new SqlTypeName[]{SqlTypeName.TIME, SqlTypeName.BINARY, SqlTypeName.VARBINARY, SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE, SqlTypeName.TIMESTAMP, SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, SqlTypeName.INTERVAL_SECOND, SqlTypeName.INTERVAL_MINUTE, SqlTypeName.INTERVAL_MINUTE_SECOND, SqlTypeName.INTERVAL_HOUR, SqlTypeName.INTERVAL_HOUR_MINUTE, SqlTypeName.INTERVAL_HOUR_SECOND, SqlTypeName.INTERVAL_DAY, SqlTypeName.INTERVAL_DAY_HOUR, SqlTypeName.INTERVAL_DAY_MINUTE, SqlTypeName.INTERVAL_DAY_SECOND, SqlTypeName.INTERVAL_MONTH, SqlTypeName.INTERVAL_YEAR, SqlTypeName.INTERVAL_YEAR_MONTH});

    @Nullable
    public static BigDecimal upperBoundFor(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case TINYINT: {
                return BigDecimal.valueOf(127L);
            }
            case SMALLINT: {
                return BigDecimal.valueOf(32767L);
            }
            case INTEGER: {
                return BigDecimal.valueOf(Integer.MAX_VALUE);
            }
            case BIGINT: {
                return BigDecimal.valueOf(Long.MAX_VALUE);
            }
            case REAL: {
                return BigDecimal.valueOf(3.4028234663852886E38);
            }
            case DOUBLE: {
                return BigDecimal.valueOf(Double.MAX_VALUE);
            }
            case DECIMAL: {
                return (BigDecimal)type.getSqlTypeName().getLimit(true, SqlTypeName.Limit.OVERFLOW, false, type.getPrecision(), type.getScale());
            }
        }
        return null;
    }

    @Nullable
    public static BigDecimal lowerBoundFor(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case TINYINT: {
                return BigDecimal.valueOf(-128L);
            }
            case SMALLINT: {
                return BigDecimal.valueOf(-32768L);
            }
            case INTEGER: {
                return BigDecimal.valueOf(Integer.MIN_VALUE);
            }
            case BIGINT: {
                return BigDecimal.valueOf(Long.MIN_VALUE);
            }
            case REAL: {
                return BigDecimal.valueOf(-3.4028234663852886E38);
            }
            case DOUBLE: {
                return BigDecimal.valueOf(-1.7976931348623157E308);
            }
            case DECIMAL: {
                return (BigDecimal)type.getSqlTypeName().getLimit(false, SqlTypeName.Limit.OVERFLOW, false, type.getPrecision(), type.getScale());
            }
        }
        return null;
    }

    public static ParameterType fromRelDataType(RelDataType type) {
        ColumnType columnType = TypeUtils.columnType(type);
        assert (columnType != null) : "No column type for " + type;
        int precision = columnType.lengthAllowed() || columnType.precisionAllowed() ? type.getPrecision() : -1;
        int scale = columnType.scaleAllowed() ? type.getScale() : Integer.MIN_VALUE;
        return new ParameterType(columnType, precision, scale, type.isNullable());
    }

    private static Set<Class<?>> supportedParamClasses() {
        return SupportedParamClassesHolder.SUPPORTED_PARAM_CLASSES;
    }

    public static boolean supportParamInstance(@Nullable Object param) {
        return param == null || TypeUtils.supportedParamClasses().contains(param.getClass());
    }

    public static RelDataType combinedRowType(IgniteTypeFactory typeFactory, RelDataType ... types) {
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder((RelDataTypeFactory)typeFactory);
        HashSet<String> names = new HashSet<String>();
        for (RelDataType type : types) {
            for (RelDataTypeField field : type.getFieldList()) {
                int idx = 0;
                Object fieldName = field.getName();
                while (!names.add((String)fieldName)) {
                    fieldName = field.getName() + idx++;
                }
                builder.add((String)fieldName, field.getType());
            }
        }
        return builder.build();
    }

    public static RelDataType createRowType(IgniteTypeFactory typeFactory, List<RelDataType> fields) {
        return TypeUtils.createRowType(typeFactory, fields, "$F");
    }

    private static RelDataType createRowType(IgniteTypeFactory typeFactory, List<RelDataType> fields, String namePreffix) {
        List names = IntStream.range(0, fields.size()).mapToObj(ord -> namePreffix + ord).collect(Collectors.toList());
        return typeFactory.createStructType(fields, names);
    }

    public static SchemaAwareConverter<Object, Object> resultTypeConverter(RelDataType resultType) {
        assert (resultType.isStruct());
        if (TypeUtils.hasConvertableFields(resultType)) {
            List types = RelOptUtil.getFieldTypeList((RelDataType)resultType);
            Function[] converters = new Function[types.size()];
            for (int i = 0; i < types.size(); ++i) {
                converters[i] = TypeUtils.fieldConverter((RelDataType)types.get(i));
            }
            return (idx, r) -> {
                assert (idx >= 0 && idx < converters.length);
                return converters[idx].apply(r);
            };
        }
        return IDENTITY_ROW_CONVERTER;
    }

    private static Function<@Nullable Object, @Nullable Object> fieldConverter(RelDataType fieldType) {
        if (TypeUtils.isConvertableType(fieldType)) {
            ColumnType storageType = TypeUtils.columnType(fieldType);
            return v -> v == null ? null : TypeUtils.fromInternal(v, storageType);
        }
        return Function.identity();
    }

    public static boolean isConvertableType(RelDataType type) {
        return CONVERTABLE_TYPES.contains(type.getSqlTypeName());
    }

    private static boolean hasConvertableFields(RelDataType resultType) {
        for (RelDataTypeField field : resultType.getFieldList()) {
            if (!TypeUtils.isConvertableType(field.getType())) continue;
            return true;
        }
        return false;
    }

    public static Object toInternal(Object val, ColumnType spec) {
        switch (spec) {
            case INT8: {
                assert (val instanceof Byte) : val.getClass();
                return val;
            }
            case INT16: {
                assert (val instanceof Short) : val.getClass();
                return val;
            }
            case INT32: {
                assert (val instanceof Integer) : val.getClass();
                return val;
            }
            case INT64: {
                assert (val instanceof Long) : val.getClass();
                return val;
            }
            case FLOAT: {
                assert (val instanceof Float) : val.getClass();
                return val;
            }
            case DOUBLE: {
                assert (val instanceof Double) : val.getClass();
                return val;
            }
            case DECIMAL: {
                assert (val instanceof BigDecimal) : val.getClass();
                return val;
            }
            case UUID: {
                assert (val instanceof UUID) : val.getClass();
                return val;
            }
            case STRING: {
                assert (val instanceof String) : val.getClass();
                return val;
            }
            case BYTE_ARRAY: {
                if (val instanceof String) {
                    return new ByteString(((String)val).getBytes(StandardCharsets.UTF_8));
                }
                if (val instanceof byte[]) {
                    return new ByteString((byte[])val);
                }
                assert (val instanceof ByteString) : val.getClass();
                return val;
            }
            case DATE: {
                assert (val instanceof LocalDate) : val.getClass();
                return (int)((LocalDate)val).toEpochDay();
            }
            case TIME: {
                assert (val instanceof LocalTime) : val.getClass();
                return (int)TimeUnit.NANOSECONDS.toMillis(((LocalTime)val).toNanoOfDay());
            }
            case DATETIME: {
                assert (val instanceof LocalDateTime) : val.getClass();
                LocalDateTime dt = (LocalDateTime)val;
                return TimeUnit.SECONDS.toMillis(dt.toEpochSecond(ZoneOffset.UTC)) + TimeUnit.NANOSECONDS.toMillis(dt.getNano());
            }
            case TIMESTAMP: {
                assert (val instanceof Instant) : val.getClass();
                return ((Instant)val).toEpochMilli();
            }
            case BOOLEAN: {
                assert (val instanceof Boolean) : val.getClass();
                return val;
            }
            case DURATION: {
                return ((Duration)val).toMillis();
            }
            case PERIOD: {
                return IgniteMath.convertToIntExact(((Period)val).toTotalMonths());
            }
        }
        throw new AssertionError((Object)("Type is not supported: " + spec));
    }

    public static Object fromInternal(Object val, ColumnType spec) {
        switch (spec) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case UUID: 
            case STRING: 
            case BOOLEAN: {
                return val;
            }
            case BYTE_ARRAY: {
                return ((ByteString)val).getBytes();
            }
            case DATE: {
                return LocalDate.ofEpochDay(((Integer)val).intValue());
            }
            case TIME: {
                return LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(((Integer)val).intValue()));
            }
            case DATETIME: {
                return LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)val), ZoneOffset.UTC);
            }
            case TIMESTAMP: {
                return Instant.ofEpochMilli((Long)val);
            }
            case DURATION: {
                assert (val instanceof Long);
                return Duration.ofMillis((Long)val);
            }
            case PERIOD: {
                assert (val instanceof Integer);
                return Period.of((Integer)val / 12, (Integer)val % 12, 0);
            }
        }
        throw new AssertionError((Object)("Type is not supported: " + spec));
    }

    public static ColumnType columnType(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case VARCHAR: 
            case CHAR: {
                return ColumnType.STRING;
            }
            case DATE: {
                return ColumnType.DATE;
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return ColumnType.TIME;
            }
            case INTEGER: {
                return ColumnType.INT32;
            }
            case TIMESTAMP: {
                return ColumnType.DATETIME;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return ColumnType.TIMESTAMP;
            }
            case BIGINT: {
                return ColumnType.INT64;
            }
            case SMALLINT: {
                return ColumnType.INT16;
            }
            case TINYINT: {
                return ColumnType.INT8;
            }
            case BOOLEAN: {
                return ColumnType.BOOLEAN;
            }
            case DECIMAL: {
                return ColumnType.DECIMAL;
            }
            case DOUBLE: {
                return ColumnType.DOUBLE;
            }
            case REAL: 
            case FLOAT: {
                return ColumnType.FLOAT;
            }
            case BINARY: 
            case VARBINARY: {
                return ColumnType.BYTE_ARRAY;
            }
            case ANY: 
            case OTHER: {
                return ColumnType.BYTE_ARRAY;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                return ColumnType.PERIOD;
            }
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: 
            case INTERVAL_DAY: {
                return ColumnType.DURATION;
            }
            case NULL: {
                return ColumnType.NULL;
            }
            case UUID: {
                return ColumnType.UUID;
            }
        }
        throw new IllegalArgumentException("Unexpected type: " + type.getSqlTypeName());
    }

    public static RelDataType native2relationalType(RelDataTypeFactory factory, NativeType nativeType) {
        switch (nativeType.spec()) {
            case NULL: {
                return factory.createSqlType(SqlTypeName.NULL);
            }
            case BOOLEAN: {
                return factory.createSqlType(SqlTypeName.BOOLEAN);
            }
            case INT8: {
                return factory.createSqlType(SqlTypeName.TINYINT);
            }
            case INT16: {
                return factory.createSqlType(SqlTypeName.SMALLINT);
            }
            case INT32: {
                return factory.createSqlType(SqlTypeName.INTEGER);
            }
            case INT64: {
                return factory.createSqlType(SqlTypeName.BIGINT);
            }
            case FLOAT: {
                return factory.createSqlType(SqlTypeName.REAL);
            }
            case DOUBLE: {
                return factory.createSqlType(SqlTypeName.DOUBLE);
            }
            case DECIMAL: {
                assert (nativeType instanceof DecimalNativeType);
                DecimalNativeType decimal = (DecimalNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.DECIMAL, decimal.precision(), decimal.scale());
            }
            case UUID: {
                return factory.createSqlType(SqlTypeName.UUID);
            }
            case STRING: {
                assert (nativeType instanceof VarlenNativeType);
                VarlenNativeType varlen = (VarlenNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.VARCHAR, varlen.length());
            }
            case BYTE_ARRAY: {
                assert (nativeType instanceof VarlenNativeType);
                VarlenNativeType varlen = (VarlenNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.VARBINARY, varlen.length());
            }
            case DATE: {
                return factory.createSqlType(SqlTypeName.DATE);
            }
            case TIME: {
                assert (nativeType instanceof TemporalNativeType);
                TemporalNativeType time = (TemporalNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.TIME, time.precision());
            }
            case TIMESTAMP: {
                assert (nativeType instanceof TemporalNativeType);
                TemporalNativeType ts = (TemporalNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, ts.precision());
            }
            case DATETIME: {
                assert (nativeType instanceof TemporalNativeType);
                TemporalNativeType dt = (TemporalNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.TIMESTAMP, dt.precision());
            }
            case STRUCT: {
                assert (nativeType instanceof StructNativeType);
                StructNativeType struct = (StructNativeType)nativeType;
                RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder(factory);
                for (StructNativeType.Field field : struct.fields()) {
                    builder.add(field.name(), TypeUtils.native2relationalType(factory, field.type(), field.nullable()));
                }
                return builder.build();
            }
        }
        throw new IllegalStateException("Unexpected native type " + nativeType);
    }

    public static RelDataType native2relationalType(RelDataTypeFactory factory, NativeType nativeType, boolean nullable) {
        return factory.createTypeWithNullability(TypeUtils.native2relationalType(factory, nativeType), nullable);
    }

    public static List<RelDataType> native2relationalTypes(RelDataTypeFactory factory, NativeType ... nativeTypes) {
        return Arrays.stream(nativeTypes).map(t -> TypeUtils.native2relationalType(factory, t)).collect(Collectors.toList());
    }

    public static NativeType columnType2NativeType(ColumnType columnType, int precision, int scale, int length) {
        switch (columnType) {
            case NULL: {
                return NativeTypes.NULL;
            }
            case BOOLEAN: {
                return NativeTypes.BOOLEAN;
            }
            case INT8: {
                return NativeTypes.INT8;
            }
            case INT16: {
                return NativeTypes.INT16;
            }
            case INT32: {
                return NativeTypes.INT32;
            }
            case INT64: {
                return NativeTypes.INT64;
            }
            case FLOAT: {
                return NativeTypes.FLOAT;
            }
            case DOUBLE: {
                return NativeTypes.DOUBLE;
            }
            case DECIMAL: {
                return NativeTypes.decimalOf((int)precision, (int)scale);
            }
            case DATE: {
                return NativeTypes.DATE;
            }
            case TIME: {
                return NativeTypes.time((int)precision);
            }
            case DATETIME: {
                return NativeTypes.datetime((int)precision);
            }
            case TIMESTAMP: {
                return NativeTypes.timestamp((int)precision);
            }
            case UUID: {
                return NativeTypes.UUID;
            }
            case STRING: {
                return NativeTypes.stringOf((int)length);
            }
            case BYTE_ARRAY: {
                return NativeTypes.blobOf((int)length);
            }
        }
        throw new IllegalArgumentException("No NativeType for type: " + columnType);
    }

    public static boolean needCastInSearchBounds(IgniteTypeFactory typeFactory, RelDataType fromType, RelDataType toType) {
        if (SqlTypeUtil.isCharacter((RelDataType)toType) && SqlTypeUtil.isCharacter((RelDataType)fromType)) {
            return false;
        }
        if (fromType.getPrecedenceList().containsType(toType) && SqlTypeUtil.isIntType((RelDataType)fromType) && SqlTypeUtil.isIntType((RelDataType)toType)) {
            return false;
        }
        if (fromType.getSqlTypeName() == toType.getSqlTypeName() && SqlTypeUtil.isDatetime((RelDataType)fromType)) {
            return false;
        }
        if (SqlTypeUtil.equalSansNullability((RelDataTypeFactory)typeFactory, (RelDataType)fromType, (RelDataType)toType)) {
            return false;
        }
        assert (SqlTypeUtil.canCastFrom((RelDataType)toType, (RelDataType)fromType, (boolean)true));
        return true;
    }

    public static boolean typeFamiliesAreCompatible(RelDataTypeFactory typeFactory, RelDataType toType, RelDataType fromType) {
        if (SqlTypeUtil.equalSansNullability((RelDataTypeFactory)typeFactory, (RelDataType)toType, (RelDataType)fromType)) {
            return true;
        }
        if (fromType.getSqlTypeName() == SqlTypeName.NULL || toType.getSqlTypeName() == SqlTypeName.NULL) {
            return true;
        }
        if (toType.isStruct() && fromType.isStruct()) {
            if (toType.getFieldCount() != fromType.getFieldCount()) {
                return false;
            }
            for (int i = 0; i < toType.getFieldCount(); ++i) {
                RelDataType type2;
                RelDataType type1 = ((RelDataTypeField)toType.getFieldList().get(i)).getType();
                if (TypeUtils.typeFamiliesAreCompatible(typeFactory, type1, type2 = ((RelDataTypeField)fromType.getFieldList().get(i)).getType())) continue;
                return false;
            }
            return true;
        }
        return SqlTypeUtil.canAssignFrom((RelDataType)toType, (RelDataType)fromType) && SqlTypeUtil.canAssignFrom((RelDataType)fromType, (RelDataType)toType);
    }

    public static boolean typeFamiliesAreCompatible(RelDataTypeFactory typeFactory, RelDataType ... types) {
        return TypeUtils.typeFamiliesAreCompatible(typeFactory, List.of(types));
    }

    public static boolean typeFamiliesAreCompatible(RelDataTypeFactory typeFactory, List<RelDataType> types) {
        if (types.size() < 2) {
            return true;
        }
        RelDataType firstType = null;
        for (RelDataType type : types) {
            if (firstType == null) {
                if (SqlTypeUtil.isNull((RelDataType)type)) continue;
                firstType = type;
                continue;
            }
            if (TypeUtils.typeFamiliesAreCompatible(typeFactory, firstType, type)) continue;
            return false;
        }
        return true;
    }

    public static StructNativeType convertStructuredType(RelDataType recordType) {
        NativeType result = IgniteTypeFactory.relDataTypeToNative(recordType);
        if (result instanceof StructNativeType) {
            return (StructNativeType)result;
        }
        throw new IllegalArgumentException("Provided type is not record type: " + recordType);
    }

    public static StructNativeType structuredTypeFromRelTypeList(List<RelDataType> types) {
        NativeTypes.RowTypeBuilder builder = NativeTypes.rowBuilder();
        int idx = 0;
        for (RelDataType type : types) {
            builder.addField("F" + idx++, IgniteTypeFactory.relDataTypeToNative(type), type.isNullable());
        }
        return builder.build();
    }

    public static StructNativeType map(StructNativeType schema, int[] mapping) {
        assert (mapping != null && mapping.length > 0);
        NativeTypes.RowTypeBuilder builder = NativeTypes.rowBuilder();
        for (int i : mapping) {
            builder.addField((StructNativeType.Field)schema.fields().get(i));
        }
        return builder.build();
    }

    public static <RowT> RowT validateStringTypesOverflowAndTrimIfPossible(RelDataType rowType, RowHandler<RowT> rowHandler, RowT row, Supplier<StructNativeType> schema) {
        boolean containValidatedType = rowType.getFieldList().stream().anyMatch(t -> SqlTypeName.STRING_TYPES.contains(t.getType().getSqlTypeName()));
        if (!containValidatedType) {
            return row;
        }
        int colCount = rowType.getFieldList().size();
        RowHandler.RowBuilder<RowT> rowBldr = null;
        for (int i = 0; i < colCount; ++i) {
            int pos;
            RelDataType colType = ((RelDataTypeField)rowType.getFieldList().get(i)).getType();
            SqlTypeName typeName = colType.getSqlTypeName();
            Object data = rowHandler.get(i, row);
            if (data == null || !SqlTypeName.BINARY_TYPES.contains(typeName) && !SqlTypeName.CHAR_TYPES.contains(typeName)) {
                if (rowBldr == null) continue;
                rowBldr.addField(data);
                continue;
            }
            int colPrecision = colType.getPrecision();
            assert (colPrecision != -1);
            if (SqlTypeName.BINARY_TYPES.contains(typeName)) {
                assert (data instanceof ByteString);
                ByteString byteString = (ByteString)data;
                if (byteString.length() > colPrecision) {
                    for (pos = byteString.length(); pos > colPrecision; --pos) {
                        if (byteString.byteAt(pos - 1) == 0) continue;
                        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Value too long for type: " + colType);
                    }
                    data = byteString.substring(0, colPrecision);
                    if (rowBldr == null) {
                        rowBldr = TypeUtils.buildPartialRow(rowHandler, schema, i, row);
                    }
                }
            }
            if (SqlTypeName.CHAR_TYPES.contains(typeName)) {
                assert (data instanceof String);
                String str = (String)data;
                if (str.length() > colPrecision) {
                    for (pos = str.length(); pos > colPrecision; --pos) {
                        if (str.charAt(pos - 1) == ' ') continue;
                        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Value too long for type: " + colType);
                    }
                    data = str.substring(0, colPrecision);
                    if (rowBldr == null) {
                        rowBldr = TypeUtils.buildPartialRow(rowHandler, schema, i, row);
                    }
                }
            }
            if (rowBldr == null) continue;
            rowBldr.addField(data);
        }
        if (rowBldr != null) {
            return rowBldr.build();
        }
        return row;
    }

    private static <RowT> RowHandler.RowBuilder<RowT> buildPartialRow(RowHandler<RowT> rowHandler, Supplier<StructNativeType> schema, int endPos, RowT row) {
        RowHandler.RowFactory<RowT> factory = rowHandler.factory(schema.get());
        RowHandler.RowBuilder<RowT> bldr = factory.rowBuilder();
        for (int i = 0; i < endPos; ++i) {
            Object data = rowHandler.get(i, row);
            bldr.addField(data);
        }
        return bldr;
    }

    public static boolean typesRepresentTheSameColumnTypes(RelDataType lhs, RelDataType rhs) {
        ColumnType col2;
        ColumnType col1 = TypeUtils.columnType(lhs);
        return col1 == (col2 = TypeUtils.columnType(rhs));
    }

    public static boolean isTimestamp(SqlTypeName typeName) {
        return typeName == SqlTypeName.TIMESTAMP || typeName == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE;
    }

    public static NativeType relational2nativeType(RelDataType relDataType) {
        return IgniteTypeFactory.relDataTypeToNative(relDataType);
    }

    public static StructNativeType concat(StructNativeType ... types) {
        NativeTypes.RowTypeBuilder builder = NativeTypes.rowBuilder();
        for (StructNativeType type : types) {
            type.fields().forEach(arg_0 -> ((NativeTypes.RowTypeBuilder)builder).addField(arg_0));
        }
        return builder.build();
    }

    private static class SupportedParamClassesHolder {
        static final Set<ColumnType> UNSUPPORTED_COLUMN_TYPES_AS_PARAMETERS = Set.of(ColumnType.PERIOD, ColumnType.DURATION, ColumnType.STRUCT);
        static final Set<Class<?>> SUPPORTED_PARAM_CLASSES = Arrays.stream(ColumnType.values()).filter(t -> !UNSUPPORTED_COLUMN_TYPES_AS_PARAMETERS.contains(t)).map(ColumnType::javaClass).collect(Collectors.toUnmodifiableSet());

        private SupportedParamClassesHolder() {
        }
    }
}

