/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql.dcl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.ignite.internal.sql.engine.sql.IgniteDdlOperator;
import org.apache.ignite.internal.sql.engine.sql.dcl.GridgainSqlDcl;
import org.jetbrains.annotations.Nullable;

public class GridgainSqlDropRole
extends SqlDrop
implements GridgainSqlDcl {
    private final SqlIdentifier name;

    public GridgainSqlDropRole(SqlParserPos pos, boolean ifExists, SqlIdentifier name) {
        super((SqlOperator)new Operator(ifExists), pos, ifExists);
        this.name = Objects.requireNonNull(name, "role name");
    }

    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.name);
    }

    public SqlIdentifier name() {
        return this.name;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP");
        writer.keyword("ROLE");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    protected static class Operator
    extends IgniteDdlOperator {
        public Operator(boolean existFlag) {
            super("DROP ROLE", SqlKind.OTHER_DDL, existFlag);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new GridgainSqlDropRole(pos, this.existFlag(), (SqlIdentifier)operands[0]);
        }
    }
}

