/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule.logical;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Collect;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.LogicVisitor;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlQuantifyOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.sql.engine.rule.logical.ImmutableIgniteSubQueryRemoveRule;
import org.immutables.value.Value;

@Value.Enclosing
public class IgniteSubQueryRemoveRule
extends RelRule<Config>
implements TransformationRule {
    public static final RelOptRule INSTANCE = Config.JOIN.toRule();

    protected IgniteSubQueryRemoveRule(Config config) {
        super((RelRule.Config)config);
        Objects.requireNonNull(config.matchHandler());
    }

    public void onMatch(RelOptRuleCall call) {
        ((Config)this.config).matchHandler().accept((Object)this, (Object)call);
    }

    protected RexNode apply(RexSubQuery e, Set<CorrelationId> variablesSet, RelOptUtil.Logic logic, RelBuilder builder, int inputCount, int offset, int subQueryIndex) {
        switch (e.getKind()) {
            case SCALAR_QUERY: {
                return IgniteSubQueryRemoveRule.rewriteScalarQuery(e, variablesSet, builder, inputCount, offset);
            }
            case ARRAY_QUERY_CONSTRUCTOR: 
            case MAP_QUERY_CONSTRUCTOR: 
            case MULTISET_QUERY_CONSTRUCTOR: {
                return IgniteSubQueryRemoveRule.rewriteCollection(e, variablesSet, builder, inputCount, offset);
            }
            case SOME: {
                return IgniteSubQueryRemoveRule.rewriteSome(e, variablesSet, builder, subQueryIndex);
            }
            case IN: {
                return IgniteSubQueryRemoveRule.rewriteIn(e, variablesSet, logic, builder, offset, subQueryIndex);
            }
            case EXISTS: {
                return IgniteSubQueryRemoveRule.rewriteExists(e, variablesSet, logic, builder);
            }
            case UNIQUE: {
                return IgniteSubQueryRemoveRule.rewriteUnique(e, builder);
            }
        }
        throw new AssertionError(e.getKind());
    }

    private static RexNode rewriteScalarQuery(RexSubQuery e, Set<CorrelationId> variablesSet, RelBuilder builder, int inputCount, int offset) {
        builder.push(e.rel);
        RelMetadataQuery mq = e.rel.getCluster().getMetadataQuery();
        Boolean unique = mq.areColumnsUnique(builder.peek(), ImmutableBitSet.of());
        if (unique == null || !unique.booleanValue()) {
            builder.aggregate(builder.groupKey(), new RelBuilder.AggCall[]{builder.aggregateCall(SqlStdOperatorTable.SINGLE_VALUE, new RexNode[]{builder.field(0)})});
        }
        builder.join(JoinRelType.LEFT, (RexNode)builder.literal((Object)true), variablesSet);
        return IgniteSubQueryRemoveRule.field(builder, inputCount, offset);
    }

    private static RexNode rewriteCollection(RexSubQuery e, Set<CorrelationId> variablesSet, RelBuilder builder, int inputCount, int offset) {
        builder.push(e.rel);
        builder.push((RelNode)Collect.create((RelNode)builder.build(), (SqlKind)e.getKind(), (String)"x"));
        builder.join(JoinRelType.INNER, (RexNode)builder.literal((Object)true), variablesSet);
        return IgniteSubQueryRemoveRule.field(builder, inputCount, offset);
    }

    private static RexNode rewriteSome(RexSubQuery e, Set<CorrelationId> variablesSet, RelBuilder builder, int subQueryIndex) {
        RexNode caseRexNode;
        block15: {
            Object qAlias;
            SqlAggFunction minMax;
            RexLiteral literalUnknown;
            RexLiteral literalTrue;
            RexLiteral literalFalse;
            SqlQuantifyOperator op;
            block14: {
                RelMetadataQuery mq = e.rel.getCluster().getMetadataQuery();
                if (RelMdUtil.isRelDefinitelyEmpty((RelMetadataQuery)mq, (RelNode)e.rel)) {
                    return builder.getRexBuilder().makeLiteral((Object)Boolean.FALSE, e.getType(), true);
                }
                op = (SqlQuantifyOperator)e.op;
                switch (op.comparisonKind) {
                    case GREATER_THAN_OR_EQUAL: 
                    case LESS_THAN_OR_EQUAL: 
                    case LESS_THAN: 
                    case GREATER_THAN: 
                    case NOT_EQUALS: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unexpected " + op));
                    }
                }
                literalFalse = builder.literal((Object)false);
                literalTrue = builder.literal((Object)true);
                literalUnknown = builder.getRexBuilder().makeNullLiteral(literalFalse.getType());
                minMax = op.comparisonKind == SqlKind.GREATER_THAN || op.comparisonKind == SqlKind.GREATER_THAN_OR_EQUAL ? SqlStdOperatorTable.MIN : SqlStdOperatorTable.MAX;
                qAlias = "q";
                if (subQueryIndex != 0) {
                    qAlias = "q" + subQueryIndex;
                }
                if (!variablesSet.isEmpty()) break block14;
                switch (op.comparisonKind) {
                    case GREATER_THAN_OR_EQUAL: 
                    case LESS_THAN_OR_EQUAL: 
                    case LESS_THAN: 
                    case GREATER_THAN: {
                        builder.push(e.rel).aggregate(builder.groupKey(), new RelBuilder.AggCall[]{builder.aggregateCall(minMax, new RexNode[]{builder.field(0)}).as("m"), builder.count(false, "c", new RexNode[0]), builder.count(false, "d", new RexNode[]{builder.field(0)})}).as((String)qAlias).join(JoinRelType.INNER, new String[0]);
                        caseRexNode = builder.call((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{builder.equals(builder.field((String)qAlias, "c"), (RexNode)builder.literal((Object)0)), literalFalse, builder.call((SqlOperator)SqlStdOperatorTable.IS_TRUE, new RexNode[]{builder.call(RexUtil.op((SqlKind)op.comparisonKind), new RexNode[]{(RexNode)e.operands.get(0), builder.field((String)qAlias, "m")})}), literalTrue, builder.greaterThan(builder.field((String)qAlias, "c"), builder.field((String)qAlias, "d")), literalUnknown, builder.call(RexUtil.op((SqlKind)op.comparisonKind), new RexNode[]{(RexNode)e.operands.get(0), builder.field((String)qAlias, "m")})});
                        break block15;
                    }
                    case NOT_EQUALS: {
                        builder.push(e.rel);
                        builder.distinct().aggregate(builder.groupKey(), new RelBuilder.AggCall[]{builder.count(false, "c", new RexNode[0]), builder.count(false, "d", new RexNode[]{builder.field(0)}), builder.max((RexNode)builder.field(0)).as("m")}).as((String)qAlias).join(JoinRelType.INNER, new String[0]);
                        caseRexNode = builder.call((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{builder.equals((RexNode)builder.field("c"), (RexNode)builder.literal((Object)0)), literalFalse, builder.isNull((RexNode)e.getOperands().get(0)), literalUnknown, builder.and(new RexNode[]{builder.notEquals((RexNode)builder.field("d"), (RexNode)builder.field("c")), builder.lessThanOrEqual((RexNode)builder.field("d"), (RexNode)builder.literal((Object)1))}), builder.or(new RexNode[]{builder.notEquals((RexNode)e.operands.get(0), builder.field((String)qAlias, "m")), literalUnknown}), builder.equals((RexNode)builder.field("d"), (RexNode)builder.literal((Object)1)), builder.notEquals((RexNode)e.operands.get(0), builder.field((String)qAlias, "m")), literalTrue});
                        break block15;
                    }
                    default: {
                        throw new AssertionError((Object)"not possible - per above check");
                    }
                }
            }
            String indicator = "trueLiteral";
            ArrayList<RexNode> parentQueryFields = new ArrayList<RexNode>();
            switch (op.comparisonKind) {
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case GREATER_THAN: {
                    builder.push(e.rel).aggregate(builder.groupKey(), new RelBuilder.AggCall[]{builder.aggregateCall(minMax, new RexNode[]{builder.field(0)}).as("m"), builder.count(false, "c", new RexNode[0]), builder.count(false, "d", new RexNode[]{builder.field(0)})});
                    parentQueryFields.addAll((Collection<RexNode>)builder.fields());
                    parentQueryFields.add(builder.alias((RexNode)literalTrue, "trueLiteral"));
                    builder.project(parentQueryFields).as((String)qAlias);
                    builder.join(JoinRelType.LEFT, (RexNode)literalTrue, variablesSet);
                    caseRexNode = builder.call((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{builder.isNull(builder.field((String)qAlias, "trueLiteral")), literalFalse, builder.equals(builder.field((String)qAlias, "c"), (RexNode)builder.literal((Object)0)), literalFalse, builder.call((SqlOperator)SqlStdOperatorTable.IS_TRUE, new RexNode[]{builder.call(RexUtil.op((SqlKind)op.comparisonKind), new RexNode[]{(RexNode)e.operands.get(0), builder.field((String)qAlias, "m")})}), literalTrue, builder.greaterThan(builder.field((String)qAlias, "c"), builder.field((String)qAlias, "d")), literalUnknown, builder.call(RexUtil.op((SqlKind)op.comparisonKind), new RexNode[]{(RexNode)e.operands.get(0), builder.field((String)qAlias, "m")})});
                    break;
                }
                case NOT_EQUALS: {
                    builder.push(e.rel).aggregate(builder.groupKey(), new RelBuilder.AggCall[]{builder.count(false, "c", new RexNode[0]), builder.count(false, "d", new RexNode[]{builder.field(0)}), builder.count(true, "dd", new RexNode[]{builder.field(0)}), builder.max((RexNode)builder.field(0)).as("m")});
                    parentQueryFields.addAll((Collection<RexNode>)builder.fields());
                    parentQueryFields.add(builder.alias((RexNode)literalTrue, "trueLiteral"));
                    builder.project(parentQueryFields).as((String)qAlias);
                    builder.join(JoinRelType.LEFT, (RexNode)literalTrue, variablesSet);
                    caseRexNode = builder.call((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{builder.isNull(builder.field((String)qAlias, "trueLiteral")), literalFalse, builder.equals((RexNode)builder.field("c"), (RexNode)builder.literal((Object)0)), literalFalse, builder.isNull((RexNode)e.getOperands().get(0)), literalUnknown, builder.and(new RexNode[]{builder.notEquals((RexNode)builder.field("d"), (RexNode)builder.field("c")), builder.lessThanOrEqual((RexNode)builder.field("dd"), (RexNode)builder.literal((Object)1))}), builder.or(new RexNode[]{builder.notEquals((RexNode)e.operands.get(0), builder.field((String)qAlias, "m")), literalUnknown}), builder.equals((RexNode)builder.field("dd"), (RexNode)builder.literal((Object)1)), builder.notEquals((RexNode)e.operands.get(0), builder.field((String)qAlias, "m")), literalTrue});
                    break;
                }
                default: {
                    throw new AssertionError((Object)"not possible - per above check");
                }
            }
        }
        if (!e.getType().isNullable()) {
            return builder.cast(caseRexNode, e.getType().getSqlTypeName());
        }
        return caseRexNode;
    }

    private static RexNode rewriteExists(RexSubQuery e, Set<CorrelationId> variablesSet, RelOptUtil.Logic logic, RelBuilder builder) {
        RelMetadataQuery mq = e.rel.getCluster().getMetadataQuery();
        if (RelMdUtil.isRelDefinitelyNotEmpty((RelMetadataQuery)mq, (RelNode)e.rel)) {
            return builder.literal((Object)true);
        }
        if (RelMdUtil.isRelDefinitelyEmpty((RelMetadataQuery)mq, (RelNode)e.rel)) {
            return builder.literal((Object)false);
        }
        builder.push(e.rel);
        builder.project(new RexNode[]{builder.alias((RexNode)builder.literal((Object)true), "i")});
        switch (logic) {
            case TRUE: {
                builder.aggregate(builder.groupKey(new int[]{0}), new RelBuilder.AggCall[0]);
                builder.as("dt");
                builder.join(JoinRelType.INNER, (RexNode)builder.literal((Object)true), variablesSet);
                return builder.literal((Object)true);
            }
        }
        builder.distinct();
        builder.as("dt");
        builder.join(JoinRelType.LEFT, (RexNode)builder.literal((Object)true), variablesSet);
        return builder.isNotNull((RexNode)Util.last((List)builder.fields()));
    }

    private static RexNode rewriteUnique(RexSubQuery e, RelBuilder builder) {
        RelMetadataQuery mq = e.rel.getCluster().getMetadataQuery();
        Boolean isUnique = mq.areRowsUnique(e.rel, true);
        if (isUnique != null && isUnique.booleanValue()) {
            return builder.getRexBuilder().makeLiteral(true);
        }
        builder.push(e.rel);
        List notNullCondition = builder.fields().stream().map(arg_0 -> ((RelBuilder)builder).isNotNull(arg_0)).collect(Collectors.toList());
        builder.filter(notNullCondition).aggregate(builder.groupKey((Iterable)builder.fields()), new RelBuilder.AggCall[]{builder.countStar("c")}).filter(new RexNode[]{builder.greaterThan((RexNode)Util.last((List)builder.fields()), (RexNode)builder.literal((Object)1))});
        RelNode relNode = builder.build();
        return builder.call((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{RexSubQuery.exists((RelNode)relNode)});
    }

    private static RexNode rewriteIn(RexSubQuery e, Set<CorrelationId> variablesSet, RelOptUtil.Logic logic, RelBuilder builder, int offset, int subQueryIndex) {
        RelMetadataQuery mq = e.rel.getCluster().getMetadataQuery();
        if (RelMdUtil.isRelDefinitelyEmpty((RelMetadataQuery)mq, (RelNode)e.rel)) {
            return builder.getRexBuilder().makeLiteral((Object)Boolean.FALSE, e.getType(), true);
        }
        builder.push(e.rel);
        ArrayList fields = new ArrayList(builder.fields());
        Object ctAlias = "ct";
        if (subQueryIndex != 0) {
            ctAlias = "ct" + subQueryIndex;
        }
        boolean allLiterals = RexUtil.allLiterals((List)e.getOperands());
        ArrayList expressionOperands = new ArrayList(e.getOperands());
        List keyIsNulls = e.getOperands().stream().filter(operand -> operand.getType().isNullable()).map(arg_0 -> ((RelBuilder)builder).isNull(arg_0)).collect(Collectors.toList());
        RexLiteral trueLiteral = builder.literal((Object)true);
        RexLiteral falseLiteral = builder.literal((Object)false);
        RexLiteral unknownLiteral = builder.getRexBuilder().makeNullLiteral(trueLiteral.getType());
        if (allLiterals) {
            List conditions = Pair.zip(expressionOperands, fields).stream().map(pair -> builder.equals((RexNode)pair.left, (RexNode)pair.right)).collect(Collectors.toList());
            switch (logic) {
                case TRUE: 
                case TRUE_FALSE: {
                    builder.filter(conditions);
                    builder.project(new RexNode[]{builder.alias((RexNode)trueLiteral, "cs")});
                    builder.distinct();
                    break;
                }
                default: {
                    List isNullOperands = fields.stream().map(arg_0 -> ((RelBuilder)builder).isNull(arg_0)).collect(Collectors.toList());
                    isNullOperands.addAll(keyIsNulls);
                    builder.filter(new RexNode[]{builder.or(new RexNode[]{builder.and(conditions), builder.or(isNullOperands)})});
                    RexNode project = builder.and((Iterable)fields.stream().map(arg_0 -> ((RelBuilder)builder).isNotNull(arg_0)).collect(Collectors.toList()));
                    builder.project(new RexNode[]{builder.alias(project, "cs")});
                    if (variablesSet.isEmpty()) {
                        builder.aggregate(builder.groupKey(new RexNode[]{builder.field("cs")}), new RelBuilder.AggCall[]{builder.count(false, "c", new RexNode[0])});
                    } else {
                        builder.distinct();
                    }
                    builder.sortLimit(0, 1, (Iterable)ImmutableList.of((Object)builder.desc((RexNode)builder.field("cs"))));
                }
            }
            expressionOperands.clear();
            fields.clear();
        } else {
            switch (logic) {
                case TRUE: {
                    builder.aggregate(builder.groupKey(fields), new RelBuilder.AggCall[0]);
                    break;
                }
                case TRUE_FALSE_UNKNOWN: 
                case UNKNOWN_AS_TRUE: {
                    builder.aggregate(builder.groupKey(), new RelBuilder.AggCall[]{builder.count(false, "c", new RexNode[0]), builder.count((Iterable)builder.fields()).as("ck")});
                    builder.as((String)ctAlias);
                    if (!variablesSet.isEmpty()) {
                        builder.join(JoinRelType.LEFT, (RexNode)trueLiteral, variablesSet);
                    } else {
                        builder.join(JoinRelType.INNER, (RexNode)trueLiteral, variablesSet);
                    }
                    offset += 2;
                    builder.push(e.rel);
                }
                default: {
                    builder.aggregate(builder.groupKey(fields), new RelBuilder.AggCall[]{builder.literalAgg((Object)true).as("i")});
                }
            }
        }
        Object dtAlias = "dt";
        if (subQueryIndex != 0) {
            dtAlias = "dt" + subQueryIndex;
        }
        builder.as((String)dtAlias);
        int refOffset = offset;
        List conditions = Pair.zip(expressionOperands, (List)builder.fields()).stream().map(pair -> builder.equals((RexNode)pair.left, RexUtil.shift((RexNode)((RexNode)pair.right), (int)refOffset))).collect(Collectors.toList());
        switch (logic) {
            case TRUE: {
                builder.join(JoinRelType.INNER, builder.and(conditions), variablesSet);
                return trueLiteral;
            }
        }
        builder.join(JoinRelType.LEFT, builder.and(conditions), variablesSet);
        ImmutableList.Builder operands = ImmutableList.builder();
        RexLiteral b = trueLiteral;
        switch (logic) {
            case TRUE_FALSE_UNKNOWN: {
                b = unknownLiteral;
            }
            case UNKNOWN_AS_TRUE: {
                if (allLiterals) {
                    if (variablesSet.isEmpty()) {
                        operands.add((Object[])new RexNode[]{builder.isNull(builder.field((String)dtAlias, "c")), falseLiteral});
                    }
                    operands.add((Object[])new RexNode[]{builder.equals(builder.field((String)dtAlias, "cs"), (RexNode)falseLiteral), b});
                    break;
                }
                operands.add((Object[])new RexNode[]{builder.equals(builder.field((String)ctAlias, "c"), (RexNode)builder.literal((Object)0)), falseLiteral});
                break;
            }
        }
        if (!keyIsNulls.isEmpty()) {
            operands.add((Object[])new RexNode[]{builder.or(keyIsNulls), unknownLiteral});
        }
        if (allLiterals) {
            operands.add((Object[])new RexNode[]{builder.isNotNull(builder.field((String)dtAlias, "cs")), trueLiteral});
        } else {
            operands.add((Object[])new RexNode[]{builder.isNotNull((RexNode)Util.last((List)builder.fields())), trueLiteral});
        }
        if (!allLiterals) {
            switch (logic) {
                case TRUE_FALSE_UNKNOWN: 
                case UNKNOWN_AS_TRUE: {
                    operands.add((Object[])new RexNode[]{builder.lessThan(builder.field((String)ctAlias, "ck"), builder.field((String)ctAlias, "c")), b});
                    break;
                }
            }
        }
        operands.add((Object)falseLiteral);
        return builder.call((SqlOperator)SqlStdOperatorTable.CASE, (Iterable)operands.build());
    }

    private static RexInputRef field(RelBuilder builder, int inputCount, int offset) {
        int inputOrdinal = 0;
        RelNode r;
        while (offset >= (r = builder.peek(inputCount, inputOrdinal)).getRowType().getFieldCount()) {
            ++inputOrdinal;
            offset -= r.getRowType().getFieldCount();
        }
        return builder.field(inputCount, inputOrdinal, offset);
    }

    private static List<RexNode> fields(RelBuilder builder, int fieldCount) {
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        for (int i = 0; i < fieldCount; ++i) {
            projects.add((RexNode)builder.field(i));
        }
        return projects;
    }

    private static void matchJoin(IgniteSubQueryRemoveRule rule, RelOptRuleCall call) {
        final Join join = (Join)call.rel(0);
        RelBuilder builder = call.builder();
        RexSubQuery e = Objects.requireNonNull(RexUtil.SubQueryFinder.find((RexNode)join.getCondition()));
        RelOptUtil.Logic logic = LogicVisitor.find((RelOptUtil.Logic)RelOptUtil.Logic.TRUE, (List)ImmutableList.of((Object)join.getCondition()), (RexNode)e);
        ImmutableBitSet inputSet = RelOptUtil.InputFinder.bits((List)e.getOperands(), null);
        int nFieldsLeft = join.getLeft().getRowType().getFieldCount();
        int nFieldsRight = join.getRight().getRowType().getFieldCount();
        Set variablesSet = RelOptUtil.getVariablesUsed((RelNode)e.rel);
        if (!variablesSet.isEmpty()) {
            CorrelationId id = (CorrelationId)Iterables.getOnlyElement((Iterable)variablesSet);
            ImmutableBitSet requiredColumns = RelOptUtil.correlationColumns((CorrelationId)id, (RelNode)e.rel);
            inputSet = ImmutableBitSet.union(List.of(requiredColumns, inputSet));
        }
        boolean inputIntersectsRightSide = inputSet.intersects(ImmutableBitSet.range((int)nFieldsLeft, (int)(nFieldsLeft + nFieldsRight)));
        boolean inputIntersectsLeftSide = inputSet.intersects(ImmutableBitSet.range((int)0, (int)nFieldsLeft));
        if (inputIntersectsLeftSide && inputIntersectsRightSide) {
            return;
        }
        if (inputIntersectsLeftSide) {
            builder.push(join.getLeft());
            RexNode target = rule.apply(e, variablesSet, logic, builder, 1, nFieldsLeft, 0);
            ReplaceSubQueryShuttle shuttle = new ReplaceSubQueryShuttle(e, target);
            RexNode newCond = shuttle.apply(RexUtil.shift((RexNode)join.getCondition(), (int)nFieldsLeft, (int)(builder.fields().size() - nFieldsLeft)));
            builder.push(join.getRight());
            builder.join(join.getJoinType(), newCond);
            int nFields = builder.fields().size();
            ImmutableList fields = builder.fields(ImmutableBitSet.range((int)0, (int)nFieldsLeft).union(ImmutableBitSet.range((int)(nFields - nFieldsRight), (int)nFields)));
            builder.project((Iterable)fields);
        } else {
            builder.push(join.getLeft());
            builder.push(join.getRight());
            RexSubQuery subQuery = e;
            if (!variablesSet.isEmpty()) {
                final CorrelationId id = (CorrelationId)Iterables.getOnlyElement((Iterable)variablesSet);
                subQuery = e.clone(e.rel.accept((RelShuttle)new RelHomogeneousShuttle(){
                    private final int offset;
                    private final RexBuilder rexBuilder;
                    private final RexShuttle rexShuttle;
                    {
                        this.offset = join.getLeft().getRowType().getFieldCount();
                        this.rexBuilder = join.getRight().getCluster().getRexBuilder();
                        this.rexShuttle = new RexShuttle(){

                            public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
                                if (!(fieldAccess.getReferenceExpr() instanceof RexCorrelVariable) || !((RexCorrelVariable)fieldAccess.getReferenceExpr()).id.equals((Object)id)) {
                                    return super.visitFieldAccess(fieldAccess);
                                }
                                RexNode updatedCorrelation = rexBuilder.makeCorrel(join.getRight().getRowType(), id);
                                int oldIdx = fieldAccess.getField().getIndex();
                                return rexBuilder.makeFieldAccess(updatedCorrelation, oldIdx - offset);
                            }
                        };
                    }

                    public RelNode visit(RelNode other) {
                        RelNode next = super.visit(other);
                        return next.accept(this.rexShuttle);
                    }
                }));
            }
            int nFields = join.getRowType().getFieldCount();
            RexNode target = rule.apply(subQuery, variablesSet, logic, builder, 2, nFields, 0);
            ReplaceSubQueryShuttle shuttle = new ReplaceSubQueryShuttle(e, target);
            builder.join(join.getJoinType(), shuttle.apply(join.getCondition()));
            builder.project(IgniteSubQueryRemoveRule.fields(builder, nFields));
        }
        call.transformTo(builder.build());
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public static final Config JOIN = ImmutableIgniteSubQueryRemoveRule.Config.builder().withMatchHandler((RelRule.MatchHandler<IgniteSubQueryRemoveRule>)((RelRule.MatchHandler)(x$0, x$1) -> IgniteSubQueryRemoveRule.matchJoin(x$0, x$1))).build().withOperandSupplier(b -> b.operand(Join.class).predicate(RexUtil.SubQueryFinder::containsSubQuery).anyInputs()).withDescription("SubQueryRemoveRule:Join");

        default public IgniteSubQueryRemoveRule toRule() {
            return new IgniteSubQueryRemoveRule(this);
        }

        public RelRule.MatchHandler<IgniteSubQueryRemoveRule> matchHandler();

        public Config withMatchHandler(RelRule.MatchHandler<IgniteSubQueryRemoveRule> var1);
    }

    private static class ReplaceSubQueryShuttle
    extends RexShuttle {
        private final RexSubQuery subQuery;
        private final RexNode replacement;

        ReplaceSubQueryShuttle(RexSubQuery subQuery, RexNode replacement) {
            this.subQuery = subQuery;
            this.replacement = replacement;
        }

        public RexNode visitSubQuery(RexSubQuery subQuery) {
            return subQuery.equals((Object)this.subQuery) ? this.replacement : subQuery;
        }
    }
}

