/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare.partitionawareness;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.List;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.internal.sql.engine.prepare.RelWithSources;
import org.apache.ignite.internal.sql.engine.prepare.partitionawareness.DirectTxMode;
import org.apache.ignite.internal.sql.engine.prepare.partitionawareness.PartitionAwarenessMetadata;
import org.apache.ignite.internal.sql.engine.prepare.pruning.PartitionPruningColumns;
import org.apache.ignite.internal.sql.engine.prepare.pruning.PartitionPruningMetadata;
import org.apache.ignite.internal.sql.engine.rel.IgniteKeyValueGet;
import org.apache.ignite.internal.sql.engine.rel.IgniteKeyValueModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableFunctionScan;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.sql.fun.IgniteSqlOperatorTable;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.Primitives;
import org.apache.ignite.internal.sql.engine.util.RexUtils;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.util.ColocationUtils;
import org.jetbrains.annotations.Nullable;

public class PartitionAwarenessMetadataExtractor {
    @Nullable
    public static PartitionAwarenessMetadata getMetadata(RelWithSources relationWithSources, @Nullable PartitionPruningMetadata partitionPruningMetadata) {
        IgniteRel rel = relationWithSources.root();
        if (rel instanceof IgniteKeyValueGet) {
            return PartitionAwarenessMetadataExtractor.getMetadata((IgniteKeyValueGet)rel);
        }
        if (rel instanceof IgniteKeyValueModify) {
            return PartitionAwarenessMetadataExtractor.getMetadata((IgniteKeyValueModify)rel);
        }
        if (partitionPruningMetadata != null) {
            return PartitionAwarenessMetadataExtractor.tryConvertPartitionPruningMetadata(relationWithSources, partitionPruningMetadata);
        }
        return null;
    }

    @Nullable
    private static PartitionAwarenessMetadata getMetadata(IgniteKeyValueGet kv) {
        RelOptTable optTable = kv.getTable();
        assert (optTable != null);
        List<RexNode> expressions = kv.keyExpressions();
        return PartitionAwarenessMetadataExtractor.buildMetadata(optTable, false, expressions, DirectTxMode.SUPPORTED);
    }

    @Nullable
    private static PartitionAwarenessMetadata getMetadata(IgniteKeyValueModify kv) {
        RelOptTable optTable = kv.getTable();
        assert (optTable != null);
        List<RexNode> expressions = kv.expressions();
        return PartitionAwarenessMetadataExtractor.buildMetadata(optTable, kv.operation() == IgniteKeyValueModify.Operation.INSERT, expressions, DirectTxMode.SUPPORTED_TRACKING_REQUIRED);
    }

    @Nullable
    private static PartitionAwarenessMetadata buildMetadata(RelOptTable optTable, boolean fullRow, List<RexNode> expressions, DirectTxMode directTxMode) {
        IgniteTable igniteTable = (IgniteTable)optTable.unwrap(IgniteTable.class);
        assert (igniteTable != null);
        ImmutableIntList colocationKeys = igniteTable.distribution().getKeys();
        int[] indexes = new int[colocationKeys.size()];
        IntArrayList hashFields = new IntArrayList(colocationKeys.size() / 2);
        for (int i = 0; i < colocationKeys.size(); ++i) {
            RexNode expr;
            int colIdx = colocationKeys.get(i);
            if (fullRow) {
                expr = expressions.get(colIdx);
            } else {
                int keyIdx = igniteTable.keyColumns().indexOf(colIdx);
                expr = expressions.get(keyIdx);
            }
            boolean added = PartitionAwarenessMetadataExtractor.addToMetadata(expr, indexes, i, hashFields);
            if (added) continue;
            return null;
        }
        int[] hash = hashFields.toIntArray();
        return new PartitionAwarenessMetadata(igniteTable.id(), indexes, hash, directTxMode);
    }

    @Nullable
    private static PartitionAwarenessMetadata tryConvertPartitionPruningMetadata(RelWithSources relationWithSources, PartitionPruningMetadata metadata) {
        if (metadata.data().size() != 1) {
            return null;
        }
        Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)metadata.data().long2ObjectEntrySet().iterator().next();
        long sourceId = entry.getLongKey();
        IgniteRel sourceRel = relationWithSources.get(sourceId);
        assert (sourceRel != null);
        RelOptTable optTable = sourceRel.getTable();
        assert (optTable != null);
        IgniteTable igniteTable = (IgniteTable)optTable.unwrap(IgniteTable.class);
        assert (igniteTable != null);
        PartitionPruningColumns columns = (PartitionPruningColumns)entry.getValue();
        if (columns.columns().size() != 1 || columns.containCorrelatedVariables()) {
            return null;
        }
        boolean dml = relationWithSources.modifiedTables().contains(igniteTable.id());
        long numSources = PartitionAwarenessMetadataExtractor.numberOfModifyAndSourceRels(relationWithSources);
        if (!dml && numSources != 1L) {
            return null;
        }
        if (dml && numSources != 2L) {
            return null;
        }
        DirectTxMode directTxMode = dml ? DirectTxMode.NOT_SUPPORTED : DirectTxMode.SUPPORTED;
        ImmutableIntList colocationKeys = igniteTable.distribution().getKeys();
        int[] indexes = new int[colocationKeys.size()];
        IntArrayList hashFields = new IntArrayList(colocationKeys.size());
        Int2ObjectMap<RexNode> cols = columns.columns().get(0);
        for (Int2ObjectMap.Entry colEntry : cols.int2ObjectEntrySet()) {
            RexNode colExpr = (RexNode)colEntry.getValue();
            int colIdx = colEntry.getIntKey();
            int i = colocationKeys.indexOf(colIdx);
            assert (i >= 0) : "Invalid colocation column index: " + cols.keySet();
            boolean added = PartitionAwarenessMetadataExtractor.addToMetadata(colExpr, indexes, i, hashFields);
            if (added) continue;
            return null;
        }
        int[] hash = hashFields.toIntArray();
        return new PartitionAwarenessMetadata(igniteTable.id(), indexes, hash, directTxMode);
    }

    private static long numberOfModifyAndSourceRels(RelWithSources relationWithSources) {
        Long2ObjectMap<IgniteRel> sources = relationWithSources.sources();
        return sources.values().stream().filter(r -> {
            if (!(r instanceof IgniteTableFunctionScan)) {
                return true;
            }
            IgniteTableFunctionScan scan = (IgniteTableFunctionScan)r;
            return !RexUtil.isCallTo((RexNode)scan.getCall(), (SqlOperator)IgniteSqlOperatorTable.SYSTEM_RANGE);
        }).count();
    }

    private static boolean addToMetadata(RexNode colExpr, int[] indexes, int i, IntArrayList hashFields) {
        if (colExpr instanceof RexDynamicParam) {
            RexDynamicParam dynamicParam = (RexDynamicParam)colExpr;
            indexes[i] = dynamicParam.getIndex();
            return true;
        }
        if (colExpr instanceof RexLiteral) {
            RexLiteral literal = (RexLiteral)colExpr;
            if (literal.getTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
                return false;
            }
            int hashValue = PartitionAwarenessMetadataExtractor.computeHash(literal);
            hashFields.add(hashValue);
            indexes[i] = -hashFields.size();
            return true;
        }
        return false;
    }

    private static int computeHash(RexLiteral literal) {
        Class internalType = Primitives.wrap((Class)Commons.typeFactory().getJavaClass(literal.getType()));
        Object val = RexUtils.literalValue(RexUtils.FaultyContext.INSTANCE, literal, internalType);
        NativeType nativeType = IgniteTypeFactory.relDataTypeToNative(literal.getType());
        Object internalVal = TypeUtils.fromInternal(val, nativeType.spec());
        return ColocationUtils.hash((Object)internalVal, (NativeType)nativeType);
    }
}

