/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryTupleMessage;
import org.apache.ignite.internal.sql.engine.message.QueryBatchMessage;
import org.apache.ignite.internal.sql.engine.message.QueryBatchMessageBuilder;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesFactory;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesTypeInfos;

class QueryBatchMessageDeserializer
implements MessageDeserializer<QueryBatchMessage> {
    private final QueryBatchMessageBuilder msg;

    QueryBatchMessageDeserializer(SqlQueryMessagesFactory messageFactory) {
        this.msg = messageFactory.queryBatchMessage();
    }

    public Class<QueryBatchMessage> klass() {
        return QueryBatchMessage.class;
    }

    public QueryBatchMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(SqlQueryMessagesTypeInfos.queryBatchMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("batchId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.batchId(tmp);
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("exchangeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.exchangeId(tmp);
                reader.incrementState();
            }
            case 2: {
                int tmp = reader.readInt("executionToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.executionToken(tmp);
                reader.incrementState();
            }
            case 3: {
                long tmp = reader.readLong("fragmentId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.fragmentId(tmp);
                reader.incrementState();
            }
            case 4: {
                boolean tmp = reader.readBoolean("last");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.last(tmp);
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readUuid("queryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.queryId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 6: {
                Object tmp = reader.readList("rows", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.rows((List<BinaryTupleMessage>)tmp);
                }
                reader.incrementState();
            }
            case 7: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(QueryBatchMessage.class);
    }
}

