/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.inmemory;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowQueue;
import org.apache.ignite.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class RowQueueColumnlessImpl<RowT>
implements RowQueue<RowT> {
    private int rowCount;
    private boolean closed;
    private RowT row;

    @Override
    @Nullable
    public RowT peek() {
        this.checkClosed();
        if (this.rowCount == 0) {
            return null;
        }
        return this.row;
    }

    @Override
    @Nullable
    public RowT poll() {
        this.checkClosed();
        if (this.rowCount == 0) {
            return null;
        }
        --this.rowCount;
        return this.row;
    }

    @Override
    @Nullable
    public RowT remove() {
        this.checkClosed();
        if (this.rowCount == 0) {
            throw new NoSuchElementException();
        }
        --this.rowCount;
        return this.row;
    }

    @Override
    public void add(RowT element) {
        this.checkClosed();
        Objects.requireNonNull(element, "element");
        this.row = element;
        ++this.rowCount;
    }

    @Override
    public int size() {
        this.checkClosed();
        return this.rowCount;
    }

    @Override
    public void clear() {
        this.checkClosed();
        this.rowCount = 0;
    }

    @Override
    public boolean isEmpty() {
        this.checkClosed();
        return this.rowCount == 0;
    }

    @Override
    public Iterator<RowT> iterator() {
        this.checkClosed();
        return new Iterator<RowT>(){
            int rowCount0;
            {
                this.rowCount0 = RowQueueColumnlessImpl.this.rowCount;
            }

            @Override
            public boolean hasNext() {
                RowQueueColumnlessImpl.this.checkClosed();
                return this.rowCount0 != 0 && RowQueueColumnlessImpl.this.rowCount != 0;
            }

            @Override
            public RowT next() {
                RowQueueColumnlessImpl.this.checkClosed();
                if (this.rowCount0 == 0 || RowQueueColumnlessImpl.this.rowCount == 0) {
                    throw new NoSuchElementException();
                }
                --this.rowCount0;
                return RowQueueColumnlessImpl.this.row;
            }
        };
    }

    public void close() throws Exception {
        this.closed = true;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Queue row store is closed.");
        }
    }
}

