/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.inmemory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowHashJoinIndex;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.type.StructNativeType;
import org.apache.ignite.internal.util.ReverseIterator;
import org.apache.ignite.internal.util.TransformingIterator;
import org.apache.ignite.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;

@NotThreadSafe
class RowHashJoinIndexImpl<RowT>
implements RowHashJoinIndex<RowT, RowT> {
    private static final int INITIAL_CAPACITY = 128;
    private static final Key NULL_KEY = new Key();
    private final MemoryContext<RowT> memoryContext;
    private final RowHandler<RowT> rowHandler;
    private final int rowColumnsCount;
    private final RowHandler.RowFactory<RowT> keyRowFactory;
    private final int[] keyFields;
    private HashMap<Key, List<Node>> hashIndex;
    private int size;

    RowHashJoinIndexImpl(MemoryContext<RowT> memoryContext, RowHandler.RowFactory<RowT> rowFactory, int[] keyFields) {
        this.memoryContext = memoryContext;
        this.rowHandler = rowFactory.handler();
        this.keyFields = keyFields;
        this.rowColumnsCount = rowFactory.columnsCount();
        this.hashIndex = new HashMap(128);
        StructNativeType keySchema = TypeUtils.map(rowFactory.rowSchema(), keyFields);
        this.keyRowFactory = this.rowHandler.factory(keySchema);
    }

    @Override
    public boolean contains(RowT row) {
        this.checkClosed();
        Key key = this.wrapKey(row);
        if (key == NULL_KEY) {
            return false;
        }
        return this.hashIndex.containsKey(key);
    }

    @Override
    public Iterator<RowT> lookup(RowT row) {
        this.checkClosed();
        Key key = this.wrapKey(row);
        if (key == NULL_KEY) {
            return Collections.emptyIterator();
        }
        List<Node> rowList = this.hashIndex.get(key);
        if (rowList == null) {
            return Collections.emptyIterator();
        }
        return new TransformingIterator((Iterator)new ReverseIterator(rowList), r -> {
            r.touch();
            return r.row;
        });
    }

    @Override
    public Iterator<RowT> untouchedIterator() {
        this.checkClosed();
        Iterator nodeIterator = this.hashIndex.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().filter(Predicate.not(Node::touched))).iterator();
        return new TransformingIterator(nodeIterator, r -> {
            r.touch();
            return r.row;
        });
    }

    @Override
    public Iterator<RowHashJoinIndex.IndexEntry<RowT>> entryIterator() {
        this.checkClosed();
        return this.hashIndex.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).map(r -> r).iterator();
    }

    @Override
    public void add(RowT element) {
        this.checkClosed();
        Objects.requireNonNull(element, "element");
        Key key = this.keyFromRow(element);
        List list = this.hashIndex.get(key);
        if (list == null) {
            this.acquire(key);
            list = this.hashIndex.computeIfAbsent(key, k -> new LinkedList());
        }
        this.memoryContext.acquire(element);
        list.add(new Node(element));
        ++this.size;
    }

    @Override
    public int size() {
        this.checkClosed();
        return this.size;
    }

    @Override
    public void clear() {
        this.checkClosed();
        this.hashIndex.entrySet().stream().peek(entry -> this.release((Key)entry.getKey())).flatMap(e -> ((List)e.getValue()).stream().map(Node::row)).forEach(this.memoryContext::release);
        this.hashIndex.clear();
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        this.checkClosed();
        return this.size == 0;
    }

    @Override
    public Iterator<RowT> iterator() {
        this.checkClosed();
        return this.hashIndex.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(Node::row)).iterator();
    }

    public void close() {
        if (this.hashIndex != null) {
            this.clear();
        }
        this.hashIndex = null;
    }

    private void checkClosed() {
        if (this.hashIndex == null) {
            throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Hash join index store has been closed.");
        }
    }

    private Key keyFromRow(RowT row) {
        assert (this.rowHandler.columnCount(row) == this.rowColumnsCount) : this.rowHandler.columnCount(row);
        return this.wrapKey(this.keyRowFactory.map(row, this.keyFields));
    }

    private Key wrapKey(RowT key) {
        assert (this.rowHandler.columnCount(key) == this.keyFields.length);
        for (int i = 0; i < this.keyFields.length; ++i) {
            if (this.rowHandler.get(i, key) != null) continue;
            return NULL_KEY;
        }
        return new RowKeyWrapper(key);
    }

    private void acquire(Key keyObj) {
        if (keyObj == NULL_KEY) {
            return;
        }
        RowKeyWrapper rowKey = (RowKeyWrapper)keyObj;
        this.memoryContext.acquire(rowKey.key);
    }

    private void release(Key keyObj) {
        if (keyObj == NULL_KEY) {
            return;
        }
        RowKeyWrapper rowKey = (RowKeyWrapper)keyObj;
        this.memoryContext.release(rowKey.key);
    }

    private int hash(RowT key) {
        int columnCount = this.rowHandler.columnCount(key);
        int hc = 0;
        for (int i = 0; i < columnCount; ++i) {
            Object entHold = this.rowHandler.get(i, key);
            hc += Objects.hashCode(entHold);
        }
        return hc;
    }

    private static class Key {
        private Key() {
        }
    }

    class Node
    implements RowHashJoinIndex.IndexEntry<RowT> {
        private final RowT row;
        private boolean touched;

        Node(RowT element) {
            this.row = element;
        }

        @Override
        public RowT row() {
            return this.row;
        }

        void touch() {
            this.touched = true;
        }

        @Override
        public boolean touched() {
            return this.touched;
        }
    }

    private class RowKeyWrapper
    extends Key {
        private final int hashCode;
        private final RowT key;

        RowKeyWrapper(RowT key) {
            this.key = key;
            this.hashCode = RowHashJoinIndexImpl.this.hash(key);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RowKeyWrapper key0 = (RowKeyWrapper)obj;
            int columnCount = RowHashJoinIndexImpl.this.rowHandler.columnCount(this.key);
            for (int i = 0; i < columnCount; ++i) {
                Object current;
                Object input = RowHashJoinIndexImpl.this.rowHandler.get(i, key0.key);
                if (Objects.equals(input, current = RowHashJoinIndexImpl.this.rowHandler.get(i, this.key))) continue;
                return false;
            }
            return true;
        }
    }
}

