/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.ImmutableRowList;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.ImmutableRowQueue;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.KeyValueCodec;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowHashJoinIndex;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowHashTable;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowList;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowQueue;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowSet;
import org.apache.ignite.internal.type.NativeType;

public interface RowStorageFactory<RowT>
extends ManuallyCloseable {
    public RowList<RowT> list(RowHandler.RowFactory<RowT> var1);

    public RowList<RowT> list(RowHandler.RowFactory<RowT> var1, int var2);

    default public RowList<RowT> emptyList() {
        return ImmutableRowList.EMPTY_LIST;
    }

    default public RowQueue<RowT> emptyQueue() {
        return ImmutableRowQueue.EMPTY_QUEUE;
    }

    public RowQueue<RowT> queue(RowHandler.RowFactory<RowT> var1, int var2);

    public RowQueue<RowT> priorityQueue(RowHandler.RowFactory<RowT> var1, Comparator<RowT> var2, Comparator<ByteBuffer> var3);

    public RowQueue<RowT> boundedPriorityQueue(RowHandler.RowFactory<RowT> var1, int var2, Comparator<RowT> var3, Comparator<ByteBuffer> var4);

    public <K, V> RowHashTable<K, V> hashTable(KeyValueCodec<K, V> var1);

    public <E> RowSet<E> hashSet(Class<E> var1, NativeType var2);

    public <E> RowSet<E> hashSet(KeyValueCodec<E, Void> var1);

    public RowHashJoinIndex<RowT, RowT> hashJoinIndex(RowHandler.RowFactory<RowT> var1, int[] var2);

    public void close() throws Exception;

    default public void spillToDisk() {
    }
}

