/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.CatchBlock;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.exp.CorrelatesBuilder;
import org.apache.ignite.internal.sql.engine.exec.exp.ExpressionFactoryImpl;
import org.apache.ignite.internal.sql.engine.exec.exp.NoOpFieldGetter;
import org.apache.ignite.internal.sql.engine.exec.exp.RexToLixTranslator;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlScalar;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.IgniteMethod;
import org.apache.ignite.internal.sql.engine.util.Primitives;
import org.apache.ignite.internal.sql.engine.util.RexUtils;
import org.apache.ignite.internal.sql.engine.util.cache.Cache;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;

class ScalarImplementor {
    private final RelDataType emptyType;
    private final Cache<String, Object> cache;
    private final RexBuilder rexBuilder;
    private final JavaTypeFactory typeFactory;
    private final SqlConformance conformance;

    ScalarImplementor(Cache<String, Object> cache, RexBuilder rexBuilder, JavaTypeFactory typeFactory, SqlConformance conformance) {
        this.cache = cache;
        this.rexBuilder = rexBuilder;
        this.typeFactory = typeFactory;
        this.conformance = conformance;
        this.emptyType = new RelDataTypeFactory.Builder((RelDataTypeFactory)typeFactory).build();
    }

    <T> SqlScalar<T> implement(final RexNode scalarExpression) {
        if (scalarExpression instanceof RexLiteral) {
            final Class javaType = Primitives.wrap((Class)this.typeFactory.getJavaClass(scalarExpression.getType()));
            return new SqlScalar<T>(){

                @Override
                public <RowT> T get(ExecutionContext<RowT> context) {
                    return RexUtils.literalValue(context, (RexLiteral)scalarExpression, javaType);
                }
            };
        }
        String digest = ExpressionFactoryImpl.digest(SqlScalar.class, List.of(scalarExpression), null);
        Cache cache = (Cache)Commons.cast(this.cache);
        return cache.get(digest, key -> this.implementInternal(scalarExpression));
    }

    private <T> SqlScalar<T> implementInternal(RexNode scalarValue) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(this.emptyType, this.rexBuilder);
        programBuilder.addProject(scalarValue, null);
        RexProgram program = programBuilder.getProgram();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression ctx = Expressions.parameter(ExecutionContext.class, (String)"ctx");
        Expression rowHandler = builder.append("hnd", (Expression)Expressions.call((Expression)ctx, (Method)IgniteMethod.CONTEXT_ROW_HANDLER.method(), (Expression[])new Expression[0]));
        Function1<String, RexToLixTranslator.InputGetter> correlates = scalarValue instanceof RexDynamicParam ? null : new CorrelatesBuilder(builder, (Expression)ctx, rowHandler).build(List.of(scalarValue));
        List<Expression> projects = RexToLixTranslator.translateProjects(program, this.typeFactory, this.conformance, builder, null, null, (Expression)ctx, NoOpFieldGetter.INSTANCE, correlates);
        assert (projects.size() == 1);
        builder.add(projects.get(0));
        ParameterExpression ex = Expressions.parameter((int)0, Exception.class, (String)"e");
        NewExpression sqlException = Expressions.new_(SqlException.class, (Expression[])new Expression[]{Expressions.constant((Object)ErrorGroups.Sql.RUNTIME_ERR), ex});
        BlockBuilder tryCatchBlock = new BlockBuilder();
        tryCatchBlock.add((Statement)Expressions.tryCatch((Statement)builder.toBlock(), (CatchBlock[])new CatchBlock[]{Expressions.catch_((ParameterExpression)ex, (Statement)Expressions.throw_((Expression)sqlException))}));
        List<ParameterExpression> params = List.of(ctx);
        MethodDeclaration declaration = Expressions.methodDecl((int)1, Object.class, (String)"get", params, (BlockStatement)tryCatchBlock.toBlock());
        Class clazz = (Class)Commons.cast(SqlScalar.class);
        String body = Expressions.toString(List.of(declaration), (String)"\n", (boolean)false);
        return (SqlScalar)Commons.compile(clazz, body);
    }
}

