/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp;

import java.util.List;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.exec.exp.ComparatorImplementor;
import org.apache.ignite.internal.sql.engine.exec.exp.ExpressionFactory;
import org.apache.ignite.internal.sql.engine.exec.exp.JoinPredicateImplementor;
import org.apache.ignite.internal.sql.engine.exec.exp.JoinProjectionImplementor;
import org.apache.ignite.internal.sql.engine.exec.exp.PredicateImplementor;
import org.apache.ignite.internal.sql.engine.exec.exp.ProjectionImplementor;
import org.apache.ignite.internal.sql.engine.exec.exp.RowProviderImplementor;
import org.apache.ignite.internal.sql.engine.exec.exp.ScalarImplementor;
import org.apache.ignite.internal.sql.engine.exec.exp.SearchBoundsImplementor;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlComparator;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlJoinPredicate;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlJoinProjection;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlPredicate;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlProjection;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlRangeConditionsProvider;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlRowProvider;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlScalar;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AccumulatorsFactory;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.cache.Cache;
import org.apache.ignite.internal.sql.engine.util.cache.CacheFactory;
import org.jetbrains.annotations.Nullable;

public class ExpressionFactoryImpl
implements ExpressionFactory {
    private static final IgniteTypeFactory TYPE_FACTORY = Commons.typeFactory();
    private static final RexBuilder REX_BUILDER = Commons.rexBuilder();
    private static final SqlConformance SQL_CONFORMANCE = Commons.FRAMEWORK_CONFIG.getParserConfig().conformance();
    private final IgniteTypeFactory typeFactory;
    private final ComparatorImplementor comparatorImplementor;
    private final JoinPredicateImplementor joinPredicateImplementor;
    private final PredicateImplementor predicateImplementor;
    private final JoinProjectionImplementor joinProjectionImplementor;
    private final ProjectionImplementor projectionImplementor;
    private final RowProviderImplementor rowProviderImplementor;
    private final ScalarImplementor scalarImplementor;
    private final SearchBoundsImplementor searchBoundsImplementor;

    public ExpressionFactoryImpl(IgniteTypeFactory typeFactory, int cacheSize, CacheFactory cacheFactory) {
        this.typeFactory = typeFactory;
        Cache<String, Object> cache = cacheFactory.create(cacheSize);
        this.comparatorImplementor = new ComparatorImplementor();
        this.joinPredicateImplementor = new JoinPredicateImplementor(cache, REX_BUILDER, (JavaTypeFactory)TYPE_FACTORY, SQL_CONFORMANCE);
        this.predicateImplementor = new PredicateImplementor(cache, REX_BUILDER, (JavaTypeFactory)TYPE_FACTORY, SQL_CONFORMANCE);
        this.joinProjectionImplementor = new JoinProjectionImplementor(cache, REX_BUILDER, (JavaTypeFactory)TYPE_FACTORY, SQL_CONFORMANCE);
        this.projectionImplementor = new ProjectionImplementor(cache, REX_BUILDER, (JavaTypeFactory)TYPE_FACTORY, SQL_CONFORMANCE);
        this.rowProviderImplementor = new RowProviderImplementor(cache, REX_BUILDER, (JavaTypeFactory)TYPE_FACTORY, SQL_CONFORMANCE);
        this.scalarImplementor = new ScalarImplementor(cache, REX_BUILDER, (JavaTypeFactory)TYPE_FACTORY, SQL_CONFORMANCE);
        this.searchBoundsImplementor = new SearchBoundsImplementor();
    }

    @Override
    public <RowT> AccumulatorsFactory<RowT> accumulatorsFactory(AggregateType type, List<AggregateCall> calls, RelDataType rowType) {
        assert (!calls.isEmpty());
        return new AccumulatorsFactory(type, this.typeFactory, calls, rowType);
    }

    @Override
    public SqlComparator comparator(RelCollation collation) {
        return this.comparatorImplementor.implement(collation);
    }

    @Override
    public SqlComparator comparator(List<RelFieldCollation> left, List<RelFieldCollation> right, ImmutableBitSet equalNulls) {
        return this.comparatorImplementor.implement(left, right, equalNulls);
    }

    @Override
    public SqlPredicate predicate(RexNode filter, RelDataType rowType) {
        return this.predicateImplementor.implement(filter, rowType);
    }

    @Override
    public SqlJoinPredicate joinPredicate(RexNode filter, RelDataType rowType, int firstRowSize) {
        return this.joinPredicateImplementor.implement(filter, rowType, firstRowSize);
    }

    @Override
    public SqlProjection project(List<RexNode> projects, RelDataType inputRowType) {
        return this.projectionImplementor.implement(projects, inputRowType);
    }

    @Override
    public SqlJoinProjection joinProject(List<RexNode> projects, RelDataType rowType, int firstRowSize) {
        return this.joinProjectionImplementor.implement(projects, rowType, firstRowSize);
    }

    @Override
    public SqlRowProvider rowSource(List<RexNode> values) {
        return this.rowProviderImplementor.implement(values);
    }

    @Override
    public <T> SqlScalar<T> scalar(RexNode node) {
        return this.scalarImplementor.implement(node);
    }

    @Override
    public SqlRangeConditionsProvider ranges(List<SearchBounds> searchBounds, RelDataType rowType, @Nullable SqlComparator comparator) {
        return this.searchBoundsImplementor.implement(searchBounds, rowType, comparator, this::rowSource, this::scalar);
    }

    static String digest(Class<?> clazz, List<? extends RexNode> nodes, @Nullable RelDataType type) {
        return ExpressionFactoryImpl.digest(clazz, nodes, type, null);
    }

    static String digest(Class<?> clazz, List<? extends RexNode> nodes, @Nullable RelDataType type, @Nullable Object additionalContext) {
        final StringBuilder b = new StringBuilder(clazz.getSimpleName());
        b.append('[');
        for (int i = 0; i < nodes.size(); ++i) {
            if (i > 0) {
                b.append(';');
            }
            RexNode node = nodes.get(i);
            b.append(node);
            if (node == null) continue;
            b.append(':').append(node.getType().getFullTypeString());
            new RexShuttle(){

                public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
                    b.append(", fldIdx=").append(fieldAccess.getField().getIndex());
                    return super.visitFieldAccess(fieldAccess);
                }

                public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
                    b.append(", paramType=").append(dynamicParam.getType().getFullTypeString());
                    return super.visitDynamicParam(dynamicParam);
                }
            }.apply(node);
        }
        b.append(']');
        if (type != null) {
            b.append(':').append(type.getFullTypeString());
        }
        if (additionalContext != null) {
            b.append(',').append(additionalContext);
        }
        return b.toString();
    }
}

