/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.jetbrains.annotations.Nullable;

public class TxAttributes {
    private static final TxAttributes DUMMY = new TxAttributes(new UUID(0L, 0L), (ZonePartitionId)null, new UUID(0L, 0L));
    private final UUID id;
    private final UUID coordinatorId;
    private final boolean readOnly;
    @Nullable
    private final HybridTimestamp readTimestamp;
    @Nullable
    private final ZonePartitionId commitPartition;

    public static TxAttributes fromTx(InternalTransaction tx) {
        if (tx.isReadOnly()) {
            HybridTimestamp readTime = tx.readTimestamp();
            if (readTime == null) {
                throw new IllegalArgumentException("Read time is not set for RO transaction");
            }
            return new TxAttributes(tx.id(), readTime, tx.coordinatorId());
        }
        return new TxAttributes(tx.id(), tx.commitPartition(), tx.coordinatorId());
    }

    public static TxAttributes dummy() {
        return DUMMY;
    }

    private TxAttributes(UUID id, HybridTimestamp readTimestamp, UUID coordinatorId) {
        this.id = Objects.requireNonNull(id, "id");
        this.readTimestamp = Objects.requireNonNull(readTimestamp, "timestamp");
        this.coordinatorId = Objects.requireNonNull(coordinatorId, "tx coordinator id");
        this.readOnly = true;
        this.commitPartition = null;
    }

    private TxAttributes(UUID id, @Nullable ZonePartitionId commitPartitionId, UUID coordinatorId) {
        this.id = Objects.requireNonNull(id, "id");
        this.commitPartition = commitPartitionId;
        this.coordinatorId = Objects.requireNonNull(coordinatorId, "tx coordinator id");
        this.readOnly = false;
        this.readTimestamp = null;
    }

    @Nullable
    public ZonePartitionId commitPartition() {
        return this.commitPartition;
    }

    public UUID id() {
        return this.id;
    }

    @Nullable
    public HybridTimestamp time() {
        return this.readTimestamp;
    }

    public UUID coordinatorId() {
        return this.coordinatorId;
    }

    public boolean readOnly() {
        return this.readOnly;
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

