/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.UUID;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.InternalTuple;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.type.DecimalNativeType;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.type.StructNativeType;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class SqlRowHandler
implements RowHandler<RowWrapper> {
    public static final RowHandler<RowWrapper> INSTANCE = new SqlRowHandler();
    private static final ObjectsArrayRowWrapper EMPTY_ROW = new ObjectsArrayRowWrapper(NativeTypes.rowBuilder().build(), new Object[0]);

    private SqlRowHandler() {
    }

    @Override
    @Nullable
    public Object get(int field, RowWrapper row) {
        return row.get(field);
    }

    @Override
    public boolean isNull(int field, RowWrapper row) {
        return row.isNull(field);
    }

    @Override
    public int columnCount(RowWrapper row) {
        return row.columnsCount();
    }

    @Override
    public String toString(RowWrapper row) {
        IgniteStringBuilder buf = new IgniteStringBuilder("Row[");
        int maxIdx = this.columnCount(row) - 1;
        for (int i = 0; i <= maxIdx; ++i) {
            buf.app(row.get(i));
            if (i == maxIdx) continue;
            buf.app(", ");
        }
        return buf.app(']').toString();
    }

    @Override
    public BinaryTuple toBinaryTuple(RowWrapper row) {
        return row.toBinaryTuple();
    }

    @Override
    public Class<RowWrapper> rowType() {
        return RowWrapper.class;
    }

    @Override
    public RowHandler.RowFactory<RowWrapper> factory(final StructNativeType rowSchema) {
        final int schemaLen = rowSchema.fields().size();
        return new RowHandler.RowFactory<RowWrapper>(){

            @Override
            public RowHandler<RowWrapper> handler() {
                return SqlRowHandler.this;
            }

            @Override
            public RowHandler.RowBuilder<RowWrapper> rowBuilder() {
                return new RowBuilderImpl(rowSchema);
            }

            @Override
            public RowWrapper create() {
                return this.create(new Object[schemaLen]);
            }

            @Override
            public RowWrapper create(Object ... fields) {
                assert (fields.length == rowSchema.fields().size());
                return new ObjectsArrayRowWrapper(rowSchema, fields);
            }

            @Override
            public RowWrapper create(InternalTuple tuple) {
                assert (schemaLen == tuple.elementCount()) : IgniteStringFormatter.format((String)"schemaLen={}, tupleSize={}", (Object[])new Object[]{schemaLen, tuple.elementCount()});
                return new BinaryTupleRowWrapper(rowSchema, tuple);
            }

            @Override
            public int columnsCount() {
                return schemaLen;
            }

            @Override
            public StructNativeType rowSchema() {
                return rowSchema;
            }

            @Override
            public RowWrapper map(RowWrapper row, int[] mapping) {
                assert (mapping.length == rowSchema.fields().size());
                Object[] fields = new Object[mapping.length];
                for (int i = 0; i < mapping.length; ++i) {
                    fields[i] = row.get(mapping[i]);
                }
                return new ObjectsArrayRowWrapper(rowSchema, fields);
            }
        };
    }

    public static abstract class RowWrapper {
        private int refCnt;

        public abstract int columnsCount();

        @Nullable
        public abstract Object get(int var1);

        abstract boolean isNull(int var1);

        abstract BinaryTuple toBinaryTuple();

        public int acquire() {
            ++this.refCnt;
            return this.refCnt;
        }

        public int release() {
            assert (this.refCnt > 0) : "Ref count is zero: " + this.getClass().getSimpleName() + "#" + System.identityHashCode(this);
            --this.refCnt;
            return this.refCnt;
        }
    }

    public static class ObjectsArrayRowWrapper
    extends RowWrapper {
        private final StructNativeType rowType;
        private final Object[] row;

        ObjectsArrayRowWrapper(StructNativeType rowType, Object[] row) {
            assert (row.length == rowType.fields().size());
            this.rowType = rowType;
            this.row = row;
        }

        @Override
        public int columnsCount() {
            return this.row.length;
        }

        @Override
        @Nullable
        public Object get(int field) {
            return this.row[field];
        }

        @Override
        boolean isNull(int field) {
            return this.row[field] == null;
        }

        @Override
        BinaryTuple toBinaryTuple() {
            Object value;
            int estimatedSize = 0;
            boolean exactEstimate = true;
            for (int i = 0; i < this.row.length; ++i) {
                NativeType nativeType = ((StructNativeType.Field)this.rowType.fields().get(i)).type();
                if (nativeType.spec() == ColumnType.NULL) {
                    assert (this.row[i] == null);
                    continue;
                }
                value = this.row[i];
                if (value == null) continue;
                if (nativeType.fixedLength()) {
                    estimatedSize += nativeType.sizeInBytes();
                    continue;
                }
                if (value instanceof String) {
                    estimatedSize += ((String)value).length();
                    exactEstimate = false;
                    continue;
                }
                if (value instanceof ByteString) {
                    estimatedSize += ((ByteString)value).length();
                    continue;
                }
                assert (value instanceof BigDecimal) : "unexpected value " + value.getClass();
                exactEstimate = false;
            }
            BinaryTupleBuilder tupleBuilder = new BinaryTupleBuilder(this.row.length, estimatedSize, exactEstimate);
            for (int i = 0; i < this.row.length; ++i) {
                value = this.row[i];
                ObjectsArrayRowWrapper.appendValue(tupleBuilder, ((StructNativeType.Field)this.rowType.fields().get(i)).type(), value);
            }
            return new BinaryTuple(this.row.length, tupleBuilder.build());
        }

        private static void appendValue(BinaryTupleBuilder builder, NativeType type, @Nullable Object value) {
            if (value == null) {
                builder.appendNull();
                return;
            }
            value = TypeUtils.fromInternal(value, type.spec());
            assert (value != null) : type;
            switch (type.spec()) {
                case BOOLEAN: {
                    builder.appendBoolean(((Boolean)value).booleanValue());
                    break;
                }
                case INT8: {
                    builder.appendByte(((Byte)value).byteValue());
                    break;
                }
                case INT16: {
                    builder.appendShort(((Short)value).shortValue());
                    break;
                }
                case INT32: {
                    builder.appendInt(((Integer)value).intValue());
                    break;
                }
                case INT64: {
                    builder.appendLong(((Long)value).longValue());
                    break;
                }
                case FLOAT: {
                    builder.appendFloat(((Float)value).floatValue());
                    break;
                }
                case DOUBLE: {
                    builder.appendDouble(((Double)value).doubleValue());
                    break;
                }
                case DECIMAL: {
                    builder.appendDecimalNotNull((BigDecimal)value, ((DecimalNativeType)type).scale());
                    break;
                }
                case UUID: {
                    builder.appendUuidNotNull((UUID)value);
                    break;
                }
                case BYTE_ARRAY: {
                    builder.appendBytesNotNull((byte[])value);
                    break;
                }
                case STRING: {
                    builder.appendStringNotNull((String)value);
                    break;
                }
                case DATE: {
                    builder.appendDateNotNull((LocalDate)value);
                    break;
                }
                case TIME: {
                    builder.appendTimeNotNull((LocalTime)value);
                    break;
                }
                case DATETIME: {
                    builder.appendDateTimeNotNull((LocalDateTime)value);
                    break;
                }
                case TIMESTAMP: {
                    builder.appendTimestampNotNull((Instant)value);
                    break;
                }
                case DURATION: {
                    builder.appendDuration((Duration)value);
                    break;
                }
                case PERIOD: {
                    builder.appendPeriod((Period)value);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown type " + type);
                }
            }
        }
    }

    private static class RowBuilderImpl
    implements RowHandler.RowBuilder<RowWrapper> {
        private final int schemaLen;
        private final StructNativeType rowType;
        Object[] data;
        int fieldIdx;

        RowBuilderImpl(StructNativeType rowType) {
            this.rowType = rowType;
            this.schemaLen = rowType.fields().size();
            this.fieldIdx = 0;
        }

        @Override
        public RowHandler.RowBuilder<RowWrapper> addField(Object value) {
            if (this.fieldIdx == 0 && this.data == null) {
                this.data = new Object[this.schemaLen];
            }
            this.checkIndex();
            this.data[this.fieldIdx++] = value;
            return this;
        }

        @Override
        public RowWrapper build() {
            this.checkState();
            return this.rowType.fields().isEmpty() ? EMPTY_ROW : new ObjectsArrayRowWrapper(this.rowType, this.data);
        }

        @Override
        public void reset() {
            this.data = null;
            this.fieldIdx = 0;
        }

        private void checkState() {
            if (this.schemaLen != 0 && this.data == null) {
                throw new IllegalStateException("Row has not been initialised");
            }
            if (this.fieldIdx != this.schemaLen) {
                throw new IllegalStateException(IgniteStringFormatter.format((String)"Row has not been fully built. Index: {}, fields: {}", (Object[])new Object[]{this.fieldIdx, this.schemaLen}));
            }
        }

        private void checkIndex() {
            if (this.fieldIdx >= this.schemaLen) {
                throw new IllegalStateException(IgniteStringFormatter.format((String)"Field index is out of bounds. Index: {}, fields: {}", (Object[])new Object[]{this.fieldIdx, this.schemaLen}));
            }
        }
    }

    public static class BinaryTupleRowWrapper
    extends RowWrapper {
        private final StructNativeType rowType;
        private final InternalTuple tuple;

        BinaryTupleRowWrapper(StructNativeType rowType, InternalTuple tuple) {
            this.rowType = rowType;
            this.tuple = tuple;
        }

        @Override
        public int columnsCount() {
            return this.tuple.elementCount();
        }

        public InternalTuple tuple() {
            return this.tuple;
        }

        @Override
        @Nullable
        public Object get(int field) {
            NativeType nativeType = ((StructNativeType.Field)this.rowType.fields().get(field)).type();
            if (nativeType.spec() == ColumnType.NULL) {
                return null;
            }
            Object value = Commons.readValue(this.tuple, nativeType, field);
            if (value == null) {
                return null;
            }
            return TypeUtils.toInternal(value, nativeType.spec());
        }

        @Override
        boolean isNull(int field) {
            return this.tuple.hasNullValue(field);
        }

        @Override
        BinaryTuple toBinaryTuple() {
            if (this.tuple instanceof BinaryTuple) {
                return (BinaryTuple)this.tuple;
            }
            return new BinaryTuple(this.tuple.elementCount(), this.tuple.byteBuffer());
        }
    }
}

