/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.metrics;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.internal.metrics.LongGauge;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.sql.metrics.SqlMemoryMetricsProvider;

public class SqlMemoryMetricSource
extends AbstractMetricSource<Holder> {
    public static final String NAME = "sql.memory";
    public static final String METRIC_RESERVED = "Reserved";
    public static final String METRIC_MAX_RESERVED = "MaxReserved";
    public static final String METRIC_NODE_LIMIT = "Limit";
    public static final String METRIC_STATEMENT_LIMIT = "StatementLimit";
    private final LongSupplier nodeQuotaSizeSupplier;
    private final LongSupplier statementQuotaSizeSupplier;
    private final AtomicReference<? extends SqlMemoryMetricsProvider> memoryMetricsProvider;

    public SqlMemoryMetricSource(LongSupplier nodeQuotaSizeSupplier, LongSupplier statementQuotaSizeSupplier, AtomicReference<? extends SqlMemoryMetricsProvider> memoryMetricsProvider) {
        super(NAME);
        this.nodeQuotaSizeSupplier = nodeQuotaSizeSupplier;
        this.statementQuotaSizeSupplier = statementQuotaSizeSupplier;
        this.memoryMetricsProvider = memoryMetricsProvider;
    }

    protected Holder createHolder() {
        return new Holder();
    }

    protected class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final LongGauge reserved = new LongGauge("Reserved", "Current memory usage by SQL (bytes)", () -> SqlMemoryMetricSource.this.memoryMetricsProvider.get().reserved());
        private final LongGauge maxReserved = new LongGauge("MaxReserved", "Maximum memory usage by SQL so far (bytes)", () -> SqlMemoryMetricSource.this.memoryMetricsProvider.get().maxReserved());
        private final LongGauge nodeQuotaSize;
        private final LongGauge statementQuotaSize;

        protected Holder() {
            this.nodeQuotaSize = new LongGauge(SqlMemoryMetricSource.METRIC_NODE_LIMIT, "SQL memory limit (bytes)", SqlMemoryMetricSource.this.nodeQuotaSizeSupplier);
            this.statementQuotaSize = new LongGauge(SqlMemoryMetricSource.METRIC_STATEMENT_LIMIT, "Memory limit per SQL statement (bytes)", SqlMemoryMetricSource.this.statementQuotaSizeSupplier);
        }

        public Iterable<Metric> metrics() {
            return List.of(this.reserved, this.maxReserved, this.nodeQuotaSize, this.statementQuotaSize);
        }
    }
}

