/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleCommon;
import org.apache.ignite.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite.internal.lang.InternalTuple;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.InternalTupleEx;
import org.apache.ignite.internal.sql.engine.util.AbstractProjectedTuple;

public class ProjectedTuple
extends AbstractProjectedTuple {
    public ProjectedTuple(InternalTupleEx delegate, int[] projection) {
        super((InternalTuple)delegate, projection);
    }

    @Override
    protected void normalize() {
        BinaryTupleBuilder builder;
        if (this.delegate instanceof BinaryTuple) {
            var stats = new BinaryTupleParser.Sink(){
                int estimatedValueSize = 0;

                public void nextElement(int index, int begin, int end) {
                    this.estimatedValueSize += end - begin;
                }
            };
            BinaryTuple binaryTuple = (BinaryTuple)this.delegate;
            for (int columnIndex : this.projection) {
                binaryTuple.fetch(columnIndex, stats);
            }
            builder = new BinaryTupleBuilder(this.projection.length, stats.estimatedValueSize, true);
        } else {
            builder = new BinaryTupleBuilder(this.projection.length, 32, false);
        }
        assert (this.delegate instanceof InternalTupleEx);
        InternalTupleEx delegate0 = (InternalTupleEx)this.delegate;
        int[] newProjection = new int[this.projection.length];
        for (int i = 0; i < this.projection.length; ++i) {
            delegate0.copyValue(builder, this.projection[i]);
            newProjection[i] = i;
        }
        this.delegate = new BinaryTuple(this.projection.length, builder.build());
        this.projection = newProjection;
    }

    @Override
    protected int normalizedSize() {
        if (!(this.delegate instanceof BinaryTuple)) {
            this.normalize();
        }
        var stats = new BinaryTupleParser.Sink(){
            int estimatedValueSize = 0;

            public void nextElement(int index, int begin, int end) {
                this.estimatedValueSize += end - begin;
            }
        };
        BinaryTuple binaryTuple = (BinaryTuple)this.delegate;
        for (int columnIndex : this.projection) {
            binaryTuple.fetch(columnIndex, stats);
        }
        int tableEntrySize = BinaryTupleCommon.flagsToEntrySize((byte)BinaryTupleCommon.valueSizeToFlags((long)stats.estimatedValueSize));
        return stats.estimatedValueSize + 1 + this.projection.length * tableEntrySize;
    }

    private static boolean contains(int[] array, int v) {
        for (int e : array) {
            if (e != v) continue;
            return true;
        }
        return false;
    }
}

