/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.type;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.IntervalSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeSystem;
import org.apache.ignite.internal.sql.engine.util.IgniteCustomAssignmentsRules;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteTypeFactory
extends JavaTypeFactoryImpl {
    private static final SqlIntervalQualifier INTERVAL_QUALIFIER_YEAR_MONTH = new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO);
    private static final SqlIntervalQualifier INTERVAL_QUALIFIER_DAY_TIME = new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO);
    public static final IgniteTypeFactory INSTANCE = new IgniteTypeFactory((RelDataTypeSystem)IgniteTypeSystem.INSTANCE);
    private final Map<Class<?>, Supplier<RelDataType>> implementedJavaTypes = new IdentityHashMap();
    private final Charset charset;

    public IgniteTypeFactory(RelDataTypeSystem typeSystem) {
        super(typeSystem);
        this.implementedJavaTypes.put(LocalDate.class, () -> this.createTypeWithNullability(this.createSqlType(SqlTypeName.DATE), true));
        this.implementedJavaTypes.put(LocalTime.class, () -> this.createTypeWithNullability(this.createSqlType(SqlTypeName.TIME), true));
        this.implementedJavaTypes.put(LocalDateTime.class, () -> this.createTypeWithNullability(this.createSqlType(SqlTypeName.TIMESTAMP), true));
        this.implementedJavaTypes.put(Instant.class, () -> this.createTypeWithNullability(this.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE), true));
        this.implementedJavaTypes.put(Duration.class, () -> this.createTypeWithNullability(this.createSqlIntervalType(INTERVAL_QUALIFIER_DAY_TIME), true));
        this.implementedJavaTypes.put(Period.class, () -> this.createTypeWithNullability(this.createSqlIntervalType(INTERVAL_QUALIFIER_YEAR_MONTH), true));
        this.charset = SqlUtil.translateCharacterSetName((String)Charset.defaultCharset().name()) != null ? Charset.defaultCharset() : StandardCharsets.UTF_8;
    }

    public RelDataType createSqlType(SqlTypeName typeName, int precision) {
        IgniteTypeFactory.assertBasicType(typeName);
        if (typeName.allowsScale()) {
            return this.createSqlType(typeName, precision, this.typeSystem.getDefaultScale(typeName));
        }
        assert (precision >= 0 || precision == -1);
        BasicSqlType newType = precision == -1 ? new BasicSqlType(this.typeSystem, typeName) : new BasicSqlType(this.typeSystem, typeName, precision);
        newType = SqlTypeUtil.addCharsetAndCollation((RelDataType)newType, (RelDataTypeFactory)this);
        return this.canonize((RelDataType)newType);
    }

    public RelDataType createSqlType(SqlTypeName typeName, int precision, int scale) {
        IgniteTypeFactory.assertBasicType(typeName);
        assert (precision >= 0 || precision == -1);
        assert (scale >= 0 || scale == Integer.MIN_VALUE);
        BasicSqlType newType = new BasicSqlType(this.typeSystem, typeName, precision, scale);
        newType = SqlTypeUtil.addCharsetAndCollation((RelDataType)newType, (RelDataTypeFactory)this);
        return this.canonize((RelDataType)newType);
    }

    private static void assertBasicType(SqlTypeName typeName) {
        assert (typeName != null);
        assert (typeName != SqlTypeName.MULTISET) : "use createMultisetType() instead";
        assert (typeName != SqlTypeName.ARRAY) : "use createArrayType() instead";
        assert (typeName != SqlTypeName.MAP) : "use createMapType() instead";
        assert (typeName != SqlTypeName.ROW) : "use createStructType() instead";
        assert (!SqlTypeName.INTERVAL_TYPES.contains(typeName)) : "use createSqlIntervalType() instead";
    }

    public Type getJavaClass(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass();
        }
        if (type instanceof BasicSqlType || type instanceof IntervalSqlType) {
            switch (type.getSqlTypeName()) {
                case VARCHAR: 
                case CHAR: {
                    return String.class;
                }
                case DATE: 
                case TIME: 
                case TIME_WITH_LOCAL_TIME_ZONE: 
                case INTEGER: 
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: {
                    return type.isNullable() ? Integer.class : Integer.TYPE;
                }
                case TIMESTAMP: 
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
                case BIGINT: 
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    return type.isNullable() ? Long.class : Long.TYPE;
                }
                case SMALLINT: {
                    return type.isNullable() ? Short.class : Short.TYPE;
                }
                case TINYINT: {
                    return type.isNullable() ? Byte.class : Byte.TYPE;
                }
                case DECIMAL: {
                    return BigDecimal.class;
                }
                case BOOLEAN: {
                    return type.isNullable() ? Boolean.class : Boolean.TYPE;
                }
                case DOUBLE: {
                    return type.isNullable() ? Double.class : Double.TYPE;
                }
                case REAL: 
                case FLOAT: {
                    return type.isNullable() ? Float.class : Float.TYPE;
                }
                case BINARY: 
                case VARBINARY: {
                    return ByteString.class;
                }
                case GEOMETRY: {
                    throw new IllegalArgumentException("Type is not supported.");
                }
                case SYMBOL: {
                    return Enum.class;
                }
                case ANY: 
                case OTHER: {
                    return Object.class;
                }
                case NULL: {
                    return Void.class;
                }
                case UUID: {
                    return UUID.class;
                }
            }
        }
        switch (type.getSqlTypeName()) {
            case ROW: {
                return Object[].class;
            }
            case MAP: {
                return Map.class;
            }
            case ARRAY: 
            case MULTISET: {
                return List.class;
            }
        }
        return null;
    }

    public static NativeType relDataTypeToNative(RelDataType relType) {
        assert (relType instanceof BasicSqlType || relType instanceof IntervalSqlType) : "Not supported:" + relType;
        switch (relType.getSqlTypeName()) {
            case BOOLEAN: {
                return NativeTypes.BOOLEAN;
            }
            case TINYINT: {
                return NativeTypes.INT8;
            }
            case SMALLINT: {
                return NativeTypes.INT16;
            }
            case INTEGER: {
                return NativeTypes.INT32;
            }
            case BIGINT: {
                return NativeTypes.INT64;
            }
            case DECIMAL: {
                assert (relType.getPrecision() != -1);
                return NativeTypes.decimalOf((int)relType.getPrecision(), (int)relType.getScale());
            }
            case REAL: 
            case FLOAT: {
                return NativeTypes.FLOAT;
            }
            case DOUBLE: {
                return NativeTypes.DOUBLE;
            }
            case DATE: {
                return NativeTypes.DATE;
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return NativeTypes.time((int)IgniteTypeFactory.precisionOrDefault(relType));
            }
            case TIMESTAMP: {
                return NativeTypes.datetime((int)IgniteTypeFactory.precisionOrDefault(relType));
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return NativeTypes.timestamp((int)IgniteTypeFactory.precisionOrDefault(relType));
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                throw new IllegalArgumentException("Type is not supported yet: " + relType);
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                throw new IllegalArgumentException("Type is not supported yet:" + relType);
            }
            case VARCHAR: 
            case CHAR: {
                return relType.getPrecision() == -1 ? NativeTypes.stringOf((int)65536) : NativeTypes.stringOf((int)relType.getPrecision());
            }
            case BINARY: 
            case VARBINARY: {
                return relType.getPrecision() == -1 ? NativeTypes.blobOf((int)65536) : NativeTypes.blobOf((int)relType.getPrecision());
            }
            case UUID: {
                return NativeTypes.UUID;
            }
        }
        throw new IllegalArgumentException("Type is not supported: " + relType);
    }

    private static int precisionOrDefault(RelDataType type) {
        if (type.getPrecision() == -1) {
            return IgniteTypeSystem.INSTANCE.getDefaultPrecision(type.getSqlTypeName());
        }
        return type.getPrecision();
    }

    public Type getResultClass(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass();
        }
        if (type instanceof BasicSqlType || type instanceof IntervalSqlType) {
            switch (type.getSqlTypeName()) {
                case VARCHAR: 
                case CHAR: {
                    return String.class;
                }
                case DATE: {
                    return LocalDate.class;
                }
                case TIME: 
                case TIME_WITH_LOCAL_TIME_ZONE: {
                    return LocalTime.class;
                }
                case TIMESTAMP: {
                    return LocalDateTime.class;
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    return Instant.class;
                }
                case INTEGER: {
                    return type.isNullable() ? Integer.class : Integer.TYPE;
                }
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: {
                    return Period.class;
                }
                case BIGINT: {
                    return type.isNullable() ? Long.class : Long.TYPE;
                }
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    return Duration.class;
                }
                case SMALLINT: {
                    return type.isNullable() ? Short.class : Short.TYPE;
                }
                case TINYINT: {
                    return type.isNullable() ? Byte.class : Byte.TYPE;
                }
                case DECIMAL: {
                    return BigDecimal.class;
                }
                case BOOLEAN: {
                    return type.isNullable() ? Boolean.class : Boolean.TYPE;
                }
                case DOUBLE: {
                    return type.isNullable() ? Double.class : Double.TYPE;
                }
                case REAL: 
                case FLOAT: {
                    return type.isNullable() ? Float.class : Float.TYPE;
                }
                case BINARY: 
                case VARBINARY: {
                    return byte[].class;
                }
                case GEOMETRY: {
                    throw new IllegalArgumentException("Type is not supported.");
                }
                case SYMBOL: {
                    return Enum.class;
                }
                case ANY: 
                case OTHER: {
                    return Object.class;
                }
                case NULL: {
                    return Void.class;
                }
            }
        }
        switch (type.getSqlTypeName()) {
            case ROW: {
                return Object[].class;
            }
            case MAP: {
                return Map.class;
            }
            case ARRAY: 
            case MULTISET: {
                return List.class;
            }
        }
        return null;
    }

    private static int getPrecision(RelDataType dataType) {
        if (dataType.getPrecision() == -1) {
            return IgniteTypeSystem.INSTANCE.getDefaultPrecision(dataType.getSqlTypeName());
        }
        return dataType.getPrecision();
    }

    @Nullable
    public RelDataType leastRestrictive(List<RelDataType> types) {
        assert (types != null);
        assert (!types.isEmpty());
        if (types.size() == 1 || IgniteTypeFactory.allEquals(types)) {
            return (RelDataType)CollectionUtils.first(types);
        }
        boolean hasAnyType = false;
        boolean hasNullOrNullable = false;
        boolean hasUuidType = false;
        boolean hasBuiltInType = false;
        for (RelDataType type : types) {
            SqlTypeName sqlTypeName = type.getSqlTypeName();
            if (sqlTypeName == SqlTypeName.NULL) {
                hasNullOrNullable = true;
                continue;
            }
            if (type.isNullable()) {
                hasNullOrNullable = true;
            }
            if (sqlTypeName == SqlTypeName.ANY) {
                hasAnyType = true;
                continue;
            }
            if (sqlTypeName == SqlTypeName.UUID) {
                hasUuidType = true;
            }
            hasBuiltInType = true;
        }
        if (hasUuidType) {
            if (!TypeUtils.typeFamiliesAreCompatible((RelDataTypeFactory)this, types)) {
                return null;
            }
            RelDataType returnType = this.createSqlType(SqlTypeName.UUID);
            if (hasNullOrNullable) {
                returnType = this.createTypeWithNullability(returnType, true);
            }
            return returnType;
        }
        RelDataType resultTimestampType = this.leastRestrictiveBetweenTimestampTypes(types, hasNullOrNullable);
        if (resultTimestampType != null) {
            return resultTimestampType;
        }
        RelDataType resultType = this.leastRestrictive(types, IgniteCustomAssignmentsRules.instance());
        if (resultType == null) {
            return null;
        }
        if (resultType.getSqlTypeName() != SqlTypeName.ANY) {
            if (!TypeUtils.typeFamiliesAreCompatible((RelDataTypeFactory)this, types)) {
                return null;
            }
            return resultType;
        }
        assert (resultType instanceof BasicSqlType) : "leastRestrictive is expected to return a new instance of a type: " + resultType;
        if (hasAnyType && hasBuiltInType) {
            return resultType;
        }
        return null;
    }

    @Nullable
    private RelDataType leastRestrictiveBetweenTimestampTypes(List<RelDataType> types, boolean hasNullOrNullable) {
        RelDataType firstType = null;
        boolean nullable = hasNullOrNullable;
        for (RelDataType t : types) {
            int rp;
            int lp;
            if (t.getSqlTypeName() == SqlTypeName.NULL) continue;
            if (!TypeUtils.isTimestamp(t.getSqlTypeName())) {
                return null;
            }
            if (firstType == null) {
                firstType = t;
                if (!t.isNullable()) continue;
                nullable = true;
                continue;
            }
            RelDataType leftType = firstType;
            RelDataType rightType = t;
            if (t.isNullable()) {
                nullable = true;
            }
            if (leftType.getSqlTypeName() == SqlTypeName.TIMESTAMP && rightType.getSqlTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
                lp = IgniteTypeFactory.getPrecision(leftType);
                if (lp == (rp = IgniteTypeFactory.getPrecision(rightType))) continue;
                firstType = this.createSqlType(leftType.getSqlTypeName(), Math.max(lp, rp));
                continue;
            }
            if (rightType.getSqlTypeName() == SqlTypeName.TIMESTAMP && leftType.getSqlTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
                lp = IgniteTypeFactory.getPrecision(leftType);
                if (lp != (rp = IgniteTypeFactory.getPrecision(rightType))) {
                    firstType = this.createSqlType(rightType.getSqlTypeName(), Math.max(lp, rp));
                    continue;
                }
                firstType = rightType;
                continue;
            }
            lp = IgniteTypeFactory.getPrecision(leftType);
            rp = IgniteTypeFactory.getPrecision(rightType);
            if (rp <= lp) continue;
            firstType = rightType;
        }
        assert (firstType != null);
        if (firstType.isNullable() != nullable) {
            return this.createTypeWithNullability(firstType, nullable);
        }
        return firstType;
    }

    public Charset getDefaultCharset() {
        return this.charset;
    }

    public RelDataType toSql(RelDataType type) {
        Class clazz;
        Supplier<RelDataType> javaType;
        if (type instanceof RelDataTypeFactoryImpl.JavaType && (javaType = this.implementedJavaTypes.get(clazz = ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass())) != null) {
            return javaType.get();
        }
        return super.toSql(type);
    }

    public RelDataType createType(Type type) {
        if (this.implementedJavaTypes.containsKey(type)) {
            return this.createJavaType((Class)type);
        }
        return super.createType(type);
    }

    private static boolean allEquals(List<RelDataType> types) {
        assert (types.size() > 1);
        RelDataType first = (RelDataType)CollectionUtils.first(types);
        for (int i = 1; i < types.size(); ++i) {
            if (Objects.equals(first, types.get(i))) continue;
            return false;
        }
        return true;
    }
}

