/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.tx;

import java.util.concurrent.CompletableFuture;
import org.apache.calcite.sql.SqlNode;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.TxControlInsideExternalTxNotSupportedException;
import org.apache.ignite.internal.sql.engine.exec.TransactionalOperationTracker;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlCommitTransaction;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlStartTransaction;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlStartTransactionMode;
import org.apache.ignite.internal.sql.engine.tx.QueryTransactionContext;
import org.apache.ignite.internal.sql.engine.tx.QueryTransactionWrapper;
import org.apache.ignite.internal.sql.engine.tx.ScriptTransactionWrapperImpl;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.jetbrains.annotations.Nullable;

public class ScriptTransactionContext
implements QueryTransactionContext {
    private final QueryTransactionContext txContext;
    private final TransactionalOperationTracker txTracker;
    @Nullable
    private volatile ScriptTransactionWrapperImpl wrapper;
    private final LicenseFeatureChecker licenseFeatureChecker;

    public ScriptTransactionContext(QueryTransactionContext txContext, TransactionalOperationTracker txTracker, LicenseFeatureChecker licenseFeatureChecker) {
        this.txContext = txContext;
        this.txTracker = txTracker;
        this.licenseFeatureChecker = licenseFeatureChecker;
    }

    @Override
    public QueryTransactionWrapper getOrStartSqlManaged(boolean readOnly, boolean implicit, boolean cacheOnly) {
        ScriptTransactionWrapperImpl wrapper = this.wrapper;
        if (wrapper == null) {
            return this.txContext.getOrStartSqlManaged(readOnly, implicit, cacheOnly);
        }
        return wrapper;
    }

    @Override
    public void updateObservableTime(HybridTimestamp time) {
        this.txContext.updateObservableTime(time);
    }

    @Override
    @Nullable
    public QueryTransactionWrapper explicitTx() {
        QueryTransactionWrapper tx = this.wrapper;
        if (tx == null) {
            tx = this.txContext.explicitTx();
        }
        return tx;
    }

    public CompletableFuture<Void> handleControlStatement(SqlNode node) {
        this.licenseFeatureChecker.checkFeature(LicenseFeature.EXPLICIT_TRANSACTIONS);
        if (this.txContext.explicitTx() != null) {
            throw new TxControlInsideExternalTxNotSupportedException();
        }
        ScriptTransactionWrapperImpl txWrapper = this.wrapper;
        if (node instanceof IgniteSqlStartTransaction) {
            if (txWrapper != null) {
                throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, "Nested transactions are not supported.");
            }
            boolean readOnly = ((IgniteSqlStartTransaction)node).getMode() == IgniteSqlStartTransactionMode.READ_ONLY;
            InternalTransaction tx = this.txContext.getOrStartSqlManaged(readOnly, false, false).unwrap();
            this.wrapper = new ScriptTransactionWrapperImpl(tx, this.txTracker);
            return CompletableFutures.nullCompletedFuture();
        }
        assert (node instanceof IgniteSqlCommitTransaction) : node == null ? "null" : node.getClass().getName();
        if (txWrapper == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.wrapper = null;
        return txWrapper.commit();
    }

    public void registerCursorFuture(SqlQueryType queryType, CompletableFuture<AsyncSqlCursor<InternalSqlRow>> cursorFut) {
        ScriptTransactionWrapperImpl txWrapper;
        if (queryType.supportsTransactions() && (txWrapper = this.wrapper) != null) {
            txWrapper.registerCursorFuture(cursorFut);
        }
    }

    public void onError(Throwable t) {
        assert (t != null);
        QueryTransactionWrapper txWrapper = this.wrapper;
        if (txWrapper == null) {
            txWrapper = this.txContext.explicitTx();
        }
        if (txWrapper != null) {
            txWrapper.finalise(t);
        }
    }
}

