/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.trait;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteExchange;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteSort;
import org.apache.ignite.internal.sql.engine.rel.IgniteTrimExchange;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.trait.DistributionTraitDef;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.RelFactory;
import org.apache.ignite.internal.sql.engine.trait.TraitsAwareIgniteRel;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.table.QualifiedNameHelper;
import org.jetbrains.annotations.Nullable;

public class TraitUtils {
    private static final int TRAITS_COMBINATION_COMPLEXITY_LIMIT = 1024;

    @Nullable
    public static RelNode enforce(RelNode rel, RelTraitSet toTraits) {
        RelOptPlanner planner = rel.getCluster().getPlanner();
        RelTraitSet fromTraits = rel.getTraitSet();
        int size = Math.min(fromTraits.size(), toTraits.size());
        if (!fromTraits.satisfies(toTraits)) {
            RelNode old = null;
            for (int i = 0; rel != null && i < size; ++i) {
                RelTrait toTrait;
                RelTrait fromTrait = rel.getTraitSet().getTrait(i);
                if (fromTrait.satisfies(toTrait = toTraits.getTrait(i))) continue;
                if (old != null && old != rel) {
                    rel = planner.register(rel, old);
                }
                old = rel;
                rel = TraitUtils.convertTrait(planner, fromTrait, toTrait, rel);
                assert (rel == null || rel.getTraitSet().getTrait(i).satisfies(toTrait));
            }
            assert (rel == null || rel.getTraitSet().satisfies(toTraits));
        }
        return rel;
    }

    @Nullable
    private static RelNode convertTrait(RelOptPlanner planner, RelTrait fromTrait, RelTrait toTrait, RelNode rel) {
        assert (fromTrait.getTraitDef() == toTrait.getTraitDef());
        RelTraitDef converter = fromTrait.getTraitDef();
        if (rel.getConvention() != IgniteConvention.INSTANCE) {
            return null;
        }
        if (converter == RelCollationTraitDef.INSTANCE) {
            return TraitUtils.convertCollation(planner, (RelCollation)toTrait, rel);
        }
        if (converter == DistributionTraitDef.INSTANCE) {
            return TraitUtils.convertDistribution(planner, (IgniteDistribution)toTrait, rel);
        }
        return TraitUtils.convertOther(planner, converter, toTrait, rel);
    }

    @Nullable
    public static RelNode convertCollation(RelOptPlanner planner, RelCollation toTrait, RelNode rel) {
        RelCollation fromTrait = TraitUtils.collation(rel);
        if (fromTrait.satisfies((RelTrait)toTrait)) {
            return rel;
        }
        RelTraitSet traits = rel.getTraitSet().replace((RelTrait)toTrait);
        return new IgniteSort(rel.getCluster(), traits, rel, toTrait);
    }

    @Nullable
    public static RelNode convertDistribution(RelOptPlanner planner, IgniteDistribution toTrait, RelNode rel) {
        IgniteDistribution fromTrait = TraitUtils.distribution(rel);
        if (fromTrait.satisfies((RelTrait)toTrait)) {
            return rel;
        }
        RelTraitSet traits = rel.getTraitSet().replace((RelTrait)toTrait);
        if (fromTrait.getType() == RelDistribution.Type.BROADCAST_DISTRIBUTED && toTrait.getType() == RelDistribution.Type.HASH_DISTRIBUTED) {
            return new IgniteTrimExchange(rel.getCluster(), traits, rel, toTrait);
        }
        if (toTrait.getType() != RelDistribution.Type.SINGLETON && TraitUtils.collation(traits) != RelCollations.EMPTY) {
            return null;
        }
        return new IgniteExchange(rel.getCluster(), traits, RelOptRule.convert((RelNode)rel, (RelTraitSet)rel.getTraitSet()), toTrait);
    }

    @Nullable
    private static RelNode convertOther(RelOptPlanner planner, RelTraitDef converter, RelTrait toTrait, RelNode rel) {
        RelTrait fromTrait = rel.getTraitSet().getTrait(converter);
        if (fromTrait.satisfies(toTrait)) {
            return rel;
        }
        if (!converter.canConvert(planner, fromTrait, toTrait)) {
            return null;
        }
        return converter.convert(planner, rel, toTrait, true);
    }

    public static IgniteDistribution distribution(RelNode rel) {
        return rel instanceof IgniteRel ? ((IgniteRel)rel).distribution() : TraitUtils.distribution(rel.getTraitSet());
    }

    public static IgniteDistribution distribution(RelTraitSet traits) {
        return (IgniteDistribution)traits.getTrait((RelTraitDef)DistributionTraitDef.INSTANCE);
    }

    public static RelCollation collation(RelNode rel) {
        return rel instanceof IgniteRel ? ((IgniteRel)rel).collation() : TraitUtils.collation(rel.getTraitSet());
    }

    public static RelCollation collation(RelTraitSet traits) {
        return (RelCollation)traits.getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE);
    }

    public static RelInput changeTraits(RelInput input, RelTrait ... traits) {
        RelTraitSet traitSet = input.getTraitSet();
        for (RelTrait trait : traits) {
            traitSet = traitSet.replace(trait);
        }
        RelTraitSet traitSet0 = traitSet;
        return (RelInput)Proxy.newProxyInstance(TraitUtils.class.getClassLoader(), input.getClass().getInterfaces(), (p, m, a) -> {
            if ("getTraitSet".equals(m.getName())) {
                return traitSet0;
            }
            return m.invoke((Object)input, a);
        });
    }

    public static RelCollation projectCollation(RelCollation collation, List<RexNode> projects, RelDataType inputRowType) {
        if (collation.getFieldCollations().isEmpty()) {
            return RelCollations.EMPTY;
        }
        Mappings.TargetMapping mapping = RelOptUtil.permutationPushDownProject(projects, (RelDataType)inputRowType, (int)0, (int)0);
        return (RelCollation)collation.apply(mapping);
    }

    public static IgniteDistribution projectDistribution(IgniteDistribution distribution, List<RexNode> projects, RelDataType inputRowType) {
        if (distribution.getType() != RelDistribution.Type.HASH_DISTRIBUTED) {
            return distribution;
        }
        Mappings.TargetMapping mapping = TraitUtils.createProjectionMapping(inputRowType.getFieldCount(), projects);
        return distribution.apply(mapping);
    }

    public static Pair<RelTraitSet, List<RelTraitSet>> passThrough(TraitsAwareIgniteRel rel, RelTraitSet requiredTraits) {
        return TraitUtils.passThrough((Convention)IgniteConvention.INSTANCE, rel, requiredTraits);
    }

    public static Pair<RelTraitSet, List<RelTraitSet>> passThrough(Convention convention, TraitsAwareIgniteRel rel, RelTraitSet requiredTraits) {
        if (requiredTraits.getConvention() != convention || rel.getInputs().isEmpty()) {
            return null;
        }
        List<RelTraitSet> inTraits = Collections.nCopies(rel.getInputs().size(), rel.getCluster().traitSetOf((RelTrait)convention));
        PropagationContext context = new PropagationContext(Set.of(Pair.of((Object)requiredTraits, inTraits))).propagate((in, outs) -> TraitUtils.singletonListFromNullable(rel.passThroughCollation(in, outs)));
        if (TraitUtils.distributionEnabled((RelNode)rel)) {
            context = context.propagate((in, outs) -> TraitUtils.singletonListFromNullable(rel.passThroughDistribution(in, outs)));
        }
        List<Pair<RelTraitSet, List<RelTraitSet>>> traits = context.combinations();
        assert (traits.size() <= 1);
        return (Pair)CollectionUtils.first(traits);
    }

    public static List<RelNode> derive(TraitsAwareIgniteRel rel, List<List<RelTraitSet>> inTraits) {
        return TraitUtils.derive((Convention)IgniteConvention.INSTANCE, rel, inTraits);
    }

    public static List<RelNode> derive(Convention convention, TraitsAwareIgniteRel rel, List<List<RelTraitSet>> inTraits) {
        assert (!CollectionUtils.nullOrEmpty(inTraits));
        if (inTraits.stream().flatMap(Collection::stream).anyMatch(traitSet -> traitSet.getConvention() != convention)) {
            return List.of();
        }
        RelTraitSet outTraits = rel.getCluster().traitSetOf((RelTrait)convention);
        Set<Pair<RelTraitSet, List<RelTraitSet>>> combinations = TraitUtils.combinations(outTraits, inTraits);
        if (combinations.isEmpty()) {
            return List.of();
        }
        PropagationContext context = new PropagationContext(combinations).propagate(rel::deriveCollation);
        if (TraitUtils.distributionEnabled((RelNode)rel)) {
            context = context.propagate(rel::deriveDistribution);
        }
        return context.nodes(rel::createNode);
    }

    private static <T> List<T> singletonListFromNullable(@Nullable T elem) {
        return elem == null ? Collections.emptyList() : Collections.singletonList(elem);
    }

    private static Set<Pair<RelTraitSet, List<RelTraitSet>>> combinations(RelTraitSet outTraits, List<List<RelTraitSet>> inTraits) {
        long complexity;
        HashSet<Pair<RelTraitSet, List<RelTraitSet>>> out = new HashSet<Pair<RelTraitSet, List<RelTraitSet>>>();
        try {
            complexity = inTraits.stream().mapToInt(List::size).asLongStream().reduce(1L, Math::multiplyExact);
        }
        catch (ArithmeticException ignored) {
            complexity = Long.MAX_VALUE;
        }
        if (complexity <= 1024L) {
            TraitUtils.fillRecursive(outTraits, inTraits, out, new RelTraitSet[inTraits.size()], 0);
        } else {
            TraitUtils.fillRandom(outTraits, inTraits, out, 1024);
        }
        return out;
    }

    private static void fillRandom(RelTraitSet outTraits, List<List<RelTraitSet>> inTraits, Set<Pair<RelTraitSet, List<RelTraitSet>>> result, int count) {
        RelTraitSet[] combination = new RelTraitSet[inTraits.size()];
        long iteration = 0L;
        for (int attemptNo = 0; attemptNo < count; ++attemptNo) {
            int lastProcessed = -1;
            for (int i = 0; i < inTraits.size(); ++i) {
                List<RelTraitSet> traits = inTraits.get(i);
                RelTraitSet traitsCandidate = traits.get((int)(iteration % (long)traits.size()));
                ++iteration;
                if (traitsCandidate.getConvention() != IgniteConvention.INSTANCE) break;
                lastProcessed = i;
                combination[i] = traitsCandidate;
            }
            if (inTraits.size() - 1 != lastProcessed) continue;
            result.add((Pair<RelTraitSet, List<RelTraitSet>>)Pair.of((Object)outTraits, List.of(combination)));
        }
    }

    private static boolean fillRecursive(RelTraitSet outTraits, List<List<RelTraitSet>> inTraits, Set<Pair<RelTraitSet, List<RelTraitSet>>> result, RelTraitSet[] combination, int idx) throws ControlFlowException {
        boolean processed = false;
        boolean last = idx == inTraits.size() - 1;
        for (RelTraitSet t : inTraits.get(idx)) {
            if (t.getConvention() != IgniteConvention.INSTANCE) continue;
            processed = true;
            combination[idx] = t;
            if (last) {
                result.add((Pair<RelTraitSet, List<RelTraitSet>>)Pair.of((Object)outTraits, List.of(combination)));
                continue;
            }
            if (TraitUtils.fillRecursive(outTraits, inTraits, result, combination, idx + 1)) continue;
            return false;
        }
        return processed;
    }

    public static RelCollation createCollation(IntList keys) {
        return RelCollations.of(keys.intStream().mapToObj(TraitUtils::createFieldCollation).collect(Collectors.toList()));
    }

    public static RelCollation createCollation(Collection<Integer> keys) {
        return RelCollations.of(keys.stream().map(TraitUtils::createFieldCollation).collect(Collectors.toList()));
    }

    public static RelCollation createCollation(List<IgniteIndex.Collation> collations) {
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>(collations.size());
        for (int i = 0; i < collations.size(); ++i) {
            fieldCollations.add(TraitUtils.createFieldCollation(i, collations.get(i)));
        }
        return RelCollations.of(fieldCollations);
    }

    public static RelCollation createCollation(List<String> indexedColumns, @Nullable List<IgniteIndex.Collation> collations, TableDescriptor descriptor) {
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>(indexedColumns.size());
        if (collations == null) {
            for (int i = 0; i < indexedColumns.size(); ++i) {
                String columnName = indexedColumns.get(i);
                ColumnDescriptor columnDesc = descriptor.columnDescriptor(columnName);
                fieldCollations.add(new RelFieldCollation(columnDesc.logicalIndex(), RelFieldCollation.Direction.CLUSTERED, RelFieldCollation.NullDirection.UNSPECIFIED));
            }
            return RelCollations.of(fieldCollations);
        }
        for (int i = 0; i < indexedColumns.size(); ++i) {
            String columnName = indexedColumns.get(i);
            IgniteIndex.Collation collation = collations.get(i);
            ColumnDescriptor columnDesc = descriptor.columnDescriptor(columnName);
            fieldCollations.add(TraitUtils.createFieldCollation(columnDesc.logicalIndex(), collation));
        }
        return RelCollations.of(fieldCollations);
    }

    public static RelFieldCollation createFieldCollation(int fieldIdx) {
        return new RelFieldCollation(fieldIdx, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.LAST);
    }

    public static RelFieldCollation createFieldCollation(int fieldIdx, IgniteIndex.Collation collation) {
        switch (collation) {
            case ASC_NULLS_LAST: {
                return new RelFieldCollation(fieldIdx, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.LAST);
            }
            case ASC_NULLS_FIRST: {
                return new RelFieldCollation(fieldIdx, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.FIRST);
            }
            case DESC_NULLS_LAST: {
                return new RelFieldCollation(fieldIdx, RelFieldCollation.Direction.DESCENDING, RelFieldCollation.NullDirection.LAST);
            }
            case DESC_NULLS_FIRST: {
                return new RelFieldCollation(fieldIdx, RelFieldCollation.Direction.DESCENDING, RelFieldCollation.NullDirection.FIRST);
            }
        }
        throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, IgniteStringFormatter.format((String)"Unknown collation [collation={}]", (Object[])new Object[]{collation}));
    }

    public static boolean distributionEnabled(RelNode node) {
        return TraitUtils.distribution(node) != null;
    }

    private static Mappings.TargetMapping createProjectionMapping(int inputFieldCount, List<? extends RexNode> projects) {
        Int2IntOpenHashMap src2target = new Int2IntOpenHashMap();
        for (Ord exp : Ord.zip(projects)) {
            if (!(exp.e instanceof RexInputRef)) continue;
            src2target.putIfAbsent(((RexSlot)exp.e).getIndex(), exp.i);
        }
        return Mappings.target(src -> src2target.getOrDefault(src, -1), (int)inputFieldCount, (int)projects.size());
    }

    public static String affinityDistributionLabel(String schemaName, String tableName, String zoneName) {
        return IgniteStringFormatter.format((String)"table {} in zone {}", (Object[])new Object[]{QualifiedNameHelper.fromNormalized((String)schemaName, (String)tableName).toCanonicalForm(), IgniteNameUtils.quoteIfNeeded((String)zoneName)});
    }

    private static class PropagationContext {
        private final Set<Pair<RelTraitSet, List<RelTraitSet>>> combinations;

        private PropagationContext(Set<Pair<RelTraitSet, List<RelTraitSet>>> combinations) {
            this.combinations = combinations;
        }

        public PropagationContext propagate(TraitsPropagator processor) {
            if (this.combinations.isEmpty()) {
                return this;
            }
            HashSet<Pair<RelTraitSet, List<RelTraitSet>>> b = new HashSet<Pair<RelTraitSet, List<RelTraitSet>>>();
            for (Pair<RelTraitSet, List<RelTraitSet>> variant : this.combinations) {
                b.addAll(processor.propagate((RelTraitSet)variant.left, (List)variant.right));
            }
            return new PropagationContext(Set.copyOf(b));
        }

        public List<RelNode> nodes(RelFactory nodesCreator) {
            if (this.combinations.isEmpty()) {
                return List.of();
            }
            ArrayList<RelNode> nodes = new ArrayList<RelNode>();
            for (Pair<RelTraitSet, List<RelTraitSet>> variant : this.combinations) {
                nodes.add(nodesCreator.create((RelTraitSet)variant.left, (List)variant.right));
            }
            return List.copyOf(nodes);
        }

        public List<Pair<RelTraitSet, List<RelTraitSet>>> combinations() {
            return List.copyOf(this.combinations);
        }
    }

    private static interface TraitsPropagator {
        public List<Pair<RelTraitSet, List<RelTraitSet>>> propagate(RelTraitSet var1, List<RelTraitSet> var2);
    }
}

