/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql.rbac;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.ignite.internal.sql.engine.sql.rbac.GridgainSqlPrivileges;
import org.apache.ignite.internal.sql.engine.sql.rbac.GridgainSqlRbacDdl;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GridgainSqlGrantRevokePrivileges
extends SqlDdl
implements GridgainSqlRbacDdl {
    private final GridgainSqlPrivileges privileges;
    private final SqlNodeList rolenames;
    private final boolean isGrant;

    public GridgainSqlGrantRevokePrivileges(SqlParserPos pos, GridgainSqlPrivileges privileges, SqlNodeList rolenames, boolean isGrant) {
        super((SqlOperator)new Operator(isGrant), pos);
        this.privileges = privileges;
        this.rolenames = rolenames;
        this.isGrant = isGrant;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)((Object)this.privileges), (Object)this.rolenames);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.isGrant ? "GRANT" : "REVOKE");
        writer.keyword("PRIVILEGES");
        this.privileges.unparse(writer, leftPrec, rightPrec);
        writer.keyword(this.isGrant ? "TO" : "FROM");
        this.rolenames.unparse(writer, leftPrec, rightPrec);
    }

    public GridgainSqlPrivileges privileges() {
        return this.privileges;
    }

    public SqlNodeList rolenames() {
        return this.rolenames;
    }

    public boolean isGrant() {
        return this.isGrant;
    }

    public String toString() {
        return (this.isGrant ? "GRANT" : "REVOKE") + " PRIVILEGES " + this.privileges + (this.isGrant ? " TO " : " FROM ") + this.rolenames;
    }

    protected static class Operator
    extends SqlSpecialOperator {
        private final boolean isGrant;

        Operator(boolean isGrant) {
            super("GRANT PRIVILEGES", SqlKind.OTHER_DDL);
            this.isGrant = isGrant;
        }

        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new GridgainSqlGrantRevokePrivileges(pos, (GridgainSqlPrivileges)operands[0], (SqlNodeList)operands[1], this.isGrant);
        }
    }
}

