/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.schema;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.internal.catalog.descriptors.CatalogSecondaryStorageState;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.sql.engine.schema.AbstractIgniteDataSource;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.schema.PartitionCalculator;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class IgniteTableImpl
extends AbstractIgniteDataSource
implements IgniteTable {
    private final ImmutableIntList keyColumns;
    @Nullable
    private final ImmutableIntList columnsToInsert;
    @Nullable
    private final ImmutableIntList columnsToUpdate;
    private final Map<String, IgniteIndex> indexMap;
    private final int partitions;
    private final int zoneId;
    private final Lazy<NativeType[]> colocationColumnTypes;
    private final boolean cache;
    @Nullable
    private final Integer secondaryZoneId;
    private final boolean useSecondaryStorage;
    private final IgniteDistribution secondaryDistribution;
    private final CatalogSecondaryStorageState secondaryStorageState;

    public IgniteTableImpl(String name, int id, int version, long timestamp, TableDescriptor desc, ImmutableIntList keyColumns, Statistic statistic, Map<String, IgniteIndex> indexMap, int partitions, int zoneId, boolean cache, @Nullable Integer secondaryZoneId, @Nullable IgniteDistribution secondaryDistribution, CatalogSecondaryStorageState secondaryStorageState) {
        this(name, id, version, timestamp, desc, keyColumns, statistic, indexMap, partitions, zoneId, cache, secondaryZoneId, secondaryDistribution, secondaryStorageState, false);
    }

    private IgniteTableImpl(String name, int id, int version, long timestamp, TableDescriptor desc, ImmutableIntList keyColumns, Statistic statistic, Map<String, IgniteIndex> indexMap, int partitions, int zoneId, boolean cache, @Nullable Integer secondaryZoneId, @Nullable IgniteDistribution secondaryDistribution, CatalogSecondaryStorageState secondaryStorageState, boolean useSecondaryStorage) {
        super(name, id, version, timestamp, desc, statistic);
        this.secondaryZoneId = secondaryZoneId;
        this.secondaryDistribution = secondaryDistribution;
        this.secondaryStorageState = secondaryStorageState;
        this.keyColumns = keyColumns;
        this.indexMap = indexMap;
        this.partitions = partitions;
        this.zoneId = zoneId;
        this.columnsToInsert = IgniteTableImpl.deriveColumnsToInsert(desc);
        this.columnsToUpdate = IgniteTableImpl.deriveColumnsToUpdate(desc);
        this.cache = cache;
        this.colocationColumnTypes = new Lazy(this::evaluateTypes);
        this.useSecondaryStorage = useSecondaryStorage;
    }

    @Nullable
    private static ImmutableIntList deriveColumnsToInsert(TableDescriptor desc) {
        if (!desc.hasHiddenColumns()) {
            return null;
        }
        IntArrayList columnsToInsert = new IntArrayList(desc.columnsCount());
        for (ColumnDescriptor columnDescriptor : desc) {
            if (columnDescriptor.hidden()) continue;
            columnsToInsert.add(columnDescriptor.logicalIndex());
        }
        return ImmutableIntList.of((int[])columnsToInsert.toIntArray());
    }

    @Nullable
    private static ImmutableIntList deriveColumnsToUpdate(TableDescriptor desc) {
        if (!desc.hasVirtualColumns()) {
            return null;
        }
        IntArrayList columnsToUpdate = new IntArrayList(desc.columnsCount());
        for (ColumnDescriptor columnDescriptor : desc) {
            if (columnDescriptor.virtual()) continue;
            columnsToUpdate.add(columnDescriptor.logicalIndex());
        }
        return ImmutableIntList.of((int[])columnsToUpdate.toIntArray());
    }

    @Override
    public Supplier<PartitionCalculator> partitionCalculator() {
        return () -> new PartitionCalculator(this.partitions, Objects.requireNonNull((NativeType[])this.colocationColumnTypes.get()));
    }

    private NativeType[] evaluateTypes() {
        int fieldCnt = this.descriptor().distribution().getKeys().size();
        NativeType[] fieldTypes = new NativeType[fieldCnt];
        int[] colocationColumns = this.descriptor().distribution().getKeys().toIntArray();
        for (int i = 0; i < fieldCnt; ++i) {
            ColumnDescriptor colDesc = this.descriptor().columnDescriptor(colocationColumns[i]);
            fieldTypes[i] = colDesc.physicalType();
        }
        return fieldTypes;
    }

    @Override
    public Map<String, IgniteIndex> indexes() {
        return this.indexMap;
    }

    @Override
    public int partitions() {
        return this.partitions;
    }

    @Override
    public int zoneId() {
        return this.zoneId;
    }

    @Override
    public boolean cache() {
        return this.cache;
    }

    @Override
    @Nullable
    public Integer secondaryZoneId() {
        return this.secondaryZoneId;
    }

    @Override
    public CatalogSecondaryStorageState secondaryStorageState() {
        return this.secondaryStorageState;
    }

    @Override
    public boolean useSecondaryStorage() {
        return this.useSecondaryStorage;
    }

    @Override
    public ImmutableIntList keyColumns() {
        return this.keyColumns;
    }

    @Override
    protected TableScan toRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable relOptTbl, List<RelHint> hints) {
        return IgniteLogicalTableScan.create(cluster, traitSet, hints, relOptTbl, null, null, null, null);
    }

    @Override
    public boolean isUpdateAllowed(int colIdx) {
        ColumnDescriptor columnDescriptor = this.descriptor().columnDescriptor(colIdx);
        return !columnDescriptor.key() && !columnDescriptor.virtual();
    }

    @Override
    public RelDataType rowTypeForInsert(IgniteTypeFactory factory) {
        return this.descriptor().rowType(factory, this.columnsToInsert);
    }

    @Override
    public RelDataType rowTypeForUpdate(IgniteTypeFactory factory) {
        return this.descriptor().rowType(factory, this.columnsToUpdate);
    }

    @Override
    public RelDataType rowTypeForDelete(IgniteTypeFactory factory) {
        return this.descriptor().rowType(factory, this.keyColumns);
    }

    @Override
    public IgniteTable cloneForSecondaryStorage() {
        assert (this.secondaryZoneId != null);
        assert (this.secondaryDistribution != null);
        TableDescriptor descriptor = this.descriptor().cloneWithNewDistribution(this.secondaryDistribution);
        return new IgniteTableImpl(this.name(), this.id(), this.version(), this.timestamp(), descriptor, this.keyColumns, this.getStatistic(), this.indexMap, this.partitions, this.zoneId, this.cache, this.secondaryZoneId, this.secondaryDistribution, this.secondaryStorageState, true);
    }
}

