/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare.copy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.ignite.internal.sql.engine.prepare.PlanningContext;
import org.apache.ignite.internal.sql.engine.prepare.copy.CopyCommand;
import org.apache.ignite.internal.sql.engine.prepare.copy.CopyLocation;
import org.apache.ignite.internal.sql.engine.prepare.copy.CopyLocationPath;
import org.apache.ignite.internal.sql.engine.prepare.copy.CopyLocationSelect;
import org.apache.ignite.internal.sql.engine.prepare.copy.CopyLocationTable;
import org.apache.ignite.internal.sql.engine.sql.copy.GridgainSqlCopy;
import org.apache.ignite.internal.sql.engine.sql.copy.GridgainSqlCopyLocationTable;
import org.apache.ignite.internal.sql.engine.sql.copy.GridgainSqlCopyOption;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.SchemaNotFoundException;
import org.apache.ignite.sql.SqlException;

public class CopySqlToCommandConverter {
    public CopyCommand convert(GridgainSqlCopy copyNode, PlanningContext ctx) {
        if (copyNode != null) {
            return this.convertCopy(copyNode, ctx);
        }
        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unsupported operation [sqlNodeKind=" + copyNode.getKind() + "; querySql=\"" + ctx.query() + "\"]");
    }

    private CopyCommand convertCopy(GridgainSqlCopy copyNode, PlanningContext ctx) {
        CopyCommand command = new CopyCommand();
        command.format(copyNode.getFormat());
        command.from(this.convertLocation(copyNode.getFrom(), ctx));
        command.into(this.convertLocation(copyNode.getInto(), ctx));
        command.properties(this.convertProperties(copyNode.getOptionList()));
        if (command.from().getClass().equals(command.into().getClass())) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unsupported same directions [sqlNodeKind=" + copyNode.getKind() + "; querySql=\"" + ctx.query() + "\"]");
        }
        return command;
    }

    private CopyLocation convertLocation(SqlNode node, PlanningContext ctx) {
        if (node instanceof SqlCharStringLiteral) {
            String path = (String)((SqlCharStringLiteral)node).getValueAs(String.class);
            return new CopyLocationPath().path(path);
        }
        if (node instanceof GridgainSqlCopyLocationTable) {
            GridgainSqlCopyLocationTable sqlTable = (GridgainSqlCopyLocationTable)node;
            String schemaName = this.convertSchemaName(sqlTable.tableName(), ctx);
            String tableName = this.convertObjectName(sqlTable.tableName(), ctx);
            List<String> columns = this.convertColumnNames(sqlTable.columnList());
            return new CopyLocationTable().schemaName(schemaName).tableName(tableName).columns(columns);
        }
        if (node instanceof SqlSelect) {
            return new CopyLocationSelect().selectNode((SqlSelect)node);
        }
        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unsupported location [sqlNodeKind=" + node.getKind() + "; querySql=\"" + node + "\"]");
    }

    private Map<String, String> convertProperties(SqlNodeList list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (SqlNode sqlNode : list) {
            if (!(sqlNode instanceof GridgainSqlCopyOption) || !(((GridgainSqlCopyOption)sqlNode).key() instanceof SqlLiteral) || !(((GridgainSqlCopyOption)sqlNode).value() instanceof SqlLiteral)) continue;
            GridgainSqlCopyOption o = (GridgainSqlCopyOption)sqlNode;
            String key = (String)((SqlLiteral)o.key()).getValueAs(String.class);
            String value = (String)((SqlLiteral)o.value()).getValueAs(String.class);
            map.put(key, value);
        }
        return Map.copyOf(map);
    }

    private String convertSchemaName(SqlIdentifier id, PlanningContext ctx) {
        String schemaName;
        if (id.isSimple()) {
            schemaName = ctx.schemaName();
        } else {
            SqlIdentifier schemaId = id.skipLast(1);
            if (!schemaId.isSimple()) {
                throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unexpected value of schemaName [expected a simple identifier, but was " + schemaId + "; querySql=\"" + ctx.query() + "\"]");
            }
            schemaName = schemaId.getSimple();
        }
        this.ensureSchemaExists(ctx, schemaName);
        return schemaName;
    }

    private String convertObjectName(SqlIdentifier id, PlanningContext ctx) {
        if (id.isSimple()) {
            return id.getSimple();
        }
        SqlIdentifier objId = id.getComponent(id.skipLast((int)1).names.size());
        if (!objId.isSimple()) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unexpected value [expected a simple identifier, but was " + objId + "; querySql=\"" + ctx.query() + "\"]");
        }
        return objId.getSimple();
    }

    private void ensureSchemaExists(PlanningContext ctx, String schemaName) {
        if (ctx.catalogReader().getRootSchema().getSubSchema(schemaName, true) == null) {
            throw new SchemaNotFoundException(schemaName);
        }
    }

    private List<String> convertColumnNames(SqlNodeList list) {
        ArrayList<String> columns = new ArrayList<String>(list.size());
        for (SqlNode col : list.getList()) {
            columns.add(((SqlIdentifier)col).getSimple());
        }
        return columns;
    }
}

