/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.sql.engine.message.QueryStartRequestV2;
import org.apache.ignite.internal.sql.engine.message.QueryStartRequestV2Builder;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesFactory;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesTypeInfos;

class QueryStartRequestV2Deserializer
implements MessageDeserializer<QueryStartRequestV2> {
    private final QueryStartRequestV2Builder msg;

    QueryStartRequestV2Deserializer(SqlQueryMessagesFactory messageFactory) {
        this.msg = messageFactory.queryStartRequestV2();
    }

    public Class<QueryStartRequestV2> klass() {
        return QueryStartRequestV2.class;
    }

    public QueryStartRequestV2 getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(SqlQueryMessagesTypeInfos.queryStartRequestV2());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("catalogVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.catalogVersion(tmp);
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("executionToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.executionToken(tmp);
                reader.incrementState();
            }
            case 2: {
                byte[] tmp = reader.readByteArray("fragmentDescriptionByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.fragmentDescriptionByteArray(tmp);
                }
                reader.incrementState();
            }
            case 3: {
                long tmp = reader.readLong("fragmentId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.fragmentId(tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readHybridTimestamp("operationTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.operationTime((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readByteArray("parametersByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.parametersByteArray((byte[])tmp);
                }
                reader.incrementState();
            }
            case 6: {
                Object tmp = reader.readUuid("queryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.queryId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 7: {
                Object tmp = reader.readString("root");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.root((String)tmp);
                }
                reader.incrementState();
            }
            case 8: {
                Object tmp = reader.readString("timeZoneId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timeZoneId((String)tmp);
                }
                reader.incrementState();
            }
            case 9: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 10: {
                Object tmp = reader.readByteArray("txAttributesByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txAttributesByteArray((byte[])tmp);
                }
                reader.incrementState();
            }
            case 11: {
                Object tmp = reader.readString("username");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.username((String)tmp);
                }
                reader.incrementState();
            }
            case 12: {
                Object tmp = reader.readBoxedLong("topologyVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.topologyVersion((Long)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(QueryStartRequestV2.class);
    }
}

