/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.sql.engine.message.QueryBatchMessage;
import org.apache.ignite.internal.sql.engine.message.QueryBatchMessageImpl;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesTypeInfos;

class QueryBatchMessageSerializer
implements MessageSerializer<QueryBatchMessage> {
    public static final QueryBatchMessageSerializer INSTANCE = new QueryBatchMessageSerializer();

    private QueryBatchMessageSerializer() {
    }

    public boolean writeMessage(QueryBatchMessage msg, MessageWriter writer) throws MessageMappingException {
        QueryBatchMessageImpl message = (QueryBatchMessageImpl)msg;
        writer.setMessageTypeInfo(SqlQueryMessagesTypeInfos.queryBatchMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)8)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeInt("batchId", message.batchId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeLong("exchangeId", message.exchangeId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeInt("executionToken", message.executionToken());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeLong("fragmentId", message.fragmentId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeBoolean("last", message.last());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeUuid("queryId", message.queryId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeList("rows", message.rows(), MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                boolean written = writer.writeHybridTimestamp("timestamp", message.timestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

